/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.net.URL;
import java.util.IdentityHashMap;

public class MsgLocalizationClassLoader {
    static final CallStack csi = new CallStack();
    private static final CallClimbingClassLoader MSG_LOCALIZATION_CLASS_LOADER = new CallClimbingClassLoader();

    public static URL getResource(String name) {
        return MSG_LOCALIZATION_CLASS_LOADER.getResource(name);
    }

    public static ClassLoader getMsgLocalizationClassLoader() {
        return MSG_LOCALIZATION_CLASS_LOADER;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        return MSG_LOCALIZATION_CLASS_LOADER.loadClass(name);
    }

    static class CallClimbingClassLoader
    extends ClassLoader {
        CallClimbingClassLoader() {
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            IdentityHashMap<ClassLoader, ClassLoader> alreadySearched = new IdentityHashMap<ClassLoader, ClassLoader>(7);
            Class<?>[] cs = new CallStack().getCallStack();
            for (int i = 3; i < cs.length; ++i) {
                Class<?> callingClass = cs[i];
                ClassLoader cl = callingClass.getClassLoader();
                if (null == cl) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if (null != alreadySearched.get(cl)) continue;
                alreadySearched.put(cl, cl);
                Class<?> c = null;
                try {
                    c = cl.loadClass(name);
                    return c;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            IdentityHashMap<ClassLoader, ClassLoader> alreadySearched = new IdentityHashMap<ClassLoader, ClassLoader>(7);
            Class<?>[] cs = new CallStack().getCallStack();
            for (int i = 3; i < cs.length; ++i) {
                Class<?> callingClass = cs[i];
                ClassLoader cl = callingClass.getClassLoader();
                if (null == cl) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if (null != alreadySearched.get(cl)) continue;
                alreadySearched.put(cl, cl);
                URL c = cl.getResource(name);
                if (null == c) continue;
                return c;
            }
            return null;
        }
    }

    static class CallStack
    extends SecurityManager {
        CallStack() {
        }

        Class<?>[] getCallStack() {
            return this.getClassContext();
        }
    }
}

