/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.ResultNotSupportedException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.impl.ResultSpecification_impl;
import org.apache.uima.analysis_engine.impl.compatibility.AnalysisComponentAdapterFactory;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.impl.UimaContext_ImplBase;
import org.apache.uima.impl.Util;
import org.apache.uima.internal.util.UUIDGenerator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class PrimitiveAnalysisEngine_impl
extends AnalysisEngineImplBase
implements AnalysisEngine {
    private static final Class<PrimitiveAnalysisEngine_impl> CLASS_NAME = PrimitiveAnalysisEngine_impl.class;
    public static final boolean INIT_THREADSAFE = true;
    private ResultSpecification mCurrentResultSpecification;
    private ResultSpecification rsFromOutputCapabilities;
    private boolean mResultSpecChanged;
    private TypeSystem mLastTypeSystem;
    private ResourceCreationSpecifier mDescription;
    private AnalysisComponent mAnalysisComponent;
    private boolean mVerificationMode = false;
    private boolean mSofaAware;

    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        try {
            if (!(aSpecifier instanceof ResourceCreationSpecifier)) {
                return false;
            }
            if (aSpecifier instanceof AnalysisEngineDescription && !((AnalysisEngineDescription)aSpecifier).isPrimitive()) {
                return false;
            }
            this.mDescription = (ResourceCreationSpecifier)aSpecifier;
            String fwImpl = this.mDescription.getFrameworkImplementation();
            if (!fwImpl.startsWith("org.apache.uima.java")) {
                return false;
            }
            super.initialize(aSpecifier, aAdditionalParams);
            ProcessingResourceMetaData md = (ProcessingResourceMetaData)this.mDescription.getMetaData();
            if (null == md) {
                md = UIMAFramework.getResourceSpecifierFactory().createProcessingResourceMetaData();
                md.setName("(null)");
            }
            Logger logger = this.getLogger();
            logger.logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_begin__CONFIG", md.getName());
            this.normalizeIsoLangCodes(md);
            ResourceMetaData mdCopy = (ResourceMetaData)md.clone();
            if (mdCopy.getUUID() == null) {
                mdCopy.setUUID(UUIDGenerator.generate());
            }
            this.setMetaData(mdCopy);
            this.mDescription.validate(this.getResourceManager());
            if (aAdditionalParams == null) {
                aAdditionalParams = Collections.emptyMap();
            }
            this.mVerificationMode = aAdditionalParams.containsKey("VERIFICATION_MODE");
            this.mSofaAware = this.getAnalysisEngineMetaData().isSofaAware();
            this.initializeAnalysisComponent(aAdditionalParams);
            this.resetResultSpecificationToDefault();
            logger.logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_successful__CONFIG", md.getName());
            return true;
        }
        catch (ResourceConfigurationException e) {
            throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{this.getMetaData().getName(), aSpecifier.getSourceUrlString()});
        }
    }

    protected void initializeAnalysisComponent(Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        String annotatorClassName = this.mDescription.getImplementationName();
        if (annotatorClassName == null || annotatorClassName.length() == 0) {
            throw new ResourceInitializationException("missing_annotator_class_name", new Object[]{this.mDescription.getSourceUrlString()});
        }
        Class<?> annotatorClass = null;
        try {
            ClassLoader cl = this.getUimaContextAdmin().getResourceManager().getExtensionClassLoader();
            annotatorClass = cl != null ? cl.loadClass(annotatorClassName) : Class.forName(annotatorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException("annotator_class_not_found", new Object[]{annotatorClassName, this.mDescription.getSourceUrlString()}, e);
        }
        if (!AnalysisComponent.class.isAssignableFrom(annotatorClass) && !AnalysisComponentAdapterFactory.isAdaptable(annotatorClass)) {
            throw new ResourceInitializationException("not_an_analysis_component", new Object[]{annotatorClass.getName(), this.mDescription.getSourceUrlString()});
        }
        if (this.mVerificationMode) {
            return;
        }
        try {
            Object userObject = annotatorClass.newInstance();
            this.mAnalysisComponent = userObject instanceof AnalysisComponent ? (AnalysisComponent)userObject : AnalysisComponentAdapterFactory.createAdapter(userObject, this.getAnalysisEngineMetaData(), aAdditionalParams);
        }
        catch (ResourceInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceInitializationException("could_not_instantiate_annotator", new Object[]{annotatorClassName, this.mDescription.getSourceUrlString()}, e);
        }
        UimaContextAdmin uimaContext = this.getUimaContextAdmin();
        Logger logger = UIMAFramework.getLogger(annotatorClass);
        logger.setResourceManager(this.getResourceManager());
        uimaContext.setLogger(logger);
        try {
            this.mAnalysisComponent.initialize(this.getUimaContext());
        }
        catch (Exception e) {
            throw new ResourceInitializationException("annotator_initialization_failed", new Object[]{annotatorClassName, this.mDescription.getSourceUrlString()}, e);
        }
        this.getUimaContextAdmin().defineCasPool(this.mAnalysisComponent.getCasInstancesRequired(), this.getPerformanceTuningSettings(), this.mSofaAware);
    }

    @Override
    public void destroy() {
        if (this.mAnalysisComponent != null) {
            this.mAnalysisComponent.destroy();
            this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "destroy", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_destroyed__CONFIG", this.getMetaData().getName());
        }
        super.destroy();
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
        if (aResultSpec == null) {
            this.resetResultSpecificationToDefault();
        } else {
            this.mCurrentResultSpecification = aResultSpec;
            this.mResultSpecChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        this.enterProcess();
        try {
            this.callAnalysisComponentProcess(aCAS);
            AnalysisComponentCasIterator analysisComponentCasIterator = new AnalysisComponentCasIterator(this.mAnalysisComponent, aCAS);
            return analysisComponentCasIterator;
        }
        finally {
            this.exitProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        this.enterBatchProcessComplete();
        try {
            this.getAnalysisComponent().batchProcessComplete();
        }
        finally {
            this.exitBatchProcessComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.enterCollectionProcessComplete();
        try {
            this.getAnalysisComponent().collectionProcessComplete();
        }
        finally {
            this.exitCollectionProcessComplete();
        }
    }

    protected void callAnalysisComponentProcess(CAS aCAS) throws AnalysisEngineProcessException {
        String resourceName = this.getMetaData().getName();
        Logger logger = this.getLogger();
        logger.logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_begin__FINE", resourceName);
        try {
            CASImpl view = null;
            try {
                view = Util.getStartingView(aCAS, this.mSofaAware, this.getUimaContextAdmin().getComponentInfo());
                Class<? extends AbstractCas> requiredInterface = this.mAnalysisComponent.getRequiredCasInterface();
                AbstractCas casToPass = this.getCasManager().getCasInterface(view, requiredInterface);
                if (this.mResultSpecChanged || this.mLastTypeSystem != view.getTypeSystem()) {
                    if (this.mLastTypeSystem != view.getTypeSystem()) {
                        this.mLastTypeSystem = view.getTypeSystem();
                        this.mCurrentResultSpecification.setTypeSystem(this.mLastTypeSystem);
                        this.rsFromOutputCapabilities = new ResultSpecification_impl(this.mLastTypeSystem);
                        this.rsFromOutputCapabilities.addCapabilities(this.getAnalysisEngineMetaData().getCapabilities());
                    }
                    ResultSpecification_impl analysisComponentResultSpec = ((ResultSpecification_impl)this.mCurrentResultSpecification).intersect((ResultSpecification_impl)this.rsFromOutputCapabilities);
                    this.mAnalysisComponent.setResultSpecification(analysisComponentResultSpec);
                    this.mResultSpecChanged = false;
                }
                view.switchClassLoaderLockCasCL(this.getResourceManager().getExtensionClassLoader());
                this.mAnalysisComponent.process(casToPass);
                this.getMBean().incrementCASesProcessed();
            }
            catch (Exception e) {
                if (null != view) {
                    view.setCurrentComponentInfo(null);
                    view.restoreClassLoaderUnlockCas();
                }
                if (e instanceof AnalysisEngineProcessException) {
                    throw (AnalysisEngineProcessException)e;
                }
                throw new AnalysisEngineProcessException("annotator_exception", null, e);
            }
            catch (Error e) {
                if (null != view) {
                    view.setCurrentComponentInfo(null);
                    view.restoreClassLoaderUnlockCas();
                }
                throw e;
            }
            logger.logrb(Level.FINE, CLASS_NAME.getName(), "process", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_end__FINE", resourceName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            if (e instanceof AnalysisEngineProcessException) {
                throw (AnalysisEngineProcessException)e;
            }
            throw new AnalysisEngineProcessException(e);
        }
    }

    protected CAS callAnalysisComponentNext() throws AnalysisEngineProcessException, ResultNotSupportedException {
        try {
            AbstractCas absCas = this.mAnalysisComponent.next();
            this.getMBean().incrementCASesProcessed();
            ((UimaContext_ImplBase)this.getUimaContext()).returnedCAS(absCas);
            CAS casToReturn = absCas instanceof JCas ? ((JCas)absCas).getCas() : (CAS)absCas;
            casToReturn = casToReturn.getView("_InitialView");
            casToReturn.setCurrentComponentInfo(null);
            ((CASImpl)casToReturn).restoreClassLoaderUnlockCas();
            return casToReturn;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "", e);
            if (e instanceof AnalysisEngineProcessException) {
                throw (AnalysisEngineProcessException)e;
            }
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        super.reconfigure();
        try {
            this.mAnalysisComponent.reconfigure();
        }
        catch (ResourceInitializationException e) {
            throw new ResourceConfigurationException(e);
        }
    }

    protected AnalysisComponent getAnalysisComponent() {
        return this.mAnalysisComponent;
    }

    class AnalysisComponentCasIterator
    implements CasIterator {
        private AnalysisComponent mMyAnalysisComponent;
        private CAS mInputCas;
        private boolean casAvailable;

        AnalysisComponentCasIterator(AnalysisComponent aAnalysisComponent, CAS aInputCas) {
            this.mMyAnalysisComponent = aAnalysisComponent;
            this.mInputCas = aInputCas;
            this.casAvailable = false;
        }

        @Override
        public boolean hasNext() throws AnalysisEngineProcessException {
            PrimitiveAnalysisEngine_impl.this.enterProcess();
            if (this.casAvailable) {
                return true;
            }
            try {
                this.casAvailable = this.mMyAnalysisComponent.hasNext();
                if (!this.casAvailable) {
                    this.mInputCas.setCurrentComponentInfo(null);
                    ((CASImpl)this.mInputCas).restoreClassLoaderUnlockCas();
                }
                boolean bl = this.casAvailable;
                return bl;
            }
            catch (Exception e) {
                ((CASImpl)this.mInputCas).restoreClassLoaderUnlockCas();
                if (e instanceof AnalysisEngineProcessException) {
                    throw (AnalysisEngineProcessException)e;
                }
                throw new AnalysisEngineProcessException(e);
            }
            finally {
                PrimitiveAnalysisEngine_impl.this.exitProcess();
            }
        }

        @Override
        public CAS next() throws AnalysisEngineProcessException {
            PrimitiveAnalysisEngine_impl.this.enterProcess();
            try {
                if (!this.casAvailable) {
                    throw new UIMA_IllegalStateException("no_next_cas", new Object[0]);
                }
                this.casAvailable = false;
                try {
                    CAS cas;
                    CAS cAS = cas = PrimitiveAnalysisEngine_impl.this.callAnalysisComponentNext();
                    return cAS;
                }
                catch (Exception e) {
                    ((CASImpl)this.mInputCas).restoreClassLoaderUnlockCas();
                    if (e instanceof AnalysisEngineProcessException) {
                        throw (AnalysisEngineProcessException)e;
                    }
                    throw new AnalysisEngineProcessException(e);
                }
            }
            finally {
                PrimitiveAnalysisEngine_impl.this.exitProcess();
            }
        }

        @Override
        public void release() {
        }
    }
}

