/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.verb;

import com.google.common.collect.Iterables;
import edu.stanford.nlp.ling.CoreLabel;
import eu.fbk.dh.tint.verb.VerbModel;
import eu.fbk.utils.corenlp.CustomAnnotations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VerbMultiToken {
    List<CoreLabel> tokens = new ArrayList<CoreLabel>();
    boolean isPassive = false;
    String tense;
    String mood;
    Integer person = null;
    String gender = null;
    String number = null;

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public String getTense() {
        return this.tense;
    }

    public String getMood() {
        return this.mood;
    }

    public Integer getPerson() {
        return this.person;
    }

    public String getGender() {
        return this.gender;
    }

    public List<CoreLabel> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<CoreLabel> tokens) {
        this.tokens = tokens;
    }

    public void addToken(VerbModel model, CoreLabel token) {
        this.addToken(model, token, false);
    }

    public void addToken(VerbModel model, CoreLabel token, boolean last) {
        this.tokens.add(token);
        Map features = (Map)token.get(CustomAnnotations.FeaturesAnnotation.class);
        try {
            this.gender = (String)Iterables.getFirst((Iterable)((Iterable)features.get("Gender")), null);
        }
        catch (NullPointerException e) {
            this.gender = null;
        }
        if (last) {
            String lemma = this.tokens.get(this.tokens.size() - 1).lemma();
            boolean isTransitive = false;
            if (model.getTransitiveVerbs().contains(lemma)) {
                isTransitive = true;
            }
            switch (this.tokens.size()) {
                case 1: {
                    this.setTense(this.tokens.get(0));
                    this.isPassive = false;
                    try {
                        if (isTransitive && this.mood.equals("Part") && this.tense.equals("Past")) {
                            this.isPassive = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mood == null || !this.mood.equals("Ger")) break;
                    this.tense = "Pres";
                    break;
                }
                case 2: {
                    String auxLemma = this.tokens.get(0).lemma();
                    this.isPassive = auxLemma.equals("avere") ? false : isTransitive;
                    this.setTense(this.tokens.get(0));
                    if (!this.isPassive) {
                        try {
                            this.addStep();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    if (this.mood == null || !this.mood.equals("Ger")) break;
                    if (this.isPassive) {
                        this.tense = "Pres";
                        break;
                    }
                    this.tense = "Past";
                    break;
                }
                default: {
                    this.isPassive = true;
                    this.setTense(this.tokens.get(0));
                    if (this.mood != null && this.mood.equals("Ger")) {
                        this.tense = "Past";
                    }
                    this.addStep();
                }
            }
        }
    }

    private void addStep() throws NullPointerException {
        if (this.tense == null) {
            return;
        }
        block4 : switch (this.mood) {
            case "Ind": 
            case "Conj": {
                switch (this.tense) {
                    case "Pres": {
                        this.tense = "PrPast";
                        break block4;
                    }
                    case "Imp": {
                        this.tense = "TrPast";
                        break block4;
                    }
                    case "Past": {
                        this.tense = "RemPast";
                        break block4;
                    }
                    case "Fut": {
                        this.tense = "AntFut";
                    }
                }
            }
        }
        switch (this.tense) {
            case "Pres": {
                this.tense = "Past";
            }
        }
    }

    private void setTense(CoreLabel coreLabel) {
        Map features = (Map)coreLabel.get(CustomAnnotations.FeaturesAnnotation.class);
        try {
            this.tense = (String)Iterables.getFirst((Iterable)((Iterable)features.get("Tense")), null);
        }
        catch (NullPointerException e) {
            this.tense = null;
        }
        try {
            this.mood = (String)Iterables.getFirst((Iterable)((Iterable)features.get("Mood")), null);
        }
        catch (NullPointerException e) {
            this.mood = null;
        }
        if (this.mood == null) {
            try {
                this.mood = (String)Iterables.getFirst((Iterable)((Iterable)features.get("VerbForm")), null);
            }
            catch (NullPointerException e) {
                this.mood = null;
            }
        }
        if (this.mood != null && this.mood.equals("Sub")) {
            this.mood = "Conj";
        }
        String txtPerson = null;
        try {
            txtPerson = (String)Iterables.getFirst((Iterable)((Iterable)features.get("Person")), null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.number = (String)Iterables.getFirst((Iterable)((Iterable)features.get("Number")), null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (txtPerson != null) {
            this.person = Integer.parseInt(txtPerson);
        }
    }

    public String getString() {
        StringBuilder buffer = new StringBuilder();
        for (CoreLabel token : this.tokens) {
            buffer.append(token.originalText()).append(" ");
        }
        return buffer.toString().trim();
    }

    public String toString() {
        return "VerbMultiToken{tokens=" + this.tokens + ", isPassive=" + this.isPassive + ", tense='" + this.tense + '\'' + ", mood='" + this.mood + '\'' + ", person=" + this.person + ", gender='" + this.gender + '\'' + '}';
    }
}

