/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.verb;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.verb.VerbAnnotations;
import eu.fbk.dh.tint.verb.VerbModel;
import eu.fbk.dh.tint.verb.VerbMultiToken;
import eu.fbk.utils.core.PropertiesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class VerbAnnotator
implements Annotator {
    private static final boolean DEFAULT_USE_PREFIX = true;
    private static final boolean DEFAULT_MODAL_IS_PREFIX = true;
    private static final boolean DEFAULT_AUX_IS_PREFIX = true;
    private static final String DEFAULT_SKIP_TAGS = "B";
    private static final String DEFAULT_VERB_TAGS = "V";
    private static final String DEFAULT_AUX_TAGS = "VA";
    private static final String DEFAULT_MODAL_TAGS = "VM";
    private boolean usePrefix;
    private boolean modalUsePrefix;
    private boolean auxUsePrefix;
    private List<String> skipTags;
    private List<String> verbTags;
    private List<String> modalTags;
    private List<String> auxTags;
    private VerbModel model;

    public VerbAnnotator(String annotatorName, Properties prop) {
        this.usePrefix = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".use_prefix"), (boolean)true);
        this.auxUsePrefix = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".aux_is_prefix"), (boolean)true);
        this.modalUsePrefix = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".modal_is_prefix"), (boolean)true);
        String skipTagsText = prop.getProperty(annotatorName + ".skip_tags", DEFAULT_SKIP_TAGS);
        String verbTagsText = prop.getProperty(annotatorName + ".verb_tags", DEFAULT_VERB_TAGS);
        String auxTagsText = prop.getProperty(annotatorName + ".aux_tags", DEFAULT_AUX_TAGS);
        String modalTagsText = prop.getProperty(annotatorName + ".modal_tags", DEFAULT_MODAL_TAGS);
        this.model = VerbModel.getInstance();
        this.skipTags = new ArrayList<String>();
        this.verbTags = new ArrayList<String>();
        this.modalTags = new ArrayList<String>();
        this.auxTags = new ArrayList<String>();
        VerbAnnotator.splitParts(skipTagsText, this.skipTags);
        VerbAnnotator.splitParts(verbTagsText, this.verbTags);
        VerbAnnotator.splitParts(modalTagsText, this.modalTags);
        VerbAnnotator.splitParts(auxTagsText, this.auxTags);
    }

    private static void splitParts(String text, List<String> tags) {
        String[] sParts;
        for (String sPart : sParts = text.split("\\s*,\\s*")) {
            tags.add(sPart);
        }
    }

    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                ArrayList<Object> lastVerb = new ArrayList<CoreLabel>();
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                boolean followedByExMark = ((CoreLabel)tokens.get(tokens.size() - 1)).word().equals("!");
                ArrayList<VerbMultiToken> verbs = new ArrayList<VerbMultiToken>();
                for (int i = 0; i < tokens.size(); ++i) {
                    CoreLabel token = (CoreLabel)tokens.get(i);
                    String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    if (VerbAnnotator.isSatisfied(pos, this.verbTags, this.usePrefix) || VerbAnnotator.isSatisfied(pos, this.modalTags, this.modalUsePrefix)) {
                        lastVerb.add(token);
                    }
                    if (VerbAnnotator.isSatisfied(pos, this.skipTags, this.usePrefix) || VerbAnnotator.isSatisfied(pos, this.auxTags, this.auxUsePrefix) || lastVerb.size() <= 0) continue;
                    this.addVerbs(lastVerb, verbs, followedByExMark);
                    lastVerb = new ArrayList();
                }
                if (lastVerb.size() > 0) {
                    this.addVerbs(lastVerb, verbs, followedByExMark);
                }
                sentence.set(VerbAnnotations.VerbsAnnotation.class, verbs);
            }
        }
    }

    private void addVerbs(List<CoreLabel> lastVerb, List<VerbMultiToken> verbs, boolean followedByExMark) {
        VerbMultiToken multiToken = new VerbMultiToken();
        for (int i = 0; i < lastVerb.size(); ++i) {
            CoreLabel verb = lastVerb.get(i);
            boolean last = i == lastVerb.size() - 1;
            multiToken.addToken(this.model, verb, last);
        }
        verbs.add(multiToken);
    }

    private static boolean isSatisfied(String pos, List<String> tags, boolean usePrefix) {
        boolean ret = false;
        pos = pos.toLowerCase();
        if (usePrefix) {
            for (String tag : tags) {
                if (!pos.startsWith(tag = tag.toLowerCase())) continue;
                ret = true;
            }
        } else {
            for (String tag : tags) {
                if (!pos.equals(tag = tag.toLowerCase())) continue;
                ret = true;
            }
        }
        return ret;
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(VerbAnnotations.VerbsAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }
}

