/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import jvntextpro.util.TONE;

public class VnSyllParser {
    private static final String vnFirstConsonants = "ngh|ng|gh|ph|ch|tr|nh|kh|th|m|b|v|t|\u0111|n|x|s|l|h|r|d|gi|g|q|k|c";
    private static final String vnLastConsonants = "ng|nh|ch|p|t|c|m|n|u|o|y|i";
    private static final String vnMainVowels = "i\u00ea|y\u00ea|ia|ya|\u01b0\u01a1|\u01b0a|u\u00f4|ua|oo|\u00ea|e|a|\u01b0|\u0103|o|\u01a1|\u00e2|\u00f4|u|i|y|";
    private static final String vnSecondaryVowels = "o|u";
    public static final String ZERO = "";
    private static String vnVowels = "a\u00e1\u00e0\u1ea3\u00e3\u1ea1\u0103\u1eaf\u1eb1\u1eb3\u1eb5\u1eb7\u00e2\u1ea5\u1ea7\u1ea9\u1eab\u1eade\u00e9\u00e8\u1ebb\u1ebd\u1eb9\u00ea\u1ebf\u1ec1\u1ec3\u1ec5\u1ec7i\u00ed\u00ec\u1ec9\u0129\u1ecbo\u00f3\u00f2\u1ecf\u00f5\u1ecd\u00f4\u1ed1\u1ed3\u1ed5\u1ed7\u1ed9\u01a1\u1edb\u1edd\u1edf\u1ee1\u1ee3u\u00fa\u00f9\u1ee7\u0169\u1ee5\u01b0\u1ee9\u1eeb\u1eed\u1eef\u1ef1y\u00fd\u1ef3\u1ef7\u1ef9\u1ef5";
    private static ArrayList alFirstConsonants;
    private static ArrayList alLastConsonants;
    private static ArrayList alMainVowels;
    private static ArrayList alSecondaryVowels;
    private String strSyllable;
    private String strMainVowel;
    private String strSecondaryVowel;
    private String strFirstConsonant;
    private String strLastConsonant;
    private TONE tone = TONE.NO_TONE;
    private int iCurPos;
    private boolean validViSyll;

    public VnSyllParser(String syll) {
        VnSyllParser.init();
        this.parseVnSyllable(syll);
    }

    public VnSyllParser() {
        VnSyllParser.init();
    }

    public void parseVnSyllable(String syll) {
        this.strSyllable = syll;
        this.strMainVowel = ZERO;
        this.strSecondaryVowel = ZERO;
        this.strFirstConsonant = ZERO;
        this.strLastConsonant = ZERO;
        this.iCurPos = 0;
        this.validViSyll = true;
        this.parseFirstConsonant();
        this.parseSecondaryVowel();
        this.parseMainVowel();
        this.parseLastConsonant();
    }

    public String getFirstConsonant() {
        return this.strFirstConsonant;
    }

    public String getSecondVowel() {
        return this.strSecondaryVowel;
    }

    public String getMainVowel() {
        return this.strMainVowel;
    }

    public String getLastConsonant() {
        return this.strLastConsonant;
    }

    public TONE getTone() {
        return this.tone;
    }

    public String getRhyme() {
        return this.strSecondaryVowel + this.strMainVowel + this.strLastConsonant;
    }

    public String getNonToneSyll() {
        return this.strFirstConsonant + this.strSecondaryVowel + this.strMainVowel + this.strLastConsonant;
    }

    public boolean isValidVnSyllable() {
        return this.validViSyll;
    }

    private void parseFirstConsonant() {
        for (String strFirstCon : alFirstConsonants) {
            if (!this.strSyllable.startsWith(strFirstCon, this.iCurPos)) continue;
            this.strFirstConsonant = strFirstCon;
            this.iCurPos += strFirstCon.length();
            return;
        }
        this.strFirstConsonant = ZERO;
    }

    private void parseSecondaryVowel() {
        if (!this.validViSyll) {
            return;
        }
        if (this.iCurPos > this.strSyllable.length() - 1) {
            this.validViSyll = false;
            return;
        }
        char curChar = this.strSyllable.charAt(this.iCurPos);
        int nextChar = this.iCurPos == this.strSyllable.length() - 1 ? 36 : (int)this.strSyllable.charAt(this.iCurPos + 1);
        TONE tone = TONE.NO_TONE;
        int idx1 = vnVowels.indexOf(curChar);
        int idx2 = vnVowels.indexOf(nextChar);
        if (idx1 == -1) {
            return;
        }
        tone = TONE.getTone(idx1 % 6);
        curChar = vnVowels.charAt(idx1 / 6 * 6);
        if (idx2 == -1) {
            this.strSecondaryVowel = ZERO;
            return;
        }
        nextChar = vnVowels.charAt(idx2 / 6 * 6);
        if (tone.getValue() == TONE.NO_TONE.getValue()) {
            tone = TONE.getTone(idx2 % 6);
        }
        if (curChar == 'o') {
            if (nextChar == 97 || nextChar == 101) {
                this.strSecondaryVowel = this.strSecondaryVowel + curChar;
                ++this.iCurPos;
            } else {
                this.strSecondaryVowel = ZERO;
            }
            return;
        }
        if (curChar == 'u') {
            if (nextChar != 105 && nextChar != 36) {
                this.strSecondaryVowel = this.strSecondaryVowel + curChar;
                ++this.iCurPos;
            } else {
                this.strSecondaryVowel = ZERO;
            }
            return;
        }
    }

    private void parseMainVowel() {
        int idx;
        if (!this.validViSyll) {
            return;
        }
        if (this.iCurPos > this.strSyllable.length() - 1) {
            this.validViSyll = false;
            return;
        }
        String strVowel = ZERO;
        for (int i = this.iCurPos; i < this.strSyllable.length() && (idx = vnVowels.indexOf(this.strSyllable.charAt(i))) != -1; ++i) {
            strVowel = strVowel + vnVowels.charAt(idx / 6 * 6);
            if (this.tone.getValue() != TONE.NO_TONE.getValue()) continue;
            this.tone = TONE.getTone(idx % 6);
        }
        for (String tempVowel : alMainVowels) {
            if (!strVowel.startsWith(tempVowel)) continue;
            this.strMainVowel = tempVowel;
            this.iCurPos += tempVowel.length();
            return;
        }
        this.validViSyll = false;
    }

    private void parseLastConsonant() {
        String strCon;
        if (!this.validViSyll) {
            return;
        }
        if (this.iCurPos > this.strSyllable.length()) {
            this.strLastConsonant = ZERO;
        }
        if ((strCon = this.strSyllable.substring(this.iCurPos, this.strSyllable.length())).length() > 3) {
            this.validViSyll = false;
            return;
        }
        for (String tempLastCon : alLastConsonants) {
            if (!strCon.equals(tempLastCon)) continue;
            this.strLastConsonant = tempLastCon;
            this.iCurPos += this.strLastConsonant.length();
            return;
        }
        this.strLastConsonant = ZERO;
        this.validViSyll = this.iCurPos >= this.strSyllable.length();
    }

    private static void init() {
        if (alFirstConsonants == null) {
            alFirstConsonants = new ArrayList();
            alLastConsonants = new ArrayList();
            alMainVowels = new ArrayList();
            alSecondaryVowels = new ArrayList();
            VnSyllParser.initArrayList(alFirstConsonants, vnFirstConsonants);
            VnSyllParser.initArrayList(alLastConsonants, vnLastConsonants);
            VnSyllParser.initArrayList(alMainVowels, vnMainVowels);
            VnSyllParser.initArrayList(alSecondaryVowels, vnSecondaryVowels);
        }
    }

    private static void initArrayList(ArrayList al, String str) {
        StringTokenizer strTknr = new StringTokenizer(str, "|");
        while (strTknr.hasMoreTokens()) {
            al.add(strTknr.nextToken());
        }
    }
}

