/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Vector;
import jvntextpro.JVnTextPro;
import jvntextpro.service.TaggingService;

public class Session
extends Thread {
    JVnTextPro textpro;
    private Socket incoming;

    public Session(JVnTextPro textpro) {
        this.textpro = textpro;
    }

    public synchronized void setSocket(Socket s) {
        this.incoming = s;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (true) {
            Vector<Session> pool;
            try {
                int ch;
                if (this.incoming == null) {
                    this.wait();
                }
                System.out.println("Socket opening ...");
                BufferedReader in = new BufferedReader(new InputStreamReader(this.incoming.getInputStream(), "UTF-8"));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.incoming.getOutputStream(), "UTF-8"));
                String content = "";
                while ((ch = in.read()) != 0) {
                    content = content + (char)ch;
                }
                String tagged = this.textpro.process(content);
                out.write(tagged.trim());
                out.write(0);
                out.flush();
            }
            catch (InterruptedIOException e) {
                System.out.println("The conection is interrupted");
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            this.setSocket(null);
            Vector<Session> vector = pool = TaggingService.pool;
            synchronized (vector) {
                if (pool.size() >= 5) {
                    return;
                }
                pool.addElement(this);
            }
        }
    }
}

