/*
 * Decompiled with CFR 0.152.
 */
package jvntextpro;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import jvntextpro.JVnTextPro;
import jvntextpro.JVnTextProTestOption;
import jvntextpro.conversion.CompositeUnicode2Unicode;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class JVnTextProTest {
    public static void main(String[] args) {
        JVnTextProTestOption option = new JVnTextProTestOption();
        CmdLineParser parser = new CmdLineParser((Object)option);
        if (args.length == 0) {
            System.out.println("JVnTextProTest [options...] [arguments..]");
            parser.printUsage((OutputStream)System.out);
            return;
        }
        JVnTextPro vnTextPro = new JVnTextPro();
        CompositeUnicode2Unicode conversion = new CompositeUnicode2Unicode();
        try {
            parser.parseArgument(args);
            vnTextPro.initSenTokenization();
            if (option.doSenSeg) {
                vnTextPro.initSenSegmenter(option.modelDir.getPath() + File.separator + "jvnsensegmenter");
            }
            if (option.doSenToken) {
                vnTextPro.initSenTokenization();
            }
            if (option.doWordSeg) {
                vnTextPro.initSegmenter(option.modelDir.getPath() + File.separator + "jvnsegmenter");
            }
            if (option.doPosTagging) {
                vnTextPro.initPosTagger(option.modelDir.getPath() + File.separator + "jvnpostag" + File.separator + "maxent");
            }
            if (option.inFile.isFile()) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(option.inFile), "UTF-8"));
                String ret = "";
                while ((line = reader.readLine()) != null) {
                    line = conversion.convert(line);
                    ret = ret + vnTextPro.process(line).trim() + "\n";
                }
                reader.close();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(option.inFile.getPath() + ".pro"), "UTF-8"));
                writer.write(ret);
                writer.close();
            } else if (option.inFile.isDirectory()) {
                File[] childs;
                for (File child : childs = option.inFile.listFiles()) {
                    String line;
                    if (!child.getName().endsWith(option.fileType)) continue;
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(child), "UTF-8"));
                    String ret = "";
                    while ((line = reader.readLine()) != null) {
                        line = conversion.convert(line);
                        ret = ret + vnTextPro.process(line).trim() + "\n";
                    }
                    reader.close();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(child.getPath() + ".pro"), "UTF-8"));
                    writer.write(ret);
                    writer.close();
                }
            }
        }
        catch (CmdLineException cle) {
            System.out.println("JVnTextProTest [options...] [arguments..]");
            parser.printUsage((OutputStream)System.out);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

