/*
 * Decompiled with CFR 0.152.
 */
package jvnsegmenter;

import java.io.File;
import java.util.Vector;
import jvnsegmenter.BasicContextGenerator;
import jvnsegmenter.ConjunctionContextGenerator;
import jvnsegmenter.IOB2DataReader;
import jvnsegmenter.LexiconContextGenerator;
import jvnsegmenter.RegexContextGenerator;
import jvnsegmenter.SyllableContextGenerator;
import jvnsegmenter.VietnameseContextGenerator;
import jvntextpro.data.TaggingData;
import jvntextpro.data.TrainDataGenerating;
import org.w3c.dom.Element;

public class WordTrainGenerating
extends TrainDataGenerating {
    String modelDir;

    public WordTrainGenerating(String modelDir) {
        this.modelDir = modelDir;
        this.init();
    }

    @Override
    public void init() {
        this.reader = new IOB2DataReader();
        this.tagger = new TaggingData();
        String templateFile = this.modelDir + File.separator + "featuretemplate.xml";
        Vector<Element> nodes = BasicContextGenerator.readFeatureNodes(templateFile);
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = nodes.get(i);
            String cpType = node.getAttribute("value");
            BasicContextGenerator contextGen = null;
            if (cpType.equals("Conjunction")) {
                contextGen = new ConjunctionContextGenerator(node);
            } else if (cpType.equals("Lexicon")) {
                contextGen = new LexiconContextGenerator(node);
                LexiconContextGenerator.loadVietnameseDict(this.modelDir + File.separator + "VNDic_UTF-8.txt");
                LexiconContextGenerator.loadViLocationList(this.modelDir + File.separator + "vnlocations.txt");
                LexiconContextGenerator.loadViPersonalNames(this.modelDir + File.separator + "vnpernames.txt");
            } else if (cpType.equals("Regex")) {
                contextGen = new RegexContextGenerator(node);
            } else if (cpType.equals("SyllableFeature")) {
                contextGen = new SyllableContextGenerator(node);
            } else if (cpType.equals("ViSyllableFeature")) {
                contextGen = new VietnameseContextGenerator(node);
            }
            if (contextGen == null) continue;
            this.tagger.addContextGenerator(contextGen);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("WordTrainGenerating [Model Dir] [File/Folder]");
            System.out.println("Generating training data for word segmentation with FlexCRFs++ or jvnmaxent (in JVnTextPro)");
            System.out.println("Model Dir: directory containing featuretemple file");
            System.out.println("Input File/Folder: file/folder name containing data manually tagged for training");
            return;
        }
        WordTrainGenerating trainGen = new WordTrainGenerating(args[0]);
        trainGen.generateTrainData(args[1], args[1]);
    }
}

