/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.PrintWriter;
import java.util.List;
import jmaxent.Data;
import jmaxent.Dictionary;
import jmaxent.Evaluation;
import jmaxent.Feature;
import jmaxent.FeatureGen;
import jmaxent.Inference;
import jmaxent.Option;
import jmaxent.Train;

public class Model {
    public Option option = null;
    public Data data = null;
    public Dictionary dict = null;
    public FeatureGen feaGen = null;
    public Train train = null;
    public Inference inference = null;
    public Evaluation evaluation = null;
    double[] lambda = null;

    public Model() {
    }

    public Model(Option option, Data data, Dictionary dict, FeatureGen feaGen, Train train, Inference inference, Evaluation evaluation) {
        this.option = option;
        this.data = data;
        this.dict = dict;
        this.feaGen = feaGen;
        this.evaluation = evaluation;
        if (train != null) {
            this.train = train;
            this.train.model = this;
            this.train.init();
        }
        if (inference != null) {
            this.inference = inference;
            this.inference.model = this;
            this.inference.init();
        }
        if (evaluation != null) {
            this.evaluation = evaluation;
            this.evaluation.model = this;
            this.evaluation.init();
        }
    }

    public void doTrain(PrintWriter fout) {
        if (this.lambda == null) {
            this.lambda = new double[this.feaGen.numFeatures()];
        }
        this.train.doTrain(fout);
        this.updateFeatures();
    }

    public void updateFeatures() {
        for (int i = 0; i < this.feaGen.features.size(); ++i) {
            Feature f = (Feature)this.feaGen.features.get(i);
            f.wgt = this.lambda[f.idx];
        }
    }

    public void initInference() {
        if (this.lambda == null) {
            System.out.println("numFetures: " + this.feaGen.numFeatures());
            this.lambda = new double[this.feaGen.numFeatures() + 1];
            for (int i = 0; i < this.feaGen.features.size(); ++i) {
                Feature f = (Feature)this.feaGen.features.get(i);
                this.lambda[f.idx] = f.wgt;
            }
        }
    }

    public void doInference(List data) {
        if (this.lambda == null) {
            this.lambda = new double[this.feaGen.numFeatures()];
            for (int i = 0; i < this.feaGen.features.size(); ++i) {
                Feature f = (Feature)this.feaGen.features.get(i);
                this.lambda[f.idx] = f.wgt;
            }
        }
        this.inference.doInference(data);
    }
}

