/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.util.List;
import jmaxent.Feature;
import jmaxent.Model;
import jmaxent.Observation;

public class Inference {
    public Model model = null;
    public int numLabels = 0;
    double[] temp = null;

    public void init() {
        this.numLabels = this.model.data.numLabels();
        this.temp = new double[this.numLabels];
    }

    public void classify(Observation obsr) {
        int i;
        for (i = 0; i < this.numLabels; ++i) {
            this.temp[i] = 0.0;
        }
        this.model.feaGen.startScanFeatures(obsr);
        while (this.model.feaGen.hasNextFeature()) {
            Feature f = this.model.feaGen.nextFeature();
            int n = f.label;
            this.temp[n] = this.temp[n] + this.model.lambda[f.idx] * (double)f.val;
        }
        double max = this.temp[0];
        int maxLabel = 0;
        for (i = 1; i < this.numLabels; ++i) {
            if (!(max < this.temp[i])) continue;
            max = this.temp[i];
            maxLabel = i;
        }
        obsr.modelLabel = maxLabel;
    }

    public void doInference(List data) {
        for (int i = 0; i < data.size(); ++i) {
            Observation obsr = (Observation)data.get(i);
            this.classify(obsr);
        }
    }
}

