/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.util.Map;
import java.util.StringTokenizer;

public class Feature {
    public int idx = -1;
    public String strId = "";
    public int label = -1;
    public int cp = -1;
    public float val = 1.0f;
    public double wgt = 0.0;

    public Feature() {
    }

    public Feature(int label, int cp) {
        this.FeatureInit(label, cp);
    }

    public Feature(int label, int cp, Map fmap) {
        this.FeatureInit(label, cp);
        this.strId2IdxAdd(fmap);
    }

    public Feature(String str, Map cpStr2Int, Map lbStr2Int) {
        this.FeatureInit(str, cpStr2Int, lbStr2Int);
    }

    public Feature(String str, Map cpStr2Int, Map lbStr2Int, Map fmap) {
        this.FeatureInit(str, cpStr2Int, lbStr2Int);
        this.strId2IdxAdd(fmap);
    }

    public void FeatureInit(int label, int cp) {
        this.label = label;
        this.cp = cp;
        this.strId = Integer.toString(label) + " " + Integer.toString(cp);
    }

    public void FeatureInit(String str, Map cpStr2Int, Map lbStr2Int) {
        StringTokenizer strTok = new StringTokenizer(str, " \t\r\n");
        int len = strTok.countTokens();
        if (len != 4) {
            return;
        }
        String labelStr = strTok.nextToken();
        String cpStr = strTok.nextToken();
        int idx = Integer.parseInt(strTok.nextToken());
        float val = 1.0f;
        double wgt = Double.parseDouble(strTok.nextToken());
        Integer labelInt = (Integer)lbStr2Int.get(labelStr);
        Integer cpInt = (Integer)cpStr2Int.get(cpStr);
        this.FeatureInit(labelInt, cpInt);
        this.idx = idx;
        this.val = val;
        this.wgt = wgt;
    }

    public int strId2Idx(Map fmap) {
        Integer idxInt = (Integer)fmap.get(this.strId);
        if (idxInt != null) {
            this.idx = idxInt;
        }
        return this.idx;
    }

    public int strId2IdxAdd(Map fmap) {
        this.strId2Idx(fmap);
        if (this.idx < 0) {
            this.idx = fmap.size();
            fmap.put(this.strId, new Integer(this.idx));
        }
        return this.idx;
    }

    public int index(Map fmap) {
        return this.strId2Idx(fmap);
    }

    public String toString(Map cpInt2Str, Map lbInt2Str) {
        String cpStr;
        String str = "";
        String labelStr = (String)lbInt2Str.get(new Integer(this.label));
        if (labelStr != null) {
            str = str + labelStr + " ";
        }
        if ((cpStr = (String)cpInt2Str.get(new Integer(this.cp))) != null) {
            str = str + cpStr + " ";
        }
        str = str + Integer.toString(this.idx) + " " + Double.toString(this.wgt);
        return str;
    }
}

