/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import jmaxent.Model;
import jmaxent.Observation;

public class Evaluation {
    public Model model = null;
    public int numLabels = 0;
    int[] humanLabelCounts = null;
    int[] modelLabelCounts = null;
    int[] humanModelCounts = null;

    public void init() {
        this.numLabels = this.model.data.numLabels();
        this.humanLabelCounts = new int[this.numLabels];
        this.modelLabelCounts = new int[this.numLabels];
        this.humanModelCounts = new int[this.numLabels];
    }

    public double evaluate() {
        if (this.model.data.tstData.size() <= 0) {
            return 0.0;
        }
        for (int i = 0; i < this.humanLabelCounts.length; ++i) {
            this.humanLabelCounts[i] = 0;
            this.modelLabelCounts[i] = 0;
            this.humanModelCounts[i] = 0;
        }
        int matchingCount = 0;
        for (int i = 0; i < this.model.data.tstData.size(); ++i) {
            Observation obsr = (Observation)this.model.data.tstData.get(i);
            if (obsr.humanLabel != obsr.modelLabel) continue;
            ++matchingCount;
        }
        return (double)(matchingCount * 100) / (double)this.model.data.tstData.size();
    }

    public double evaluate(PrintWriter fout) {
        int i;
        if (this.model.data.tstData.size() <= 0) {
            return 0.0;
        }
        for (i = 0; i < this.humanLabelCounts.length; ++i) {
            this.humanLabelCounts[i] = 0;
            this.modelLabelCounts[i] = 0;
            this.humanModelCounts[i] = 0;
        }
        for (i = 0; i < this.model.data.tstData.size(); ++i) {
            Observation obsr = (Observation)this.model.data.tstData.get(i);
            int n = obsr.humanLabel;
            this.humanLabelCounts[n] = this.humanLabelCounts[n] + 1;
            int n2 = obsr.modelLabel;
            this.modelLabelCounts[n2] = this.modelLabelCounts[n2] + 1;
            if (obsr.humanLabel != obsr.modelLabel) continue;
            int n3 = obsr.humanLabel;
            this.humanModelCounts[n3] = this.humanModelCounts[n3] + 1;
        }
        DecimalFormat fm = new DecimalFormat("#.00");
        System.out.println();
        System.out.println("\tPer-class performance evaluation:");
        System.out.println();
        System.out.println("\t\tClass\tHuman\tModel\tMatch\tPre.(%)\tRec.(%)\tF1-score");
        System.out.println("\t\t-----\t-----\t-----\t-----\t-------\t-------\t--------");
        if (fout != null && this.model.option.isLogging) {
            fout.println();
            fout.println("\tPer-class performance evaluation:");
            fout.println();
            fout.println("\t\tClass\tHuman\tModel\tMatch\tPre.(%)\tRec.(%)\tF1-score");
            fout.println("\t\t-----\t-----\t-----\t-----\t-------\t-------\t--------");
        }
        int count = 0;
        double precision = 0.0;
        double recall = 0.0;
        double total1Pre = 0.0;
        double total1Rec = 0.0;
        double total1F1 = 0.0;
        double total2Pre = 0.0;
        double total2Rec = 0.0;
        double total2F1 = 0.0;
        int totalHuman = 0;
        int totalModel = 0;
        int totalMatch = 0;
        for (i = 0; i < this.numLabels; ++i) {
            if (this.modelLabelCounts[i] > 0) {
                precision = (double)this.humanModelCounts[i] / (double)this.modelLabelCounts[i];
                totalModel += this.modelLabelCounts[i];
                total1Pre += precision;
            } else {
                precision = 0.0;
            }
            if (this.humanLabelCounts[i] > 0) {
                recall = (double)this.humanModelCounts[i] / (double)this.humanLabelCounts[i];
                totalHuman += this.humanLabelCounts[i];
                total1Rec += recall;
                ++count;
            } else {
                recall = 0.0;
            }
            totalMatch += this.humanModelCounts[i];
            double f1 = recall + precision > 0.0 ? 2.0 * precision * recall / (precision + recall) : 0.0;
            String classStr = Integer.toString(i);
            String labelStr = (String)this.model.data.lbInt2Str.get(new Integer(i));
            if (labelStr != null) {
                classStr = labelStr;
            }
            System.out.println("\t\t" + classStr + "\t" + Integer.toString(this.humanLabelCounts[i]) + "\t" + Integer.toString(this.modelLabelCounts[i]) + "\t" + Integer.toString(this.humanModelCounts[i]) + "\t" + fm.format(precision * 100.0) + "\t" + fm.format(recall * 100.0) + "\t" + fm.format(f1 * 100.0));
            if (fout == null || !this.model.option.isLogging) continue;
            fout.println("\t\t" + classStr + "\t" + Integer.toString(this.humanLabelCounts[i]) + "\t" + Integer.toString(this.modelLabelCounts[i]) + "\t" + Integer.toString(this.humanModelCounts[i]) + "\t" + fm.format(precision * 100.0) + "\t" + fm.format(recall * 100.0) + "\t" + fm.format(f1 * 100.0));
        }
        total1F1 = 2.0 * (total1Pre /= (double)count) * (total1Rec /= (double)count) / (total1Pre + total1Rec);
        total2Pre = (double)totalMatch / (double)totalModel;
        total2Rec = (double)totalMatch / (double)totalHuman;
        total2F1 = 2.0 * total2Pre * total2Rec / (total2Pre + total2Rec);
        System.out.println("\t\t-----\t-----\t-----\t-----\t-------\t-------\t--------");
        System.out.println("\t\tAvg.1\t\t\t\t" + fm.format(total1Pre * 100.0) + "\t" + fm.format(total1Rec * 100.0) + "\t" + fm.format(total1F1 * 100.0));
        System.out.println("\t\tAvg.2\t" + Integer.toString(totalHuman) + "\t" + Integer.toString(totalModel) + "\t" + Integer.toString(totalMatch) + "\t" + fm.format(total2Pre * 100.0) + "\t" + fm.format(total2Rec * 100.0) + "\t" + fm.format(total2F1 * 100.0));
        System.out.println();
        if (fout != null && this.model.option.isLogging) {
            fout.println();
            fout.println("\t\t-----\t-----\t-----\t-----\t-------\t-------\t--------");
            fout.println("\t\tAvg.1\t\t\t\t" + fm.format(total1Pre * 100.0) + "\t" + fm.format(total1Rec * 100.0) + "\t" + fm.format(total1F1 * 100.0));
            fout.println("\t\tAvg.2\t" + Integer.toString(totalHuman) + "\t" + Integer.toString(totalModel) + "\t" + Integer.toString(totalMatch) + "\t" + fm.format(total2Pre * 100.0) + "\t" + fm.format(total2Rec * 100.0) + "\t" + fm.format(total2F1 * 100.0));
        }
        return total2F1 * 100.0;
    }
}

