/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jmaxent.Dictionary;
import jmaxent.Element;
import jmaxent.Observation;
import jmaxent.Option;

public class Data {
    Option option = null;
    public Map lbStr2Int = null;
    public Map lbInt2Str = null;
    public Map cpStr2Int = null;
    public Map cpInt2Str = null;
    public List trnData = null;
    public List tstData = null;
    public List ulbData = null;

    public Data(Option option) {
        this.option = option;
    }

    public void readCpMaps(BufferedReader fin) throws IOException {
        if (this.cpStr2Int != null) {
            this.cpStr2Int.clear();
        } else {
            this.cpStr2Int = new HashMap();
        }
        if (this.cpInt2Str != null) {
            this.cpInt2Str.clear();
        } else {
            this.cpInt2Str = new HashMap();
        }
        String line = fin.readLine();
        if (line == null) {
            System.out.println("No context predicate map size information");
            return;
        }
        int numCps = Integer.parseInt(line);
        if (numCps <= 0) {
            System.out.println("Invalid context predicate mapping size");
            return;
        }
        System.out.println("Reading the context predicate maps ...");
        for (int i = 0; i < numCps; ++i) {
            line = fin.readLine();
            if (line == null) {
                System.out.println("Invalid context predicate mapping line");
                return;
            }
            StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
            if (strTok.countTokens() != 2) continue;
            String cpStr = strTok.nextToken();
            String cpInt = strTok.nextToken();
            this.cpStr2Int.put(cpStr, new Integer(cpInt));
            this.cpInt2Str.put(new Integer(cpInt), cpStr);
        }
        System.out.println("Reading context predicate maps (" + Integer.toString(this.cpStr2Int.size()) + " entries) completed!");
        line = fin.readLine();
        this.option.numCps = this.cpStr2Int.size();
    }

    public int numCps() {
        if (this.cpStr2Int == null) {
            return 0;
        }
        return this.cpStr2Int.size();
    }

    public void writeCpMaps(Dictionary dict, PrintWriter fout) throws IOException {
        Element elem;
        Integer cpInt;
        Iterator it = null;
        if (this.cpStr2Int == null) {
            return;
        }
        int count = 0;
        for (String cpStr : this.cpStr2Int.keySet()) {
            cpInt = (Integer)this.cpStr2Int.get(cpStr);
            elem = (Element)dict.dict.get(cpInt);
            if (elem == null || elem.chosen != 1) continue;
            ++count;
        }
        fout.println(Integer.toString(count));
        for (String cpStr : this.cpStr2Int.keySet()) {
            cpInt = (Integer)this.cpStr2Int.get(cpStr);
            elem = (Element)dict.dict.get(cpInt);
            if (elem == null || elem.chosen != 1) continue;
            fout.println(cpStr + " " + cpInt.toString());
        }
        fout.println(Option.modelSeparator);
    }

    public void readLbMaps(BufferedReader fin) throws IOException {
        if (this.lbStr2Int != null) {
            this.lbStr2Int.clear();
        } else {
            this.lbStr2Int = new HashMap();
        }
        if (this.lbInt2Str != null) {
            this.lbInt2Str.clear();
        } else {
            this.lbInt2Str = new HashMap();
        }
        String line = fin.readLine();
        if (line == null) {
            System.out.println("No label map size information");
            return;
        }
        int numLabels = Integer.parseInt(line);
        if (numLabels <= 0) {
            System.out.println("Invalid label mapping size");
            return;
        }
        System.out.println("Reading the context predicate maps ...");
        for (int i = 0; i < numLabels; ++i) {
            line = fin.readLine();
            if (line == null) {
                System.out.println("Invalid context predicate mapping line");
                return;
            }
            StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
            if (strTok.countTokens() != 2) continue;
            String lbStr = strTok.nextToken();
            String lbInt = strTok.nextToken();
            this.lbStr2Int.put(lbStr, new Integer(lbInt));
            this.lbInt2Str.put(new Integer(lbInt), lbStr);
        }
        System.out.println("Reading label maps (" + Integer.toString(this.lbStr2Int.size()) + " entries) completed!");
        line = fin.readLine();
        this.option.numLabels = this.lbStr2Int.size();
    }

    public int numLabels() {
        if (this.lbStr2Int == null) {
            return 0;
        }
        return this.lbStr2Int.size();
    }

    public void writeLbMaps(PrintWriter fout) throws IOException {
        if (this.lbStr2Int == null) {
            return;
        }
        fout.println(Integer.toString(this.lbStr2Int.size()));
        for (String lbStr : this.lbStr2Int.keySet()) {
            Integer lbInt = (Integer)this.lbStr2Int.get(lbStr);
            fout.println(lbStr + " " + lbInt.toString());
        }
        fout.println(Option.modelSeparator);
    }

    public void readTrnData(String dataFile) {
        if (this.cpStr2Int != null) {
            this.cpStr2Int.clear();
        } else {
            this.cpStr2Int = new HashMap();
        }
        if (this.cpInt2Str != null) {
            this.cpInt2Str.clear();
        } else {
            this.cpInt2Str = new HashMap();
        }
        if (this.lbStr2Int != null) {
            this.lbStr2Int.clear();
        } else {
            this.lbStr2Int = new HashMap();
        }
        if (this.lbInt2Str != null) {
            this.lbInt2Str.clear();
        } else {
            this.lbInt2Str = new HashMap();
        }
        if (this.trnData != null) {
            this.trnData.clear();
        } else {
            this.trnData = new ArrayList();
        }
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFile), "UTF-8"));
            System.out.println("Reading training data ...");
            while ((line = fin.readLine()) != null) {
                StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
                int len = strTok.countTokens();
                if (len <= 1) continue;
                ArrayList<String> strCps = new ArrayList<String>();
                for (int i = 0; i < len - 1; ++i) {
                    strCps.add(strTok.nextToken());
                }
                String labelStr = strTok.nextToken();
                ArrayList<Integer> intCps = new ArrayList<Integer>();
                for (int i = 0; i < strCps.size(); ++i) {
                    String cpStr = (String)strCps.get(i);
                    Integer cpInt = (Integer)this.cpStr2Int.get(cpStr);
                    if (cpInt != null) {
                        intCps.add(cpInt);
                        continue;
                    }
                    intCps.add(new Integer(this.cpStr2Int.size()));
                    this.cpStr2Int.put(cpStr, new Integer(this.cpStr2Int.size()));
                    this.cpInt2Str.put(new Integer(this.cpInt2Str.size()), cpStr);
                }
                Integer labelInt = (Integer)this.lbStr2Int.get(labelStr);
                if (labelInt == null) {
                    labelInt = new Integer(this.lbStr2Int.size());
                    this.lbStr2Int.put(labelStr, labelInt);
                    this.lbInt2Str.put(labelInt, labelStr);
                }
                int[] cps = new int[intCps.size()];
                for (int i = 0; i < cps.length; ++i) {
                    cps[i] = (Integer)intCps.get(i);
                }
                Observation obsr = new Observation(labelInt, cps);
                this.trnData.add(obsr);
            }
            System.out.println("Reading " + Integer.toString(this.trnData.size()) + " training data examples completed!");
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return;
        }
        this.option.numCps = this.cpStr2Int.size();
        this.option.numLabels = this.lbStr2Int.size();
        this.option.numTrainExps = this.trnData.size();
    }

    public void readTstData(String dataFile) {
        if (this.tstData != null) {
            this.tstData.clear();
        } else {
            this.tstData = new ArrayList();
        }
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFile), "UTF-8"));
            System.out.println("Reading testing data ...");
            while ((line = fin.readLine()) != null) {
                StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
                int len = strTok.countTokens();
                if (len <= 1) continue;
                ArrayList<String> strCps = new ArrayList<String>();
                for (int i = 0; i < len - 1; ++i) {
                    strCps.add(strTok.nextToken());
                }
                String labelStr = strTok.nextToken();
                ArrayList<Integer> intCps = new ArrayList<Integer>();
                for (int i = 0; i < strCps.size(); ++i) {
                    String cpStr = (String)strCps.get(i);
                    Integer cpInt = (Integer)this.cpStr2Int.get(cpStr);
                    if (cpInt == null) continue;
                    intCps.add(cpInt);
                }
                Integer labelInt = (Integer)this.lbStr2Int.get(labelStr);
                if (labelInt == null) {
                    System.out.println("Reading testing observation, label not found or invalid");
                    return;
                }
                int[] cps = new int[intCps.size()];
                for (int i = 0; i < cps.length; ++i) {
                    cps[i] = (Integer)intCps.get(i);
                }
                Observation obsr = new Observation(labelInt, cps);
                this.tstData.add(obsr);
            }
            System.out.println("Reading " + Integer.toString(this.tstData.size()) + " testing data examples completed!");
        }
        catch (IOException e) {
            System.out.println(e.toString());
            return;
        }
        this.option.numTestExps = this.tstData.size();
    }
}

