/*
 * Decompiled with CFR 0.152.
 */
package jmaxent;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jmaxent.Data;
import jmaxent.Dictionary;
import jmaxent.FeatureGen;
import jmaxent.Inference;
import jmaxent.Model;
import jmaxent.Observation;
import jmaxent.Option;

public class Classification {
    public Option option = null;
    public Data data = null;
    public Dictionary dict = null;
    public FeatureGen feagen = null;
    public Inference inference = null;
    public Model model = null;
    public boolean initialized = false;
    private BufferedReader finModel = null;
    List intCps = null;

    public Classification(String modelDir) {
        this.option = new Option(modelDir);
        this.option.readOptions();
        this.init();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void init() {
        try {
            this.finModel = this.option.openModelFile();
            if (this.finModel == null) {
                System.out.println("Couldn't open model file");
                return;
            }
            this.data = new Data(this.option);
            this.data.readCpMaps(this.finModel);
            this.data.readLbMaps(this.finModel);
            this.dict = new Dictionary(this.option, this.data);
            this.dict.readDict(this.finModel);
            this.feagen = new FeatureGen(this.option, this.data, this.dict);
            this.feagen.readFeatures(this.finModel);
            this.inference = new Inference();
            this.model = new Model(this.option, this.data, this.dict, this.feagen, null, this.inference, null);
            this.model.initInference();
            this.finModel.close();
        }
        catch (IOException e) {
            System.out.println("Couldn't load the model, check the model file again");
            System.out.println(e.toString());
        }
        this.intCps = new ArrayList();
        this.initialized = true;
    }

    public String classify(String cps) {
        String modelLabel = "";
        this.intCps.clear();
        StringTokenizer strTok = new StringTokenizer(cps, " \t\r\n");
        int count = strTok.countTokens();
        for (int i = 0; i < count; ++i) {
            String cpStr = strTok.nextToken();
            Integer cpInt = (Integer)this.data.cpStr2Int.get(cpStr);
            if (cpInt == null) continue;
            this.intCps.add(cpInt);
        }
        Observation obsr = new Observation(this.intCps);
        this.inference.classify(obsr);
        String lbStr = (String)this.data.lbInt2Str.get(new Integer(obsr.modelLabel));
        if (lbStr != null) {
            modelLabel = lbStr;
        }
        return modelLabel;
    }

    public String classify(String[] cpArr) {
        int i;
        String modelLabel = "";
        this.intCps.clear();
        int curWordCp = -1;
        int dictLabel = -2;
        int dictCp = -1;
        Vector<Integer> dictCps = new Vector<Integer>();
        for (String cpStr : cpArr) {
            Integer cpInt = (Integer)this.data.cpStr2Int.get(cpStr);
            if (cpInt == null) continue;
            this.intCps.add(cpInt);
            if (cpStr.startsWith("w:0")) {
                curWordCp = cpInt;
                continue;
            }
            if (!cpStr.startsWith("dict:0")) continue;
            dictCp = cpInt;
            dictCps.add(dictCp);
            if (dictLabel == -1) continue;
            if (dictLabel == -2) {
                String label = cpStr.substring("dict:0:".length());
                if (this.data.lbStr2Int.containsKey(label)) {
                    dictLabel = (Integer)this.data.lbStr2Int.get(label);
                    continue;
                }
                dictLabel = -1;
                continue;
            }
            dictLabel = -1;
        }
        if (curWordCp != -1 && dictLabel >= 0) {
            for (i = 0; i < 3; ++i) {
                this.intCps.add(dictCp);
            }
        } else {
            for (i = 0; i < dictCps.size(); ++i) {
                this.intCps.add(dictCps.get(i));
                this.intCps.add(dictCps.get(i));
            }
        }
        Observation obsr = new Observation(this.intCps);
        obsr.curWordCp = curWordCp;
        obsr.dictLabel = dictLabel;
        if (obsr.curWordCp == -1 && obsr.dictLabel >= 0) {
            obsr.modelLabel = obsr.dictLabel;
        } else {
            this.inference.classify(obsr);
        }
        String lbStr = (String)this.data.lbInt2Str.get(new Integer(obsr.modelLabel));
        if (lbStr != null) {
            modelLabel = lbStr;
        }
        return modelLabel;
    }

    public List classify(List data) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            list.add(this.classify((String)data.get(i)));
        }
        return list;
    }
}

