/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class Option {
    public static final int FIRST_ORDER = 1;
    public static final int SECOND_ORDER = 2;
    public static final String inputSeparator = "|";
    public static final String outputSeparator = "|";
    public String modelDir = ".";
    public final String modelFile = "model.txt";
    public final String optionFile = "option.txt";
    public int order = 1;

    public Option() {
    }

    public Option(String modelDir) {
        this.modelDir = modelDir.endsWith(File.separator) ? modelDir.substring(0, modelDir.length() - 1) : modelDir;
    }

    public boolean readOptions() {
        String filename = this.modelDir + File.separator + "option.txt";
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(filename));
            System.out.println("Reading options ...");
            while ((line = fin.readLine()) != null) {
                int numTemp;
                StringTokenizer strTok;
                int len;
                String trimLine = line.trim();
                if (trimLine.startsWith("#") || (len = (strTok = new StringTokenizer(line, "= \t\r\n")).countTokens()) != 2) continue;
                String strOpt = strTok.nextToken();
                String strVal = strTok.nextToken();
                if (strOpt.compareToIgnoreCase("order") != 0) continue;
                this.order = numTemp = Integer.parseInt(strVal);
            }
            System.out.println("Reading options completed!");
        }
        catch (IOException e) {
            System.out.println("Couldn't open and read option file: option.txt");
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    public BufferedReader openModelFile() {
        String filename = this.modelDir + File.separator + "model.txt";
        BufferedReader fin = null;
        try {
            fin = new BufferedReader(new FileReader(filename));
        }
        catch (IOException e) {
            System.out.println("Couldn't open model file: " + filename);
            System.out.println(e.toString());
            fin = null;
        }
        return fin;
    }
}

