/*
 * Decompiled with CFR 0.152.
 */
package jflexcrf;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jflexcrf.CountFeatureIdx;
import jflexcrf.Element;

public class Dictionary {
    public Map dict = new HashMap();

    Dictionary() {
    }

    public void readDict(BufferedReader fin) throws IOException {
        this.dict.clear();
        String line = fin.readLine();
        if (line == null) {
            System.out.println("No dictionary size information");
            return;
        }
        int dictSize = Integer.parseInt(line);
        if (dictSize <= 0) {
            System.out.println("Invalid dictionary size");
        }
        System.out.println("Reading dictionary ...");
        for (int i = 0; i < dictSize; ++i) {
            line = fin.readLine();
            if (line == null) {
                System.out.println("Invalid dictionary line");
                return;
            }
            StringTokenizer strTok = new StringTokenizer(line, " \t\r\n");
            int len = strTok.countTokens();
            if (len < 2) continue;
            StringTokenizer cpTok = new StringTokenizer(strTok.nextToken(), ":");
            int cp = Integer.parseInt(cpTok.nextToken());
            int cpCount = Integer.parseInt(cpTok.nextToken());
            Element elem = new Element();
            elem.count = cpCount;
            elem.chosen = 1;
            while (strTok.hasMoreTokens()) {
                StringTokenizer lbTok = new StringTokenizer(strTok.nextToken(), ":");
                int order = Integer.parseInt(lbTok.nextToken());
                int label = Integer.parseInt(lbTok.nextToken());
                int count = Integer.parseInt(lbTok.nextToken());
                int fidx = Integer.parseInt(lbTok.nextToken());
                CountFeatureIdx cntFeaIdx = new CountFeatureIdx(count, fidx);
                if (order == 1) {
                    elem.lbCntFidxes.put(new Integer(label), cntFeaIdx);
                    continue;
                }
                if (order != 2) continue;
            }
            this.dict.put(new Integer(cp), elem);
        }
        System.out.println("Reading dictionary (" + Integer.toString(this.dict.size()) + " entries) completed!");
        line = fin.readLine();
    }

    public int size() {
        if (this.dict == null) {
            return 0;
        }
        return this.dict.size();
    }
}

