/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.zemris.takelab.splitter;

import java.util.ArrayList;
import java.util.List;

public class TokenSplitter {
    private static String spaces = " \t\n\r";
    private static String punctuation = ".,;?!:()";

    public static List<String> getTokens(String sentence) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        for (char c : sentence.toCharArray()) {
            if (buff.length() > 0 && spaces.indexOf(c) != -1) {
                tokens.add(buff.toString());
                buff.setLength(0);
                continue;
            }
            if (punctuation.indexOf(c) != -1) {
                if (buff.length() > 0) {
                    tokens.add(buff.toString());
                    buff.setLength(0);
                }
                tokens.add(String.valueOf(c));
                continue;
            }
            if (spaces.indexOf(c) != -1) continue;
            buff.append(c);
        }
        if (buff.length() > 0) {
            tokens.add(buff.toString());
        }
        return tokens;
    }
}

