/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.reader.tempeval3reader;

import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.types.heideltime.Dct;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Tempeval3Reader
extends CollectionReader_ImplBase {
    private Class<?> component = ((Object)((Object)this)).getClass();
    private String PARAM_INPUTDIR = "InputDirectory";
    private Integer numberOfDocuments = 0;
    private Queue<File> files = new LinkedList<File>();

    public void initialize() throws ResourceInitializationException {
        String dirPath = (String)this.getConfigParameterValue(this.PARAM_INPUTDIR);
        dirPath = dirPath.trim();
        this.populateFileList(dirPath);
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        this.fillJCas(jcas);
        System.err.print(".");
    }

    private void fillJCas(JCas jcas) {
        File f = this.files.poll();
        try {
            Node dctValue;
            NamedNodeMap dctTimexAttr;
            Node dctTimex;
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(f);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("TEXT");
            Node textNode = nList.item(0);
            String text = textNode.getTextContent();
            jcas.setDocumentText(text);
            Boolean gotDCT = false;
            String dctText = null;
            try {
                nList = doc.getDocumentElement().getElementsByTagName("DCT");
                nList = ((Element)nList.item(0)).getElementsByTagName("TIMEX3");
                dctTimex = nList.item(0);
                dctTimexAttr = dctTimex.getAttributes();
                dctValue = dctTimexAttr.getNamedItem("value");
                dctText = dctValue.getTextContent();
                gotDCT = true;
            }
            catch (Exception e) {
                gotDCT = false;
            }
            if (!gotDCT.booleanValue()) {
                try {
                    nList = doc.getDocumentElement().getElementsByTagName("TEXT");
                    nList = ((Element)nList.item(0)).getElementsByTagName("TIMEX3");
                    dctTimex = nList.item(0);
                    dctTimexAttr = dctTimex.getAttributes();
                    if (dctTimexAttr.getNamedItem("functionInDocument") != null && dctTimexAttr.getNamedItem("functionInDocument").getTextContent().equals("CREATION_TIME")) {
                        dctValue = dctTimexAttr.getNamedItem("value");
                        dctText = dctValue.getTextContent();
                    }
                    gotDCT = true;
                }
                catch (Exception e) {
                    gotDCT = false;
                }
            }
            nList = doc.getElementsByTagName("DOCID");
            String filename = null;
            filename = nList != null && nList.getLength() > 0 ? nList.item(0).getTextContent() : f.getName().replaceAll("\\.[^\\.]+$", "");
            Dct dct = new Dct(jcas);
            dct.setBegin(0);
            dct.setEnd(text.length());
            dct.setFilename(filename);
            dct.setValue(dctText);
            dct.setTimexId("t0");
            dct.addToIndexes();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.printError(this.component, "File " + f.getAbsolutePath() + " could not be properly parsed.");
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.files.size() > 0;
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.numberOfDocuments - this.files.size(), this.numberOfDocuments.intValue(), "entities")};
    }

    public void close() throws IOException {
        this.files.clear();
    }

    private void populateFileList(String dirPath) throws ResourceInitializationException {
        ArrayList<File> myFiles = new ArrayList<File>();
        File dir = new File(dirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new ResourceInitializationException();
        }
        myFiles.addAll(Arrays.asList(dir.listFiles()));
        for (File f : myFiles) {
            if (!(f.exists() && f.isFile() && f.canRead())) {
                Logger.printDetail(this.component, "File \"" + f.getAbsolutePath() + "\" was ignored because it either didn't exist, wasn't a file or wasn't readable.");
                continue;
            }
            this.files.add(f);
        }
        this.numberOfDocuments = this.files.size();
    }
}

