/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.utilities;

import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.NormalizationManager;
import de.unihd.dbs.uima.annotator.heideltime.utilities.LocaleException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DateCalculator {
    public static String getXNextYear(String date, Integer x) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        SimpleDateFormat formatterBC = new SimpleDateFormat("GGyyyy");
        String newDate = "";
        Calendar c = Calendar.getInstance();
        try {
            if (date.matches("^\\d.*")) {
                c.setTime(formatter.parse(date));
            } else {
                c.setTime(formatterBC.parse(date));
            }
            c.add(1, x);
            c.getTime();
            int newEra = c.get(0);
            newDate = newEra > 0 ? formatter.format(c.getTime()) : formatterBC.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    public static String getXNextDecade(String date, Integer x) {
        date = date + "0";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        SimpleDateFormat formatterBC = new SimpleDateFormat("GGyyyy");
        String newDate = "";
        Calendar c = Calendar.getInstance();
        try {
            if (date.matches("^\\d.*")) {
                c.setTime(formatter.parse(date));
            } else {
                c.setTime(formatterBC.parse(date));
            }
            c.add(1, x * 10);
            c.getTime();
            int newEra = c.get(0);
            newDate = newEra > 0 ? formatter.format(c.getTime()).substring(0, 3) : formatterBC.format(c.getTime()).substring(0, 5);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    public static String getXNextCentury(String date, Integer x) {
        date = date + "00";
        int oldEra = 0;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
        SimpleDateFormat formatterBC = new SimpleDateFormat("GGyyyy");
        String newDate = "";
        Calendar c = Calendar.getInstance();
        try {
            if (date.matches("^\\d.*")) {
                c.setTime(formatter.parse(date));
                oldEra = 1;
            } else {
                c.setTime(formatterBC.parse(date));
            }
            c.add(1, x * 100);
            c.getTime();
            int newEra = c.get(0);
            if (newEra > 0) {
                if (oldEra == 0) {
                    c.add(1, -100);
                    c.getTime();
                }
                newDate = formatter.format(c.getTime()).substring(0, 2);
            } else {
                if (oldEra > 0) {
                    c.add(1, 100);
                    c.getTime();
                }
                newDate = formatterBC.format(c.getTime()).substring(0, 4);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    public static String getXNextDay(String date, Integer x) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String newDate = "";
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(formatter.parse(date));
            c.add(5, x);
            c.getTime();
            newDate = formatter.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    public static String getXNextMonth(String date, Integer x) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat formatterBC = new SimpleDateFormat("GGyyyy-MM");
        String newDate = "";
        Calendar c = Calendar.getInstance();
        try {
            if (date.matches("^\\d.*")) {
                c.setTime(formatter.parse(date));
            } else {
                c.setTime(formatterBC.parse(date));
            }
            c.add(2, x);
            c.getTime();
            int newEra = c.get(0);
            newDate = newEra > 0 ? formatter.format(c.getTime()) : formatterBC.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    public static String getXNextWeek(String date, Integer x, Language language) {
        NormalizationManager nm = NormalizationManager.getInstance(language, false);
        String date_no_W = date.replace("W", "");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-w");
        String newDate = "";
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(formatter.parse(date_no_W));
            c.add(3, x);
            c.getTime();
            newDate = formatter.format(c.getTime());
            newDate = newDate.substring(0, 4) + "-W" + nm.getFromNormNumber(newDate.substring(5));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    public static int getWeekdayOfDate(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        int weekday = 0;
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(formatter.parse(date));
            weekday = c.get(7);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return weekday;
    }

    public static int getWeekOfDate(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        int week = 0;
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(formatter.parse(date));
            week = c.get(3);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return week;
    }

    public static Locale getLocaleFromString(String locale) throws LocaleException {
        for (Locale l : Locale.getAvailableLocales()) {
            if (!locale.toLowerCase().equals(l.toString().toLowerCase())) continue;
            return l;
        }
        throw new LocaleException();
    }
}

