/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.utilities;

import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.NormalizationManager;
import de.unihd.dbs.uima.annotator.heideltime.resources.RePatternManager;
import de.unihd.dbs.uima.annotator.heideltime.utilities.DateCalculator;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Toolbox;
import de.unihd.dbs.uima.types.heideltime.Sentence;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import de.unihd.dbs.uima.types.heideltime.Token;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;

public class ContextAnalyzer {
    public static String getLastMentionedX(List<Timex3> linearDates, int i, String x, Language language) {
        NormalizationManager nm = NormalizationManager.getInstance(language, true);
        Timex3 t_i = linearDates.get(i);
        String xValue = "";
        int j = i - 1;
        while (j >= 0) {
            Timex3 timex = linearDates.get(j);
            if (t_i.getBegin() != timex.getBegin()) {
                String value = timex.getTimexValue();
                if (!value.contains("funcDate")) {
                    if (x.equals("century")) {
                        if (value.matches("^[0-9][0-9].*")) {
                            xValue = value.substring(0, 2);
                            break;
                        }
                        if (value.matches("^BC[0-9][0-9].*")) {
                            xValue = value.substring(0, 4);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("decade")) {
                        if (value.matches("^[0-9][0-9][0-9].*")) {
                            xValue = value.substring(0, 3);
                            break;
                        }
                        if (value.matches("^BC[0-9][0-9][0-9].*")) {
                            xValue = value.substring(0, 5);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("year")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9].*")) {
                            xValue = value.substring(0, 4);
                            break;
                        }
                        if (value.matches("^BC[0-9][0-9][0-9][0-9].*")) {
                            xValue = value.substring(0, 6);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("dateYear")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9].*")) {
                            xValue = value;
                            break;
                        }
                        if (value.matches("^BC[0-9][0-9][0-9][0-9].*")) {
                            xValue = value;
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("month")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9]-[0-9][0-9].*")) {
                            xValue = value.substring(0, 7);
                            break;
                        }
                        if (value.matches("^BC[0-9][0-9][0-9][0-9]-[0-9][0-9].*")) {
                            xValue = value.substring(0, 9);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("month-with-details")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9]-[0-9][0-9].*")) {
                            xValue = value;
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("day")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9].*")) {
                            xValue = value.substring(0, 10);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("week")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9].*")) {
                            Iterator<MatchResult> iterator = Toolbox.findMatches(Pattern.compile("^(([0-9][0-9][0-9][0-9])-[0-9][0-9]-[0-9][0-9]).*"), value).iterator();
                            if (!iterator.hasNext()) break;
                            MatchResult r = iterator.next();
                            xValue = r.group(2) + "-W" + DateCalculator.getWeekOfDate(r.group(1));
                            break;
                        }
                        if (value.matches("^[0-9][0-9][0-9][0-9]-W[0-9][0-9].*")) {
                            Iterator<MatchResult> iterator = Toolbox.findMatches(Pattern.compile("^([0-9][0-9][0-9][0-9]-W[0-9][0-9]).*"), value).iterator();
                            if (!iterator.hasNext()) break;
                            MatchResult r = iterator.next();
                            xValue = r.group(1);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("quarter")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9]-[0-9][0-9].*")) {
                            String month = value.substring(5, 7);
                            String quarter = nm.getFromNormMonthInQuarter(month);
                            if (quarter == null) {
                                quarter = "1";
                            }
                            xValue = value.substring(0, 4) + "-Q" + quarter;
                            break;
                        }
                        if (value.matches("^[0-9][0-9][0-9][0-9]-Q[1234].*")) {
                            xValue = value.substring(0, 7);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (x.equals("dateQuarter")) {
                        if (value.matches("^[0-9][0-9][0-9][0-9]-Q[1234].*")) {
                            xValue = value.substring(0, 7);
                            break;
                        }
                        --j;
                        continue;
                    }
                    if (!x.equals("season")) continue;
                    if (value.matches("^[0-9][0-9][0-9][0-9]-[0-9][0-9].*")) {
                        String month = value.substring(5, 7);
                        String season = nm.getFromNormMonthInSeason(month);
                        xValue = value.substring(0, 4) + "-" + season;
                        break;
                    }
                    if (value.matches("^[0-9][0-9][0-9][0-9]-(SP|SU|FA|WI).*")) {
                        xValue = value.substring(0, 7);
                        break;
                    }
                    --j;
                    continue;
                }
                --j;
                continue;
            }
            --j;
        }
        return xValue;
    }

    public static String getClosestTense(Timex3 timex, JCas jcas, Language language) {
        Token token;
        RePatternManager rpm = RePatternManager.getInstance(language, false);
        String lastTense = "";
        String nextTense = "";
        int tokenCounter = 0;
        int lastid = 0;
        int nextid = 0;
        int tid = 0;
        FSIterator iterSentence = jcas.getAnnotationIndex(Sentence.type).iterator();
        Sentence s = new Sentence(jcas);
        while (iterSentence.hasNext() && ((s = (Sentence)((Object)iterSentence.next())).getBegin() > timex.getBegin() || s.getEnd() < timex.getEnd())) {
        }
        TreeMap<Integer, Token> tmToken = new TreeMap<Integer, Token>();
        FSIterator iterToken = jcas.getAnnotationIndex(Token.type).subiterator((AnnotationFS)s);
        while (iterToken.hasNext()) {
            Token token2 = (Token)((Object)iterToken.next());
            tmToken.put(token2.getEnd(), token2);
        }
        for (Integer tokEnd : tmToken.keySet()) {
            ++tokenCounter;
            if (tokEnd < timex.getBegin()) {
                token = (Token)((Object)tmToken.get(tokEnd));
                Logger.printDetail("GET LAST TENSE: string:" + token.getCoveredText() + " pos:" + token.getPos());
                Logger.printDetail("hmAllRePattern.containsKey(tensePos4PresentFuture):" + rpm.get("tensePos4PresentFuture"));
                Logger.printDetail("hmAllRePattern.containsKey(tensePos4Future):" + rpm.get("tensePos4Future"));
                Logger.printDetail("hmAllRePattern.containsKey(tensePos4Past):" + rpm.get("tensePos4Past"));
                Logger.printDetail("CHECK TOKEN:" + token.getPos());
                if (token.getPos() == null) continue;
                if (rpm.containsKey("tensePos4PresentFuture").booleanValue() && token.getPos().matches(rpm.get("tensePos4PresentFuture"))) {
                    lastTense = "PRESENTFUTURE";
                    lastid = tokenCounter;
                    continue;
                }
                if (rpm.containsKey("tensePos4Past").booleanValue() && token.getPos().matches(rpm.get("tensePos4Past"))) {
                    lastTense = "PAST";
                    lastid = tokenCounter;
                    continue;
                }
                if (!rpm.containsKey("tensePos4Future").booleanValue() || !token.getPos().matches(rpm.get("tensePos4Future")) || !token.getCoveredText().matches(rpm.get("tenseWord4Future"))) continue;
                lastTense = "FUTURE";
                lastid = tokenCounter;
                continue;
            }
            if (tid != 0) continue;
            tid = tokenCounter;
        }
        tokenCounter = 0;
        for (Integer tokEnd : tmToken.keySet()) {
            ++tokenCounter;
            if (!nextTense.equals("") || tokEnd <= timex.getEnd()) continue;
            token = (Token)((Object)tmToken.get(tokEnd));
            Logger.printDetail("GET NEXT TENSE: string:" + token.getCoveredText() + " pos:" + token.getPos());
            Logger.printDetail("hmAllRePattern.containsKey(tensePos4PresentFuture):" + rpm.get("tensePos4PresentFuture"));
            Logger.printDetail("hmAllRePattern.containsKey(tensePos4Future):" + rpm.get("tensePos4Future"));
            Logger.printDetail("hmAllRePattern.containsKey(tensePos4Past):" + rpm.get("tensePos4Past"));
            Logger.printDetail("CHECK TOKEN:" + token.getPos());
            if (token.getPos() == null) continue;
            if (rpm.containsKey("tensePos4PresentFuture").booleanValue() && token.getPos().matches(rpm.get("tensePos4PresentFuture"))) {
                nextTense = "PRESENTFUTURE";
                nextid = tokenCounter;
                continue;
            }
            if (rpm.containsKey("tensePos4Past").booleanValue() && token.getPos().matches(rpm.get("tensePos4Past"))) {
                nextTense = "PAST";
                nextid = tokenCounter;
                continue;
            }
            if (!rpm.containsKey("tensePos4Future").booleanValue() || !token.getPos().matches(rpm.get("tensePos4Future")) || !token.getCoveredText().matches(rpm.get("tenseWord4Future"))) continue;
            nextTense = "FUTURE";
            nextid = tokenCounter;
        }
        if (lastTense.equals("")) {
            Logger.printDetail("TENSE: " + nextTense);
            return nextTense;
        }
        if (nextTense.equals("")) {
            Logger.printDetail("TENSE: " + lastTense);
            return lastTense;
        }
        if (tid - lastid > nextid - tid) {
            Logger.printDetail("TENSE: " + nextTense);
            return nextTense;
        }
        Logger.printDetail("TENSE: " + lastTense);
        return lastTense;
    }

    public static String getLastTense(Timex3 timex, JCas jcas, Language language) {
        Token token;
        RePatternManager rpm = RePatternManager.getInstance(language, false);
        String lastTense = "";
        FSIterator iterSentence = jcas.getAnnotationIndex(Sentence.type).iterator();
        Sentence s = new Sentence(jcas);
        while (iterSentence.hasNext() && ((s = (Sentence)((Object)iterSentence.next())).getBegin() > timex.getBegin() || s.getEnd() < timex.getEnd())) {
        }
        TreeMap<Integer, Object> tmToken = new TreeMap<Integer, Object>();
        FSIterator iterToken = jcas.getAnnotationIndex(Token.type).subiterator((AnnotationFS)s);
        while (iterToken.hasNext()) {
            Token token2 = (Token)((Object)iterToken.next());
            tmToken.put(token2.getEnd(), (Object)token2);
        }
        for (Integer tokEnd : tmToken.keySet()) {
            Token token3;
            if (tokEnd < timex.getBegin()) {
                token3 = (Token)((Object)tmToken.get(tokEnd));
                Logger.printDetail("GET LAST TENSE: string:" + token3.getCoveredText() + " pos:" + token3.getPos());
                Logger.printDetail("hmAllRePattern.containsKey(tensePos4PresentFuture):" + rpm.get("tensePos4PresentFuture"));
                Logger.printDetail("hmAllRePattern.containsKey(tensePos4Future):" + rpm.get("tensePos4Future"));
                Logger.printDetail("hmAllRePattern.containsKey(tensePos4Past):" + rpm.get("tensePos4Past"));
                Logger.printDetail("CHECK TOKEN:" + token3.getPos());
                if (token3.getPos() != null) {
                    if (rpm.containsKey("tensePos4PresentFuture").booleanValue() && token3.getPos().matches(rpm.get("tensePos4PresentFuture"))) {
                        lastTense = "PRESENTFUTURE";
                        Logger.printDetail("this tense:" + lastTense);
                    } else if (rpm.containsKey("tensePos4Past").booleanValue() && token3.getPos().matches(rpm.get("tensePos4Past"))) {
                        lastTense = "PAST";
                        Logger.printDetail("this tense:" + lastTense);
                    } else if (rpm.containsKey("tensePos4Future").booleanValue() && token3.getPos().matches(rpm.get("tensePos4Future")) && token3.getCoveredText().matches(rpm.get("tenseWord4Future"))) {
                        lastTense = "FUTURE";
                        Logger.printDetail("this tense:" + lastTense);
                    }
                }
                if (token3.getCoveredText().equals("since")) {
                    lastTense = "PAST";
                    Logger.printDetail("this tense:" + lastTense);
                }
                if (token3.getCoveredText().equals("depuis")) {
                    lastTense = "PAST";
                    Logger.printDetail("this tense:" + lastTense);
                }
            }
            if (!lastTense.equals("") || tokEnd <= timex.getEnd()) continue;
            token3 = (Token)((Object)tmToken.get(tokEnd));
            Logger.printDetail("GET NEXT TENSE: string:" + token3.getCoveredText() + " pos:" + token3.getPos());
            Logger.printDetail("hmAllRePattern.containsKey(tensePos4PresentFuture):" + rpm.get("tensePos4PresentFuture"));
            Logger.printDetail("hmAllRePattern.containsKey(tensePos4Future):" + rpm.get("tensePos4Future"));
            Logger.printDetail("hmAllRePattern.containsKey(tensePos4Past):" + rpm.get("tensePos4Past"));
            Logger.printDetail("CHECK TOKEN:" + token3.getPos());
            if (token3.getPos() == null) continue;
            if (rpm.containsKey("tensePos4PresentFuture").booleanValue() && token3.getPos().matches(rpm.get("tensePos4PresentFuture"))) {
                lastTense = "PRESENTFUTURE";
                Logger.printDetail("this tense:" + lastTense);
                continue;
            }
            if (rpm.containsKey("tensePos4Past").booleanValue() && token3.getPos().matches(rpm.get("tensePos4Past"))) {
                lastTense = "PAST";
                Logger.printDetail("this tense:" + lastTense);
                continue;
            }
            if (!rpm.containsKey("tensePos4Future").booleanValue() || !token3.getPos().matches(rpm.get("tensePos4Future")) || !token3.getCoveredText().matches(rpm.get("tenseWord4Future"))) continue;
            lastTense = "FUTURE";
            Logger.printDetail("this tense:" + lastTense);
        }
        String prevPos = "";
        String longTense = "";
        if (lastTense.equals("PRESENTFUTURE")) {
            for (Integer tokEnd : tmToken.keySet()) {
                if (tokEnd < timex.getBegin()) {
                    token = (Token)((Object)tmToken.get(tokEnd));
                    if (("VHZ".equals(prevPos) || "VBZ".equals(prevPos) || "VHP".equals(prevPos) || "VBP".equals(prevPos) || prevPos.equals("VER:pres")) && ("VVN".equals(token.getPos()) || "VER:pper".equals(token.getPos())) && !token.getCoveredText().equals("expected") && !token.getCoveredText().equals("scheduled")) {
                        lastTense = "PAST";
                        longTense = "PAST";
                        Logger.printDetail("this tense:" + lastTense);
                    }
                    prevPos = token.getPos();
                }
                if (!longTense.equals("") || tokEnd <= timex.getEnd()) continue;
                token = (Token)((Object)tmToken.get(tokEnd));
                if (("VHZ".equals(prevPos) || "VBZ".equals(prevPos) || "VHP".equals(prevPos) || "VBP".equals(prevPos) || "VER:pres".equals(prevPos)) && ("VVN".equals(token.getPos()) || "VER:pper".equals(token.getPos())) && !token.getCoveredText().equals("expected") && !token.getCoveredText().equals("scheduled")) {
                    lastTense = "PAST";
                    longTense = "PAST";
                    Logger.printDetail("this tense:" + lastTense);
                }
                prevPos = token.getPos();
            }
        }
        if (lastTense.equals("PAST")) {
            for (Integer tokEnd : tmToken.keySet()) {
                if (tokEnd < timex.getBegin()) {
                    token = (Token)((Object)tmToken.get(tokEnd));
                    if ("VER:pres".equals(prevPos) && "VER:pper".equals(token.getPos()) && (token.getCoveredText().matches("^pr\u00e9vue?s?$") || token.getCoveredText().equals("^envisag\u00e9e?s?$"))) {
                        lastTense = "FUTURE";
                        longTense = "FUTURE";
                        Logger.printDetail("this tense:" + lastTense);
                    }
                    prevPos = token.getPos();
                }
                if (!longTense.equals("") || tokEnd <= timex.getEnd()) continue;
                token = (Token)((Object)tmToken.get(tokEnd));
                if ("VER:pres".equals(prevPos) && "VER:pper".equals(token.getPos()) && (token.getCoveredText().matches("^pr\u00e9vue?s?$") || token.getCoveredText().equals("^envisag\u00e9e?s?$"))) {
                    lastTense = "FUTURE";
                    longTense = "FUTURE";
                    Logger.printDetail("this tense:" + lastTense);
                }
                prevPos = token.getPos();
            }
        }
        Logger.printDetail("TENSE: " + lastTense);
        return lastTense;
    }

    public static Boolean checkInfrontBehind(MatchResult r, Sentence s) {
        Boolean ok = true;
        if (r.start() > 1 && s.getCoveredText().substring(r.start() - 2, r.start()).matches("\\d\\.")) {
            ok = false;
        }
        if (r.start() > 0 && s.getCoveredText().substring(r.start() - 1, r.start()).matches("[\\w\\$\\+]") && !s.getCoveredText().substring(r.start() - 1, r.start()).matches("\\(")) {
            ok = false;
        }
        if (r.end() < s.getCoveredText().length()) {
            if (s.getCoveredText().substring(r.end(), r.end() + 1).matches("[\u00b0\\w]") && !s.getCoveredText().substring(r.end(), r.end() + 1).matches("\\)")) {
                ok = false;
            }
            if (r.end() + 1 < s.getCoveredText().length() && s.getCoveredText().substring(r.end(), r.end() + 2).matches("[\\.,]\\d")) {
                ok = false;
            }
        }
        return ok;
    }

    public static Boolean checkTokenBoundaries(MatchResult r, Sentence s, JCas jcas) {
        Boolean beginOK = false;
        Boolean endOK = false;
        if (r.end() - r.start() == s.getEnd() - s.getBegin()) {
            return true;
        }
        if (r.start() > 0 && s.getCoveredText().subSequence(r.start() - 1, r.start()).equals(" ") && r.end() < s.getCoveredText().length() && s.getCoveredText().subSequence(r.end(), r.end() + 1).equals(" ")) {
            return true;
        }
        FSIterator iterToken = jcas.getAnnotationIndex(Token.type).subiterator((AnnotationFS)s);
        while (iterToken.hasNext()) {
            Token t = (Token)((Object)iterToken.next());
            if (r.start() + s.getBegin() == t.getBegin()) {
                beginOK = true;
            } else if (r.start() > 0 && (s.getCoveredText().subSequence(r.start() - 1, r.start()).equals(".") || s.getCoveredText().subSequence(r.start() - 1, r.start()).equals("/") || s.getCoveredText().subSequence(r.start() - 1, r.start()).equals("\u2013") || s.getCoveredText().subSequence(r.start() - 1, r.start()).equals("-"))) {
                beginOK = true;
            }
            if (r.end() + s.getBegin() == t.getEnd()) {
                endOK = true;
            } else if (r.end() < s.getCoveredText().length() && (s.getCoveredText().subSequence(r.end(), r.end() + 1).equals(".") || s.getCoveredText().subSequence(r.end(), r.end() + 1).equals("/") || s.getCoveredText().subSequence(r.end(), r.end() + 1).equals("\u2013") || s.getCoveredText().subSequence(r.end(), r.end() + 1).equals("-"))) {
                endOK = true;
            }
            if (!beginOK.booleanValue() || !endOK.booleanValue()) continue;
            return true;
        }
        return false;
    }
}

