/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.resources;

import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceMap;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceScanner {
    private static ResourceScanner INSTANCE = null;
    private final String path = "resources";
    private Set<String> languages = new HashSet<String>();
    private Map<String, ResourceMap> repatterns = new HashMap<String, ResourceMap>();
    private Map<String, ResourceMap> normalizations = new HashMap<String, ResourceMap>();
    private Map<String, ResourceMap> rules = new HashMap<String, ResourceMap>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceScanner getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ResourceScanner> clazz = ResourceScanner.class;
        synchronized (ResourceScanner.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ResourceScanner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private ResourceScanner() {
        String jarFilePath = null;
        try {
            jarFilePath = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (jarFilePath != null) {
            File jarFile = new File(jarFilePath);
            if (jarFile.isFile()) {
                JarFile jar = null;
                try {
                    jar = new JarFile(jarFile);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                Enumeration<JarEntry> entries = jar.entries();
                HashMap<String, JarEntry> jarContents = new HashMap<String, JarEntry>();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    jarContents.put(name, je);
                }
                try {
                    jar.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.scanValidInsideResourcesFolder(jarContents);
                File outFolder = jarFile.getParentFile();
                this.scanValidOutsideResourcesFolder(outFolder);
            } else {
                this.scanValidOutsideResourcesFolder(jarFile);
                File outFolder = new File(jarFile.getParentFile(), "resources");
                if (outFolder.exists()) {
                    this.scanValidOutsideResourcesFolder(outFolder);
                }
            }
        }
        this.languages.addAll(this.repatterns.keySet());
    }

    public static void main(String[] args) {
        ResourceScanner rs = null;
        try {
            rs = new ResourceScanner();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scanValidInsideResourcesFolder(HashMap<String, JarEntry> jarContents) {
        HashMap<String, JarEntry> topLevelEntries = new HashMap<String, JarEntry>();
        for (Map.Entry<String, JarEntry> entry : jarContents.entrySet()) {
            if (!entry.getValue().isDirectory() || !entry.getKey().matches("^[^\\/]+/$")) continue;
            topLevelEntries.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, JarEntry> entry : topLevelEntries.entrySet()) {
            String language = entry.getKey().substring(0, entry.getKey().length() - 1);
            Pattern repatternPattern = Pattern.compile(language + "/repattern/resources_repattern_(.+)\\.txt$");
            Pattern normalizationPattern = Pattern.compile(language + "/normalization/resources_normalization_(.+)\\.txt$");
            Pattern rulePattern = Pattern.compile(language + "/rules/resources_rules_(.+)\\.txt$");
            if (!entry.getValue().isDirectory()) continue;
            Logger.printDetail(ResourceScanner.class, "Testing " + entry.getKey());
            Boolean repatternExists = false;
            Boolean normalizationExists = false;
            Boolean ruleExists = false;
            for (String string : jarContents.keySet()) {
                if (!repatternExists.booleanValue() && repatternPattern.matcher(string).matches()) {
                    repatternExists = true;
                }
                if (!normalizationExists.booleanValue() && normalizationPattern.matcher(string).matches()) {
                    normalizationExists = true;
                }
                if (ruleExists.booleanValue() || !rulePattern.matcher(string).matches()) continue;
                ruleExists = true;
            }
            if (!(repatternExists.booleanValue() && normalizationExists.booleanValue() && ruleExists.booleanValue())) {
                Logger.printDetail(ResourceScanner.class, "We need at least one readable resource file of each type to run.");
                continue;
            }
            Logger.printDetail(ResourceScanner.class, "Valid resource folder.");
            this.repatterns.put(language, new ResourceMap());
            this.normalizations.put(language, new ResourceMap());
            this.rules.put(language, new ResourceMap());
            for (Map.Entry entry2 : jarContents.entrySet()) {
                Matcher m1 = repatternPattern.matcher((CharSequence)entry2.getKey());
                Matcher m2 = normalizationPattern.matcher((CharSequence)entry2.getKey());
                Matcher m3 = rulePattern.matcher((CharSequence)entry2.getKey());
                if (m1.matches()) {
                    this.repatterns.get(language).putInnerFile(m1.group(1), (String)entry2.getKey());
                }
                if (m2.matches()) {
                    this.normalizations.get(language).putInnerFile(m2.group(1), (String)entry2.getKey());
                }
                if (!m3.matches()) continue;
                this.rules.get(language).putInnerFile(m3.group(1), (String)entry2.getKey());
            }
        }
    }

    private void scanValidOutsideResourcesFolder(File resourcePath) {
        File[] pathContents;
        Pattern repatternPattern = Pattern.compile("resources_repattern_(.+)\\.txt$");
        Pattern normalizationPattern = Pattern.compile("resources_normalization_(.+)\\.txt$");
        Pattern rulePattern = Pattern.compile("resources_rules_(.+)\\.txt$");
        for (File supposedLanguagePath : pathContents = resourcePath.listFiles()) {
            Matcher m;
            String language = supposedLanguagePath.getName();
            if (!supposedLanguagePath.isDirectory()) continue;
            Logger.printDetail(ResourceScanner.class, "Testing " + supposedLanguagePath.getAbsolutePath());
            if (!supposedLanguagePath.exists()) {
                Logger.printDetail(ResourceScanner.class, "This path doesn't exist.");
                continue;
            }
            File repatternFolder = new File(supposedLanguagePath, "repattern");
            File normalizationFolder = new File(supposedLanguagePath, "normalization");
            File ruleFolder = new File(supposedLanguagePath, "rules");
            if (!(repatternFolder.exists() && repatternFolder.canRead() && repatternFolder.isDirectory() && normalizationFolder.exists() && normalizationFolder.canRead() && normalizationFolder.isDirectory() && ruleFolder.exists() && ruleFolder.canRead() && ruleFolder.isDirectory())) {
                Logger.printDetail(ResourceScanner.class, "We need at least the folders repattern, normalization and rules in this folder.");
                continue;
            }
            FilenameFilter txtFilter = new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.endsWith(".txt");
                }
            };
            File[] repatternFiles = repatternFolder.listFiles(txtFilter);
            File[] normalizationFiles = normalizationFolder.listFiles(txtFilter);
            File[] ruleFiles = ruleFolder.listFiles(txtFilter);
            if (!(repatternFiles.length != 0 && normalizationFiles.length != 0 && ruleFiles.length != 0 && repatternFiles[0].exists() && repatternFiles[0].canRead() && repatternFiles[0].isFile() && normalizationFiles[0].exists() && normalizationFiles[0].canRead() && normalizationFiles[0].isFile() && ruleFiles[0].exists() && ruleFiles[0].canRead() && ruleFiles[0].isFile())) {
                Logger.printDetail(ResourceScanner.class, "We need at least one readable resource file of each type to run.");
                continue;
            }
            Logger.printDetail(ResourceScanner.class, "Valid resource folder.");
            this.repatterns.put(language, new ResourceMap());
            for (File f : repatternFiles) {
                m = repatternPattern.matcher(f.getName());
                if (!m.matches()) continue;
                this.repatterns.get(language).putOuterFile(m.group(1), f);
            }
            this.normalizations.put(language, new ResourceMap());
            for (File f : normalizationFiles) {
                m = normalizationPattern.matcher(f.getName());
                if (!m.matches()) continue;
                this.normalizations.get(language).putOuterFile(m.group(1), f);
            }
            this.rules.put(language, new ResourceMap());
            for (File f : ruleFiles) {
                m = rulePattern.matcher(f.getName());
                if (!m.matches()) continue;
                this.rules.get(language).putOuterFile(m.group(1), f);
            }
        }
    }

    public ResourceMap getRepatterns(String language) {
        return this.repatterns.get(language);
    }

    public ResourceMap getNormalizations(String language) {
        return this.normalizations.get(language);
    }

    public ResourceMap getRules(String language) {
        return this.rules.get(language);
    }

    public final Set<String> getDetectedResourceFolders() {
        return this.languages;
    }
}

