/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.resources;

import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;

public enum Language {
    ENGLISH("english", "english", "english", "-e"),
    GERMAN("german", "german", "german", ""),
    DUTCH("dutch", "dutch", "dutch", ""),
    ENGLISHCOLL("englishcoll", "englishcoll", "english", "-e"),
    ENGLISHSCI("englishsci", "englishsci", "english", "-e"),
    ITALIAN("italian", "italian", "italian", "-i"),
    SPANISH("spanish", "spanish", "spanish", ""),
    VIETNAMESE("vietnamese", "vietnamese", "vietnamese", ""),
    ARABIC("arabic", "arabic", "arabic", ""),
    FRENCH("french", "french", "french", "-f"),
    CHINESE("chinese", "chinese", "zh", ""),
    RUSSIAN("russian", "russian", "russian", ""),
    CROATIAN("croatian", "croatian", "croatian", ""),
    PORTUGUESE("portuguese", "portuguese", "portuguese", ""),
    ESTONIAN("estonian", "estonian", "estonian", ""),
    WILDCARD("", "", "", "");

    private String languageName;
    private String treeTaggerSwitch;
    private String treeTaggerLangName;
    private String resourceFolder;

    private Language(String languageName, String resourceFolder, String treeTaggerLangName, String treeTaggerSwitch) {
        this.languageName = languageName;
        this.resourceFolder = resourceFolder;
        this.treeTaggerLangName = treeTaggerLangName;
        this.treeTaggerSwitch = treeTaggerSwitch;
    }

    public static final Language getLanguageFromString(String name) {
        if (name == null) {
            Logger.printError("Language parameter was specified as NULL.");
            throw new NullPointerException();
        }
        for (Language l : Language.values()) {
            if (l == WILDCARD || !name.toLowerCase().equals(l.getName().toLowerCase())) continue;
            return l;
        }
        Language.WILDCARD.languageName = name;
        Language.WILDCARD.treeTaggerLangName = name;
        Language.WILDCARD.resourceFolder = name;
        return WILDCARD;
    }

    public final String getName() {
        return this.languageName;
    }

    public final String getTreeTaggerSwitch() {
        return this.treeTaggerSwitch;
    }

    public final String getTreeTaggerLangName() {
        return this.treeTaggerLangName;
    }

    public final String getResourceFolder() {
        return this.resourceFolder;
    }

    public String toString() {
        return this.getName();
    }
}

