/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.processors;

import de.unihd.dbs.uima.annotator.heideltime.utilities.Toolbox;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import de.unihd.dbs.uima.types.heideltime.Timex3Interval;
import java.util.HashSet;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.uima.jcas.JCas;

public class TemponymPostprocessing {
    public static void handleIntervals(JCas jcas) {
        HashSet<Timex3> timexes = new HashSet<Timex3>();
        for (Timex3 t : jcas.getAnnotationIndex(Timex3.type)) {
            if (!t.getTimexType().equals("TEMPONYM")) continue;
            Timex3Interval ti = new Timex3Interval(jcas);
            System.err.println("TEMPONYM: " + t.getCoveredText());
            ti.setBegin(t.getBegin());
            ti.setEnd(t.getEnd());
            ti.setTimexType(t.getTimexType());
            ti.setAllTokIds(t.getAllTokIds());
            ti.setTimexFreq(t.getTimexFreq());
            ti.setTimexMod(t.getTimexMod());
            ti.setTimexQuant(t.getTimexQuant());
            String id = t.getTimexId();
            int newId = Integer.parseInt(id.replace("t", ""));
            ti.setTimexId("t" + (newId += 100000));
            Pattern p = Pattern.compile("\\[(.*?), (.*?), (.*?), (.*?)\\]");
            for (MatchResult mr : Toolbox.findMatches(p, t.getTimexValue())) {
                ti.setTimexValueEB(mr.group(1));
                ti.setTimexValueLB(mr.group(2));
                ti.setTimexValueEE(mr.group(3));
                ti.setTimexValueLE(mr.group(4));
            }
            if (ti.getTimexValueEB() == ti.getTimexValueLB() && ti.getTimexValueLB() == ti.getTimexValueEE() && ti.getTimexValueEE() == ti.getTimexValueLE()) {
                ti.setTimexValue(ti.getTimexValueEB());
                t.setTimexValue(ti.getTimexValueEB());
            } else {
                t.setEmptyValue(t.getTimexValue());
                ti.setTimexValue(ti.getTimexValueLE());
                t.setTimexValue(ti.getTimexValueLE());
            }
            ti.setFoundByRule(t.getFoundByRule());
            ti.addToIndexes();
            timexes.add(t);
        }
        for (Timex3 t : timexes) {
            t.removeFromIndexes();
        }
    }
}

