/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.uima.annotator.heideltime.processors;

import de.unihd.dbs.uima.annotator.heideltime.processors.GenericProcessor;
import de.unihd.dbs.uima.annotator.heideltime.utilities.Logger;
import de.unihd.dbs.uima.types.heideltime.Timex3;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.jcas.JCas;

public class HolidayProcessor
extends GenericProcessor {
    @Override
    public void initialize(UimaContext aContext) {
    }

    @Override
    public void process(JCas jcas) {
        this.evaluateCalculationFunctions(jcas);
    }

    public void evaluateCalculationFunctions(JCas jcas) {
        ArrayList<Timex3> linearDates = new ArrayList<Timex3>();
        for (Timex3 timex : jcas.getAnnotationIndex(Timex3.type)) {
            if (!timex.getTimexType().equals("DATE") && !timex.getTimexType().equals("TIME")) continue;
            linearDates.add(timex);
        }
        Pattern cmd_p = Pattern.compile("((\\w\\w\\w\\w)-(\\w\\w)-(\\w\\w))\\s+funcDateCalc\\((\\w+)\\((.+)\\)\\)");
        Pattern year_p = Pattern.compile("(\\d\\d\\d\\d)");
        Pattern date_p = Pattern.compile("(\\d\\d\\d\\d)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])");
        for (int i = 0; i < linearDates.size(); ++i) {
            Timex3 t_i = (Timex3)((Object)linearDates.get(i));
            String value_i = t_i.getTimexValue();
            Matcher cmd_m = cmd_p.matcher(value_i);
            String valueNew = value_i;
            if (cmd_m.matches()) {
                Matcher year_m;
                String date = cmd_m.group(1);
                String year = cmd_m.group(2);
                String month = cmd_m.group(3);
                String day = cmd_m.group(4);
                String function = cmd_m.group(5);
                String[] args = cmd_m.group(6).split("\\s*,\\s*");
                for (int j = 0; j < args.length; ++j) {
                    args[j] = args[j].replace("DATE", date);
                    args[j] = args[j].replace("YEAR", year);
                    args[j] = args[j].replace("MONTH", month);
                    args[j] = args[j].replace("DAY", day);
                }
                if (function.equals("EasterSunday")) {
                    year_m = year_p.matcher(args[0]);
                    if (year_m.matches()) {
                        valueNew = this.getEasterSunday(Integer.valueOf(args[0]), Integer.valueOf(args[1]));
                    } else {
                        Logger.printError("wrong format");
                        valueNew = "XXXX-XX-XX";
                    }
                } else if (function.equals("WeekdayRelativeTo")) {
                    Matcher date_m = date_p.matcher(args[0]);
                    if (date_m.matches()) {
                        valueNew = this.getWeekdayRelativeTo(args[0], Integer.valueOf(args[1]), Integer.valueOf(args[2]), Boolean.parseBoolean(args[3]));
                    } else {
                        Logger.printError("wrong format");
                        valueNew = "XXXX-XX-XX";
                    }
                } else if (function.equals("EasterSundayOrthodox")) {
                    year_m = year_p.matcher(args[0]);
                    if (year_m.matches()) {
                        valueNew = this.getEasterSundayOrthodox(Integer.valueOf(args[0]), Integer.valueOf(args[1]));
                    } else {
                        Logger.printError("wrong format");
                        valueNew = "XXXX-XX-XX";
                    }
                } else if (function.equals("ShroveTideOrthodox")) {
                    year_m = year_p.matcher(args[0]);
                    if (year_m.matches()) {
                        valueNew = this.getShroveTideWeekOrthodox(Integer.valueOf(args[0]));
                    } else {
                        Logger.printError("wrong format");
                        valueNew = "XXXX-XX-XX";
                    }
                } else {
                    Logger.printError("command not found");
                    valueNew = "XXXX-XX-XX";
                }
            }
            t_i.removeFromIndexes();
            t_i.setTimexValue(valueNew);
            t_i.addToIndexes();
            linearDates.set(i, t_i);
        }
    }

    public String getEasterSunday(int year, int days) {
        int K = year / 100;
        int M = 15 + (3 * K + 3) / 4 - (8 * K + 13) / 25;
        int S = 2 - (3 * K + 3) / 4;
        int A = year % 19;
        int D = (19 * A + M) % 30;
        int R = D / 29 + (D / 28 - D / 29 * (A / 11));
        int OG = 21 + D - R;
        int SZ = 7 - (year + year / 4 + S) % 7;
        int OE = 7 - (OG - SZ) % 7;
        int OS = OG + OE;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        String date = OS <= 31 ? String.format("%04d-03-%02d", year, OS) : String.format("%04d-04-%02d", year, OS - 31);
        try {
            c.setTime(formatter.parse(date));
            c.add(5, days);
            date = formatter.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public String getEasterSunday(int year) {
        return this.getEasterSunday(year, 0);
    }

    public String getEasterSundayOrthodox(int year, int days) {
        int A = year % 4;
        int B = year % 7;
        int C = year % 19;
        int D = (19 * C + 15) % 30;
        int E = (2 * A + 4 * B - D + 34) % 7;
        int Month = (int)Math.floor((D + E + 114) / 31);
        int Day = (D + E + 114) % 31 + 1;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        String date = String.format("%04d-%02d-%02d", year, Month, Day);
        try {
            c.setTime(formatter.parse(date));
            c.add(5, days);
            c.add(5, this.getJulianDifference(year));
            date = formatter.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public String getEasterSundayOrthodox(int year) {
        return this.getEasterSundayOrthodox(year, 0);
    }

    public String getShroveTideWeekOrthodox(int year) {
        String easterOrthodox = this.getEasterSundayOrthodox(year);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = formatter.parse(easterOrthodox);
            calendar.setTime(date);
            calendar.add(5, -49);
            int shroveTideWeek = calendar.get(3);
            if (shroveTideWeek < 10) {
                return year + "-W0" + shroveTideWeek;
            }
            return year + "-W" + shroveTideWeek;
        }
        catch (ParseException pe) {
            Logger.printError("ParseException:" + pe.getMessage());
            return "unknown";
        }
    }

    public String getWeekdayRelativeTo(String date, int weekday, int number, boolean count_itself) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        if (number == 0) {
            try {
                c.setTime(formatter.parse(date));
                date = formatter.format(c.getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return date;
        }
        if (number < 0) {
            ++number;
        }
        try {
            c.setTime(formatter.parse(date));
            int day = c.get(7);
            int add = count_itself && number > 0 || !count_itself && number <= 0 ? (day <= weekday ? weekday - day : weekday - day + 7) : (day < weekday ? weekday - day : weekday - day + 7);
            c.add(5, add += (number - 1) * 7);
            date = formatter.format(c.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public String getWeekdayOfMonth(int number, int weekday, int month, int year) {
        return this.getWeekdayRelativeTo(String.format("%04d-%02d-01", year, month), weekday, number, true);
    }

    private int getJulianDifference(int year) {
        int century = year / 100 + 1;
        if (century < 18) {
            return 10;
        }
        if (century == 18) {
            return 11;
        }
        if (century == 19) {
            return 12;
        }
        if (century == 20 || century == 21) {
            return 13;
        }
        if (century == 22) {
            return 14;
        }
        return 15;
    }
}

