/*
 * Decompiled with CFR 0.152.
 */
package de.unihd.dbs.heideltime.standalone;

import de.unihd.dbs.heideltime.standalone.CLISwitch;
import de.unihd.dbs.heideltime.standalone.Config;
import de.unihd.dbs.heideltime.standalone.DocumentType;
import de.unihd.dbs.heideltime.standalone.OutputType;
import de.unihd.dbs.heideltime.standalone.POSTagger;
import de.unihd.dbs.heideltime.standalone.components.JCasFactory;
import de.unihd.dbs.heideltime.standalone.components.PartOfSpeechTagger;
import de.unihd.dbs.heideltime.standalone.components.ResultFormatter;
import de.unihd.dbs.heideltime.standalone.components.impl.AllLanguagesTokenizerWrapper;
import de.unihd.dbs.heideltime.standalone.components.impl.HunPosTaggerWrapper;
import de.unihd.dbs.heideltime.standalone.components.impl.IntervalTaggerWrapper;
import de.unihd.dbs.heideltime.standalone.components.impl.JCasFactoryImpl;
import de.unihd.dbs.heideltime.standalone.components.impl.JVnTextProWrapper;
import de.unihd.dbs.heideltime.standalone.components.impl.StanfordPOSTaggerWrapper;
import de.unihd.dbs.heideltime.standalone.components.impl.TimeMLResultFormatter;
import de.unihd.dbs.heideltime.standalone.components.impl.TreeTaggerWrapper;
import de.unihd.dbs.heideltime.standalone.components.impl.UimaContextImpl;
import de.unihd.dbs.heideltime.standalone.components.impl.XMIResultFormatter;
import de.unihd.dbs.heideltime.standalone.exceptions.DocumentCreationTimeMissingException;
import de.unihd.dbs.uima.annotator.heideltime.HeidelTime;
import de.unihd.dbs.uima.annotator.heideltime.resources.Language;
import de.unihd.dbs.uima.annotator.heideltime.resources.ResourceScanner;
import de.unihd.dbs.uima.annotator.intervaltagger.IntervalTagger;
import de.unihd.dbs.uima.types.heideltime.Dct;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.XMLInputSource;

public class HeidelTimeStandalone {
    private DocumentType documentType;
    private HeidelTime heidelTime;
    private JCasFactory jcasFactory;
    private Language language;
    private OutputType outputType;
    private POSTagger posTagger;
    private Boolean doIntervalTagging;
    private static Logger logger = Logger.getLogger("HeidelTimeStandalone");

    public HeidelTimeStandalone() {
    }

    public HeidelTimeStandalone(Language language, DocumentType typeToProcess, OutputType outputType) {
        this(language, typeToProcess, outputType, null);
    }

    public HeidelTimeStandalone(Language language, DocumentType typeToProcess, OutputType outputType, String configPath) {
        this.language = language;
        this.documentType = typeToProcess;
        this.outputType = outputType;
        this.initialize(language, typeToProcess, outputType, configPath);
    }

    public HeidelTimeStandalone(Language language, DocumentType typeToProcess, OutputType outputType, String configPath, POSTagger posTagger) {
        this.language = language;
        this.documentType = typeToProcess;
        this.outputType = outputType;
        this.initialize(language, typeToProcess, outputType, configPath, posTagger);
    }

    public HeidelTimeStandalone(Language language, DocumentType typeToProcess, OutputType outputType, String configPath, POSTagger posTagger, Boolean doIntervalTagging) {
        this.language = language;
        this.documentType = typeToProcess;
        this.outputType = outputType;
        this.doIntervalTagging = doIntervalTagging;
        this.initialize(language, typeToProcess, outputType, configPath, posTagger, doIntervalTagging);
    }

    public void initialize(Language language, DocumentType typeToProcess, OutputType outputType, String configPath) {
        this.initialize(language, typeToProcess, outputType, configPath, POSTagger.TREETAGGER);
    }

    public void initialize(Language language, DocumentType typeToProcess, OutputType outputType, String configPath, POSTagger posTagger) {
        this.initialize(language, typeToProcess, outputType, configPath, posTagger, false);
    }

    public void initialize(Language language, DocumentType typeToProcess, OutputType outputType, String configPath, POSTagger posTagger, Boolean doIntervalTagging) {
        logger.log(Level.INFO, "HeidelTimeStandalone initialized with language " + this.language.getName());
        this.posTagger = posTagger;
        this.doIntervalTagging = doIntervalTagging;
        if (!Config.isInitialized()) {
            if (configPath == null) {
                HeidelTimeStandalone.readConfigFile(CLISwitch.CONFIGFILE.getValue().toString());
            } else {
                HeidelTimeStandalone.readConfigFile(configPath);
            }
        }
        try {
            this.heidelTime = new HeidelTime();
            this.heidelTime.initialize((UimaContext)new UimaContextImpl(language, typeToProcess, CLISwitch.VERBOSITY2.getIsActive()));
            logger.log(Level.INFO, "HeidelTime initialized");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "HeidelTime could not be initialized");
        }
        logger.log(Level.FINE, "Initializing JCas factory...");
        try {
            TypeSystemDescription[] descriptions = new TypeSystemDescription[]{UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(this.getClass().getClassLoader().getResource(Config.get("typeSystemHome"))))};
            this.jcasFactory = new JCasFactoryImpl(descriptions);
            logger.log(Level.INFO, "JCas factory initialized");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "JCas factory could not be initialized");
        }
    }

    private void runIntervalTagger(JCas jcas) {
        logger.log(Level.FINEST, "Running Interval Tagger...");
        Integer beforeAnnotations = jcas.getAnnotationIndex().size();
        Properties settings = new Properties();
        settings.put(IntervalTagger.PARAM_LANGUAGE, this.language.getResourceFolder());
        settings.put(IntervalTagger.PARAM_INTERVALS, (Object)true);
        settings.put(IntervalTagger.PARAM_INTERVAL_CANDIDATES, (Object)false);
        IntervalTaggerWrapper iTagger = new IntervalTaggerWrapper();
        iTagger.initialize(settings);
        iTagger.process(jcas);
        Integer afterAnnotations = jcas.getAnnotationIndex().size();
        logger.log(Level.FINEST, "Annotation delta: " + (afterAnnotations - beforeAnnotations));
    }

    private void provideDocumentCreationTime(JCas jcas, Date documentCreationTime) throws DocumentCreationTimeMissingException {
        if (documentCreationTime == null) {
            if (this.documentType == DocumentType.NEWS) {
                throw new DocumentCreationTimeMissingException();
            }
            if (this.documentType == DocumentType.COLLOQUIAL) {
                throw new DocumentCreationTimeMissingException();
            }
        } else {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd'T'HH:mm");
            String formattedDCT = dateFormatter.format(documentCreationTime);
            Dct dct = new Dct(jcas);
            dct.setValue(formattedDCT);
            dct.addToIndexes();
        }
    }

    private void establishHeidelTimePreconditions(JCas jcas) {
        this.establishPartOfSpeechInformation(jcas);
    }

    private void establishPartOfSpeechInformation(JCas jcas) {
        logger.log(Level.FINEST, "Establishing part of speech information...");
        PartOfSpeechTagger partOfSpeechTagger = null;
        Properties settings = new Properties();
        switch (this.language) {
            case ARABIC: {
                if (POSTagger.NO.equals((Object)this.posTagger)) {
                    partOfSpeechTagger = new AllLanguagesTokenizerWrapper();
                    logger.log(Level.INFO, "Be aware that you use the AllLanguagesTokenizer instead of specific preprocessing for Arabic. Thus, tagging results might be very different (and worse).");
                    break;
                }
                partOfSpeechTagger = new StanfordPOSTaggerWrapper();
                settings.put("annotate_tokens", (Object)true);
                settings.put("annotate_sentences", (Object)true);
                settings.put("annotate_partofspeech", (Object)true);
                settings.put("model_path", Config.get("model_path"));
                settings.put("config_path", Config.get("config_path"));
                break;
            }
            case VIETNAMESE: {
                if (POSTagger.NO.equals((Object)this.posTagger)) {
                    partOfSpeechTagger = new AllLanguagesTokenizerWrapper();
                    logger.log(Level.INFO, "Be aware that you use the AllLanguagesTokenizer instead of specific preprocessing for Vietnamese. Thus, tagging results might be very different (and worse).");
                    break;
                }
                partOfSpeechTagger = new JVnTextProWrapper();
                settings.put("annotate_tokens", (Object)true);
                settings.put("annotate_sentences", (Object)true);
                settings.put("annotate_partofspeech", (Object)true);
                settings.put("word_model_path", Config.get("word_model_path"));
                settings.put("sent_model_path", Config.get("sent_model_path"));
                settings.put("pos_model_path", Config.get("pos_model_path"));
                break;
            }
            case CROATIAN: {
                if (POSTagger.NO.equals((Object)this.posTagger)) {
                    partOfSpeechTagger = new AllLanguagesTokenizerWrapper();
                    logger.log(Level.INFO, "Be aware that you use the AllLanguagesTokenizer instead of specific preprocessing for Croatian. Thus, tagging results might be very different (and worse).");
                    break;
                }
                partOfSpeechTagger = new HunPosTaggerWrapper();
                settings.put("language", (Object)this.language);
                settings.put("annotate_tokens", (Object)true);
                settings.put("annotate_pos", (Object)true);
                settings.put("annotate_sentences", (Object)true);
                settings.put("model_path", Config.get("hunpos_model_name"));
                break;
            }
            default: {
                if (POSTagger.STANFORDPOSTAGGER.equals((Object)this.posTagger)) {
                    partOfSpeechTagger = new StanfordPOSTaggerWrapper();
                    settings.put("annotate_tokens", (Object)true);
                    settings.put("annotate_sentences", (Object)true);
                    settings.put("annotate_partofspeech", (Object)true);
                    settings.put("model_path", Config.get("model_path"));
                    settings.put("config_path", Config.get("config_path"));
                    break;
                }
                if (POSTagger.TREETAGGER.equals((Object)this.posTagger)) {
                    partOfSpeechTagger = new TreeTaggerWrapper();
                    settings.put("language", (Object)this.language);
                    settings.put("annotateTokens", (Object)true);
                    settings.put("annotateSentences", (Object)true);
                    settings.put("annotatePartOfSpeech", (Object)true);
                    settings.put("improveGermanSentences", (Object)(this.language == Language.GERMAN ? 1 : 0));
                    settings.put("ChineseTokenizerPath", Config.get("chineseTokenizerPath"));
                    break;
                }
                if (POSTagger.HUNPOS.equals((Object)this.posTagger)) {
                    partOfSpeechTagger = new HunPosTaggerWrapper();
                    settings.put("language", (Object)this.language);
                    settings.put("annotate_tokens", (Object)true);
                    settings.put("annotate_pos", (Object)true);
                    settings.put("annotate_sentences", (Object)true);
                    settings.put("model_path", Config.get("hunpos_model_name"));
                    break;
                }
                if (POSTagger.NO.equals((Object)this.posTagger)) {
                    partOfSpeechTagger = new AllLanguagesTokenizerWrapper();
                    logger.log(Level.INFO, "Be aware that you use the AllLanguagesTokenizer instead of specific preprocessing for the selected language. If proper preprocessing for the specified language (." + this.language.getName() + ") is available, this might results in better temporal tagging quality.");
                    break;
                }
                logger.log(Level.FINEST, "Sorry, but you can't use that tagger.");
            }
        }
        partOfSpeechTagger.initialize(settings);
        partOfSpeechTagger.process(jcas);
        partOfSpeechTagger.reset();
        logger.log(Level.FINEST, "Part of speech information established");
    }

    private ResultFormatter getFormatter() {
        if (this.outputType.toString().equals("xmi")) {
            return new XMIResultFormatter();
        }
        return new TimeMLResultFormatter();
    }

    public String process(String document) throws DocumentCreationTimeMissingException {
        return this.process(document, null, this.getFormatter());
    }

    public String process(String document, Date documentCreationTime) throws DocumentCreationTimeMissingException {
        return this.process(document, documentCreationTime, this.getFormatter());
    }

    public String process(String document, ResultFormatter resultFormatter) throws DocumentCreationTimeMissingException {
        return this.process(document, null, resultFormatter);
    }

    public String process(String document, Date documentCreationTime, ResultFormatter resultFormatter) throws DocumentCreationTimeMissingException {
        logger.log(Level.INFO, "Processing started");
        logger.log(Level.FINE, "Generate CAS object");
        JCas jcas = null;
        try {
            jcas = this.jcasFactory.createJCas();
            jcas.setDocumentText(document);
            logger.log(Level.FINE, "CAS object generated");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Cas object could not be generated");
        }
        try {
            logger.log(Level.FINER, "Establishing preconditions...");
            this.provideDocumentCreationTime(jcas, documentCreationTime);
            this.establishHeidelTimePreconditions(jcas);
            logger.log(Level.FINER, "Preconditions established");
            this.heidelTime.process(jcas);
            logger.log(Level.INFO, "Processing finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Processing aborted due to errors");
        }
        if (this.doIntervalTagging.booleanValue()) {
            this.runIntervalTagger(jcas);
        }
        logger.log(Level.FINE, "Formatting result...");
        String result = null;
        try {
            result = resultFormatter.format(jcas);
            logger.log(Level.INFO, "Result formatted");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Result could not be formatted");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object language2;
        String docPath = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                Object sw = CLISwitch.getEnumFromSwitch(args[i]);
                if (sw == null) {
                    logger.log(Level.WARNING, "Unsupported switch: " + args[i] + ". Quitting.");
                    System.exit(-1);
                }
                if (sw.getHasFollowingValue()) {
                    if (args.length > i + 1 && !args[i + 1].startsWith("-")) {
                        sw.setValue(args[++i]);
                        continue;
                    }
                    logger.log(Level.WARNING, "Invalid or missing parameter after " + args[i] + ". Quitting.");
                    System.exit(-1);
                    continue;
                }
                sw.setValue(null);
                continue;
            }
            docPath = args[i];
        }
        if (CLISwitch.HELP.getIsActive()) {
            HeidelTimeStandalone.printHelp();
            System.exit(0);
        }
        if (CLISwitch.VERBOSITY2.getIsActive()) {
            logger.setLevel(Level.ALL);
            logger.log(Level.INFO, "Verbosity: '-vv'; Logging level set to ALL.");
            String languagesList = "";
            for (Object language2 : ResourceScanner.getInstance().getDetectedResourceFolders()) {
                languagesList = languagesList + System.getProperty("line.separator") + "- " + language2;
            }
            logger.log(Level.INFO, "Listing detected language folders:" + languagesList);
        } else if (CLISwitch.VERBOSITY.getIsActive()) {
            logger.setLevel(Level.INFO);
            logger.log(Level.INFO, "Verbosity: '-v'; Logging level set to INFO and above.");
        } else {
            logger.setLevel(Level.WARNING);
            logger.log(Level.INFO, "Verbosity -v/-vv NOT FOUND OR RECOGNIZED; Logging level set to WARNING and above.");
        }
        String encodingType = null;
        if (CLISwitch.ENCODING.getIsActive()) {
            encodingType = CLISwitch.ENCODING.getValue().toString();
            logger.log(Level.INFO, "Encoding '-e': " + encodingType);
        } else {
            encodingType = CLISwitch.ENCODING.getValue().toString();
            logger.log(Level.INFO, "Encoding '-e': NOT FOUND OR RECOGNIZED; set to 'UTF-8'");
        }
        OutputType outputType = null;
        if (CLISwitch.OUTPUTTYPE.getIsActive()) {
            outputType = OutputType.valueOf(CLISwitch.OUTPUTTYPE.getValue().toString().toUpperCase());
            logger.log(Level.INFO, "Output '-o': " + outputType.toString().toUpperCase());
        } else {
            outputType = (OutputType)((Object)CLISwitch.OUTPUTTYPE.getValue());
            logger.log(Level.INFO, "Output '-o': NOT FOUND OR RECOGNIZED; set to " + outputType.toString().toUpperCase());
        }
        language2 = null;
        if (CLISwitch.LANGUAGE.getIsActive()) {
            language2 = Language.getLanguageFromString((String)CLISwitch.LANGUAGE.getValue());
            if (language2 == Language.WILDCARD && !ResourceScanner.getInstance().getDetectedResourceFolders().contains(((Language)((Object)language2)).getName())) {
                logger.log(Level.SEVERE, "Language '-l': " + CLISwitch.LANGUAGE.getValue() + " NOT RECOGNIZED; aborting.");
                HeidelTimeStandalone.printHelp();
                System.exit(-1);
            } else {
                logger.log(Level.INFO, "Language '-l': " + ((Language)((Object)language2)).getName());
            }
        } else {
            language2 = Language.getLanguageFromString((String)CLISwitch.LANGUAGE.getValue());
            logger.log(Level.INFO, "Language '-l': NOT FOUND; set to " + ((Language)((Object)language2)).toString().toUpperCase());
        }
        DocumentType type = null;
        if (CLISwitch.DOCTYPE.getIsActive()) {
            try {
                if (CLISwitch.DOCTYPE.getValue().equals("narrative")) {
                    CLISwitch.DOCTYPE.setValue("narratives");
                }
                type = DocumentType.valueOf(CLISwitch.DOCTYPE.getValue().toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Type '-t': NOT RECOGNIZED. These are the available options: " + Arrays.asList(DocumentType.values()));
                System.exit(-1);
            }
            logger.log(Level.INFO, "Type '-t': " + type.toString().toUpperCase());
        } else {
            type = (DocumentType)((Object)CLISwitch.DOCTYPE.getValue());
            logger.log(Level.INFO, "Type '-t': NOT FOUND; set to " + type.toString().toUpperCase());
        }
        Date dct = null;
        if (CLISwitch.DCT.getIsActive()) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                dct = formatter.parse(CLISwitch.DCT.getValue().toString());
                logger.log(Level.INFO, "Document Creation Time '-dct': " + dct.toString());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Document Creation Time '-dct': NOT RECOGNIZED. Quitting.");
                HeidelTimeStandalone.printHelp();
                System.exit(-1);
            }
        } else if (type == DocumentType.NEWS || type == DocumentType.COLLOQUIAL) {
            dct = (Date)CLISwitch.DCT.getValue();
            logger.log(Level.INFO, "Document Creation Time '-dct': NOT FOUND; set to local date (" + dct.toString() + ").");
        } else {
            logger.log(Level.INFO, "Document Creation Time '-dct': NOT FOUND; skipping.");
        }
        String locale = (String)CLISwitch.LOCALE.getValue();
        Locale myLocale = null;
        if (CLISwitch.LOCALE.getIsActive()) {
            for (Locale l : Locale.getAvailableLocales()) {
                if (!l.toString().toLowerCase().equals(locale.toLowerCase())) continue;
                myLocale = l;
            }
            try {
                Locale.setDefault(myLocale);
                logger.log(Level.INFO, "Locale '-locale': " + myLocale.toString());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Supplied locale parameter couldn't be resolved to a working locale. Try one of these:");
                logger.log(Level.WARNING, Arrays.asList(Locale.getAvailableLocales()).toString());
                HeidelTimeStandalone.printHelp();
                System.exit(-1);
            }
        } else {
            logger.log(Level.INFO, "Locale '-locale': NOT FOUND, set to environment locale: " + Locale.getDefault().toString());
        }
        String configPath = CLISwitch.CONFIGFILE.getValue().toString();
        try {
            logger.log(Level.INFO, "Configuration path '-c': " + configPath);
            HeidelTimeStandalone.readConfigFile(configPath);
            logger.log(Level.FINE, "Config initialized");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Config could not be initialized! Please supply the -c switch or put a config.props into this directory.");
            HeidelTimeStandalone.printHelp();
            System.exit(-1);
        }
        POSTagger posTagger = null;
        if (CLISwitch.POSTAGGER.getIsActive()) {
            try {
                posTagger = POSTagger.valueOf(CLISwitch.POSTAGGER.getValue().toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Given POS Tagger doesn't exist. Please specify a valid one as listed in the help.");
                HeidelTimeStandalone.printHelp();
                System.exit(-1);
            }
            logger.log(Level.INFO, "POS Tagger '-pos': " + posTagger.toString().toUpperCase());
        } else {
            posTagger = (POSTagger)((Object)CLISwitch.POSTAGGER.getValue());
            logger.log(Level.INFO, "POS Tagger '-pos': NOT FOUND OR RECOGNIZED; set to " + posTagger.toString().toUpperCase());
        }
        Boolean doIntervalTagging = false;
        if (CLISwitch.INTERVALS.getIsActive()) {
            doIntervalTagging = CLISwitch.INTERVALS.getIsActive();
            logger.log(Level.INFO, "Interval Tagger '-it': " + doIntervalTagging.toString());
        } else {
            logger.log(Level.INFO, "Interval Tagger '-it': NOT FOUND OR RECOGNIZED; set to " + doIntervalTagging.toString());
        }
        if (docPath == null) {
            logger.log(Level.WARNING, "No input file given; aborting.");
            HeidelTimeStandalone.printHelp();
            System.exit(-1);
        }
        RandomAccessFile aFile = null;
        MappedByteBuffer buffer = null;
        AbstractInterruptibleChannel inChannel = null;
        PrintWriter pwOut = null;
        try {
            logger.log(Level.INFO, "Reading document using charset: " + encodingType);
            aFile = new RandomAccessFile(docPath, "r");
            inChannel = aFile.getChannel();
            buffer = ((FileChannel)inChannel).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)inChannel).size());
            buffer.load();
            byte[] inArr = new byte[(int)((FileChannel)inChannel).size()];
            for (int i = 0; i < buffer.limit(); ++i) {
                inArr[i] = buffer.get();
            }
            String input = new String(new String(inArr, encodingType).getBytes("UTF-8"), "UTF-8");
            HeidelTimeStandalone standalone = new HeidelTimeStandalone((Language)((Object)language2), type, outputType, null, posTagger, doIntervalTagging);
            String out = standalone.process(input, dct);
            pwOut = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            pwOut.println(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pwOut != null) {
                pwOut.close();
            }
            if (buffer != null) {
                buffer.clear();
            }
            if (inChannel != null) {
                try {
                    inChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (aFile != null) {
                try {
                    aFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void readConfigFile(String configPath) {
        FileInputStream configStream = null;
        try {
            logger.log(Level.INFO, "trying to read in file " + configPath);
            configStream = new FileInputStream(configPath);
            Properties props = new Properties();
            props.load(configStream);
            Config.setProps(props);
            ((InputStream)configStream).close();
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "couldn't open configuration file \"" + configPath + "\". quitting.");
            System.exit(-1);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "couldn't close config file handle");
            e.printStackTrace();
        }
    }

    private static void printHelp() {
        String path = HeidelTimeStandalone.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        String filename = path.substring(path.lastIndexOf(System.getProperty("file.separator")) + 1);
        System.out.println("HeidelTime Standalone");
        System.out.println("Copyright \u00a9 2011-2016 Jannik Str\u00f6tgen");
        System.out.println("This software is free. See the COPYING file for copying conditions.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  java -jar " + filename + " <input-document> [-param1 <value1> ...]");
        System.out.println();
        System.out.println("Parameters and expected values:");
        for (CLISwitch c : CLISwitch.values()) {
            System.out.println("  " + c.getSwitchString() + "\t" + (c.getSwitchString().length() > 4 ? "" : "\t") + c.getName());
            if (c == CLISwitch.LANGUAGE) {
                System.out.print("\t\tAvailable languages: [ ");
                for (Enum enum_ : Language.values()) {
                    if (enum_ == Language.WILDCARD) continue;
                    System.out.print(((Language)enum_).getName().toLowerCase() + " ");
                }
                System.out.println("]");
            }
            if (c == CLISwitch.POSTAGGER) {
                System.out.print("\t\tAvailable taggers: [ ");
                for (Enum enum_ : POSTagger.values()) {
                    System.out.print(enum_.toString().toLowerCase() + " ");
                }
                System.out.println("]");
            }
            if (c != CLISwitch.DOCTYPE) continue;
            System.out.print("\t\tAvailable types: [ ");
            for (Enum enum_ : DocumentType.values()) {
                System.out.print(enum_.toString().toLowerCase() + " ");
            }
            System.out.println("]");
        }
        System.out.println();
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public final POSTagger getPosTagger() {
        return this.posTagger;
    }

    public final void setPosTagger(POSTagger posTagger) {
        this.posTagger = posTagger;
    }
}

