/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.kd.models;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KD_Model {
    private Path current_language_path = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(KD_Model.class);

    public static boolean checkLanguageFolder(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.exists(Paths.get(path.toString(), ".valid_kd_languages_folder"), new LinkOption[0]);
    }

    public String getCurrent_language_path() {
        return this.current_language_path.toString();
    }

    public KD_Model(Path path) {
        this.current_language_path = path;
        if (!KD_Model.checkLanguageFolder(path)) {
            LOGGER.warn("Attention -- language folder not exists... I try to rebuild a new one");
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                File marker_file = new File(path.toString() + File.separator + ".valid_kd_languages_folder");
                marker_file.createNewFile();
                Path new_lang_zip = Paths.get(path.toString(), "languages.zip");
                byte[] bytes = Resources.toByteArray((URL)Resources.getResource((String)"languages.zip"));
                Files.write(new_lang_zip, bytes, new OpenOption[0]);
                ZipFile zipFile = new ZipFile(new_lang_zip.toFile());
                Enumeration<? extends ZipEntry> enu = zipFile.entries();
                while (enu.hasMoreElements()) {
                    int length;
                    ZipEntry zipEntry = enu.nextElement();
                    String name = zipEntry.getName();
                    File file = new File(path.toString() + File.separator + name);
                    if (name.endsWith("/")) {
                        file.mkdirs();
                        continue;
                    }
                    File parent = file.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    InputStream is = zipFile.getInputStream(zipEntry);
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) >= 0) {
                        fos.write(buffer, 0, length);
                    }
                    is.close();
                    fos.close();
                }
                zipFile.close();
                this.current_language_path = path;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LOGGER.info("KD configuration folder:" + path);
        }
    }
}

