/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core.strings;

import eu.fbk.utils.core.strings.EditDistance;

public class JaroWinklerDistance
implements EditDistance<Double> {
    private static final int PREFIX_LENGTH_LIMIT = 4;
    public static final int INDEX_NOT_FOUND = -1;

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        double defaultScalingFactor = 0.1;
        double percentageRoundValue = 100.0;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        double jaro = JaroWinklerDistance.score(left, right);
        int cl = JaroWinklerDistance.commonPrefixLength(left, right);
        double matchScore = (double)Math.round((jaro + 0.1 * (double)cl * (1.0 - jaro)) * 100.0) / 100.0;
        return matchScore;
    }

    private static int commonPrefixLength(CharSequence first, CharSequence second) {
        int result = JaroWinklerDistance.getCommonPrefix(first.toString(), second.toString()).length();
        return result > 4 ? 4 : result;
    }

    public static String getCommonPrefix(String ... strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        int smallestIndexOfDiff = JaroWinklerDistance.indexOfDifference(strs);
        if (smallestIndexOfDiff == -1) {
            if (strs[0] == null) {
                return "";
            }
            return strs[0];
        }
        if (smallestIndexOfDiff == 0) {
            return "";
        }
        return strs[0].substring(0, smallestIndexOfDiff);
    }

    protected static double score(CharSequence first, CharSequence second) {
        String shorter;
        String longer;
        if (first.length() > second.length()) {
            longer = first.toString().toLowerCase();
            shorter = second.toString().toLowerCase();
        } else {
            longer = second.toString().toLowerCase();
            shorter = first.toString().toLowerCase();
        }
        int halflength = shorter.length() / 2 + 1;
        String m1 = JaroWinklerDistance.getSetOfMatchingCharacterWithin(shorter, longer, halflength);
        String m2 = JaroWinklerDistance.getSetOfMatchingCharacterWithin(longer, shorter, halflength);
        if (m1.length() == 0 || m2.length() == 0) {
            return 0.0;
        }
        if (m1.length() != m2.length()) {
            return 0.0;
        }
        int transpositions = JaroWinklerDistance.transpositions(m1, m2);
        double defaultDenominator = 3.0;
        double dist = ((double)m1.length() / (double)shorter.length() + (double)m2.length() / (double)longer.length() + (double)(m1.length() - transpositions) / (double)m1.length()) / 3.0;
        return dist;
    }

    protected static int transpositions(CharSequence first, CharSequence second) {
        int transpositions = 0;
        for (int i = 0; i < first.length(); ++i) {
            if (first.charAt(i) == second.charAt(i)) continue;
            ++transpositions;
        }
        return transpositions / 2;
    }

    protected static int indexOfDifference(CharSequence ... css) {
        if (css == null || css.length <= 1) {
            return -1;
        }
        boolean anyStringNull = false;
        boolean allStringsNull = true;
        int arrayLen = css.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        for (int i = 0; i < arrayLen; ++i) {
            if (css[i] == null) {
                anyStringNull = true;
                shortestStrLen = 0;
                continue;
            }
            allStringsNull = false;
            shortestStrLen = Math.min(css[i].length(), shortestStrLen);
            longestStrLen = Math.max(css[i].length(), longestStrLen);
        }
        if (allStringsNull || longestStrLen == 0 && !anyStringNull) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = css[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (css[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }

    protected static String getSetOfMatchingCharacterWithin(CharSequence first, CharSequence second, int limit) {
        StringBuilder common = new StringBuilder();
        StringBuilder copy = new StringBuilder(second);
        for (int i = 0; i < first.length(); ++i) {
            char ch = first.charAt(i);
            boolean found = false;
            for (int j = Math.max(0, i - limit); !found && j < Math.min(i + limit, second.length()); ++j) {
                if (copy.charAt(j) != ch) continue;
                found = true;
                common.append(ch);
                copy.setCharAt(j, '*');
            }
        }
        return common.toString();
    }
}

