/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core.core;

import eu.fbk.utils.core.io.FileUtils;
import java.io.File;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    static Logger logger = LoggerFactory.getLogger(StringUtil.class);
    private static final DecimalFormat tf = new DecimalFormat("000,000,000.#");
    private static final DecimalFormat df = new DecimalFormat("###,###,###,###");
    private static final Pattern tabPattern = Pattern.compile("\t");

    public static String[] split(String str, char ch, int size) {
        String[] a = new String[size];
        int j = str.indexOf(ch);
        int k = 0;
        int i = 0;
        while (j != -1) {
            a[i++] = str.substring(k, j);
            str = str.substring(j + 1, str.length());
            j = str.indexOf(ch);
        }
        a[i++] = str.substring(j + 1, str.length());
        return a;
    }

    public static List<String> split(String str, char ch) {
        ArrayList<String> list = new ArrayList<String>();
        int j = str.indexOf(ch);
        int k = 0;
        while (j != -1) {
            list.add(str.substring(k, j));
            str = str.substring(j + 1, str.length());
            j = str.indexOf(ch);
        }
        str = str.substring(j + 1, str.length());
        list.add(str);
        return list;
    }

    public static String[] splitST(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        int size = st.countTokens();
        String[] a = new String[size];
        int i = 0;
        while (st.hasMoreTokens()) {
            a[i++] = st.nextToken();
        }
        return a;
    }

    public static void testMySplit1(File file, int size) throws Exception {
        logger.info("testMySplit1");
        long begin = 0L;
        long end = 0L;
        long time = 0L;
        begin = System.nanoTime();
        String s = FileUtils.read(file, size);
        end = System.nanoTime();
        time = end - begin;
        begin = System.nanoTime();
        LineNumberReader lnr = new LineNumberReader(new StringReader(s));
        String line = null;
        List<String> m = null;
        boolean c = false;
        while ((line = lnr.readLine()) != null) {
            m = StringUtil.split(line, '\t');
        }
        lnr.close();
        end = System.nanoTime();
        time = end - begin;
        logger.info(file + " (" + df.format(size) + ") parsed in " + tf.format(time));
    }

    public static void testFastSplit(File file, int size) throws Exception {
        logger.info("testFastSplit");
        long begin = 0L;
        long end = 0L;
        long time = 0L;
        begin = System.nanoTime();
        String s = FileUtils.read(file, size);
        end = System.nanoTime();
        time = end - begin;
        begin = System.nanoTime();
        LineNumberReader lnr = new LineNumberReader(new StringReader(s));
        String line = null;
        String[] a = null;
        Object b = null;
        boolean c = false;
        while ((line = lnr.readLine()) != null) {
            a = StringUtil.split(line, '\t', 6);
        }
        lnr.close();
        end = System.nanoTime();
        time = end - begin;
        logger.info(file + " (" + df.format(size) + ") parsed in " + tf.format(time));
    }

    public static void testSTSplit(File file, int size) throws Exception {
        logger.info("testSTSplit");
        long begin = 0L;
        long end = 0L;
        long time = 0L;
        begin = System.nanoTime();
        String s = FileUtils.read(file, size);
        end = System.nanoTime();
        time = end - begin;
        begin = System.nanoTime();
        LineNumberReader lnr = new LineNumberReader(new StringReader(s));
        String line = null;
        String[] a = null;
        Object b = null;
        boolean c = false;
        while ((line = lnr.readLine()) != null) {
            a = StringUtil.splitST(line, "\t");
        }
        lnr.close();
        end = System.nanoTime();
        time = end - begin;
        logger.info(file + " (" + df.format(size) + ") parsed in " + tf.format(time));
    }

    public static void testRegexSplit(File file, int size) throws Exception {
        logger.info("testRegexSplit");
        long begin = 0L;
        long end = 0L;
        long time = 0L;
        begin = System.nanoTime();
        String s = FileUtils.read(file, size);
        end = System.nanoTime();
        time = end - begin;
        begin = System.nanoTime();
        LineNumberReader lnr = new LineNumberReader(new StringReader(s));
        String line = null;
        String[] a = null;
        Object b = null;
        boolean c = false;
        while ((line = lnr.readLine()) != null) {
            a = tabPattern.split(line);
        }
        lnr.close();
        end = System.nanoTime();
        time = end - begin;
        logger.info(file + " (" + df.format(size) + ") parsed in " + tf.format(time));
    }

    public static void testMySplitFast(File file, int size) throws Exception {
        logger.info("testMySplitFast");
        long begin = 0L;
        long end = 0L;
        long time = 0L;
        begin = System.nanoTime();
        String s = FileUtils.read(file, size);
        end = System.nanoTime();
        time = end - begin;
        begin = System.nanoTime();
        List<String> l = StringUtil.split(s, '\n');
        String[] m = null;
        for (int i = 0; i < l.size(); ++i) {
            m = StringUtil.split(l.get(i), '\t', 6);
        }
        end = System.nanoTime();
        time = end - begin;
        logger.info(file + " (" + df.format(size) + ") parsed in " + tf.format(time));
    }

    public static void testMySplit(File file, int size) throws Exception {
        logger.info("testMySplit");
        long begin = 0L;
        long end = 0L;
        long time = 0L;
        begin = System.nanoTime();
        String s = FileUtils.read(file, size);
        end = System.nanoTime();
        time = end - begin;
        begin = System.nanoTime();
        List<String> l = StringUtil.split(s, '\n');
        List<String> m = null;
        for (int i = 0; i < l.size(); ++i) {
            m = StringUtil.split(l.get(i), '\t');
        }
        end = System.nanoTime();
        time = end - begin;
        logger.info(file + " (" + df.format(size) + ") parsed in " + tf.format(time));
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            logger.info("java -mx1024M eu.fbk.utils.core.core.StringUtil file size");
            System.exit(-1);
        }
        File file = new File(args[0]);
        int size = Integer.parseInt(args[1]);
        StringUtil.testMySplit(file, size);
        StringUtil.testRegexSplit(file, size);
        StringUtil.testMySplit1(file, size);
        StringUtil.testSTSplit(file, size);
        StringUtil.testFastSplit(file, size);
        StringUtil.testMySplitFast(file, size);
    }
}

