/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLHelper {
    public static Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream stream = new FileInputStream(file);
        return XMLHelper.getDocument(stream);
    }

    public static Document getDocument(Path filePath) throws IOException, ParserConfigurationException, SAXException {
        return XMLHelper.getDocument(filePath.toFile());
    }

    public static Document getDocument(InputStream stream) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(stream);
        doc.getDocumentElement().normalize();
        return doc;
    }

    public static XPath getXPath() {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        return xpath;
    }

    public static NodeList getNodeList(InputStream stream, String pattern) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        return XMLHelper.getNodeList(XMLHelper.getDocument(stream), pattern);
    }

    public static NodeList getNodeList(Document doc, XPath xPath, String pattern) throws XPathExpressionException {
        XPathExpression expr = xPath.compile(pattern);
        NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        return nl;
    }

    public static NodeList getNodeList(Document doc, String pattern) throws XPathExpressionException {
        XPath xpath = XMLHelper.getXPath();
        return XMLHelper.getNodeList(doc, xpath, pattern);
    }

    public static Node getNode(String tagName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            return node;
        }
        return null;
    }

    public static String getNodeValue(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int x = 0; x < childNodes.getLength(); ++x) {
            Node data = childNodes.item(x);
            if (data.getNodeType() != 3) continue;
            return data.getNodeValue();
        }
        return "";
    }

    public static String getNodeValue(String tagName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            NodeList childNodes = node.getChildNodes();
            for (int y = 0; y < childNodes.getLength(); ++y) {
                Node data = childNodes.item(y);
                if (data.getNodeType() != 3) continue;
                return data.getNodeValue();
            }
        }
        return "";
    }

    public static String getNodeAttr(String attrName, Node node) {
        NamedNodeMap attrs = node.getAttributes();
        for (int y = 0; y < attrs.getLength(); ++y) {
            Node attr = attrs.item(y);
            if (!attr.getNodeName().equalsIgnoreCase(attrName)) continue;
            return attr.getNodeValue();
        }
        return "";
    }

    public static String getNodeAttr(String tagName, String attrName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            NodeList childNodes = node.getChildNodes();
            for (int y = 0; y < childNodes.getLength(); ++y) {
                Node data = childNodes.item(y);
                if (data.getNodeType() != 2 || !data.getNodeName().equalsIgnoreCase(attrName)) continue;
                return data.getNodeValue();
            }
        }
        return "";
    }
}

