/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Network {
    private static final Logger LOGGER = LoggerFactory.getLogger(Network.class);
    private static final String USER_AGENT = "FBK Utils";

    public static String encodeMap(Map<String, String> pars) {
        StringBuffer buffer = new StringBuffer();
        for (String key : pars.keySet()) {
            String value = pars.get(key);
            if (buffer.length() > 0) {
                buffer.append("&");
            }
            buffer.append(key);
            buffer.append("=");
            try {
                buffer.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public static String postRequest(String urlPath, Map<String, String> pars) throws IOException {
        return Network.postRequest(urlPath, Network.encodeMap(pars));
    }

    public static String postRequest(String urlPath, String pars) throws IOException {
        String inputLine;
        URL obj = new URL(urlPath);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(pars);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadPage(String urlPath) throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = (hostname, session) -> true;
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        InputStream is = null;
        try {
            String line;
            URL url = new URL(urlPath);
            is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuffer b = new StringBuffer();
            while ((line = br.readLine()) != null) {
                b.append(line).append(System.getProperty("line.separator"));
            }
            String string = b.toString();
            return string;
        }
        catch (MalformedURLException e) {
            LOGGER.warn(e.getMessage());
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String url = "https://translate.yandex.net/api/v1.5/tr.json/translate";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "trnsl.1.1.20171010T091318Z.1e87b765f05f625b.099f046a438c4dd1efac8bbbd3a6f9f7d80fc866");
        map.put("lang", "it-en");
        map.put("text", "Il cane dorme sul tappeto.");
        map.put("options", "4");
        try {
            Network.postRequest(url, map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

