/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.utils.core;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import eu.fbk.utils.core.IO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Dictionary<T>
implements Iterable<T> {
    private final Map<T, Integer> map;
    private final List<T> list;

    private Dictionary(Map<T, Integer> map, List<T> list) {
        this.map = map;
        this.list = list;
    }

    private static boolean isTextFormat(String filename) {
        String name = filename.toLowerCase();
        return name.endsWith(".tsv") || name.endsWith(".txt") || name.contains(".tsv.") || name.contains(".txt.");
    }

    private static <T> Function<String, T> valueOfFunction(Class<T> clazz) {
        Executable executable = null;
        for (String name : new String[]{"valueOf", "fromString"}) {
            try {
                Method method = clazz.getDeclaredMethod(name, String.class);
                if (!Modifier.isStatic(method.getModifiers()) || !clazz.isAssignableFrom(method.getReturnType())) continue;
                executable = method;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            executable = clazz.getConstructor(String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (executable == null) {
            throw new IllegalArgumentException("Don't know how to transform strings into instances of " + clazz);
        }
        final Constructor<T> theExecutable = executable;
        return new Function<String, T>(){

            @Override
            public T apply(String string) {
                try {
                    if (theExecutable instanceof Method) {
                        return ((Method)theExecutable).invoke(null, string);
                    }
                    return ((Constructor)theExecutable).newInstance(string);
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new Error(ex);
                }
                catch (InvocationTargetException ex) {
                    Throwables.throwIfUnchecked((Throwable)ex.getCause());
                    throw new RuntimeException(ex.getCause());
                }
            }
        };
    }

    public static <T> Dictionary<T> create() {
        return new Dictionary(new HashMap(), new ArrayList());
    }

    public static <T> Dictionary<T> create(Dictionary<T> dictionary) {
        return new Dictionary<T>(new HashMap<T, Integer>(dictionary.map), new ArrayList<T>(dictionary.list));
    }

    public static <T> Dictionary<T> readFrom(Class<T> elementClass, Path path) throws IOException {
        try (InputStream stream = IO.buffer(Files.newInputStream(path, new OpenOption[0]));){
            if (Dictionary.isTextFormat(path.toString())) {
                Dictionary<T> dictionary = Dictionary.readFrom(elementClass, IO.utf8Reader(stream));
                return dictionary;
            }
            Dictionary<T> dictionary = Dictionary.readFrom(elementClass, stream);
            return dictionary;
        }
    }

    public static <T> Dictionary<T> readFrom(Class<T> elementClass, InputStream stream) throws IOException {
        Dictionary<T> dictionary = Dictionary.create();
        ObjectInputStream ois = new ObjectInputStream(stream);
        int size = ois.readInt();
        try {
            for (int i = 0; i < size; ++i) {
                T element = elementClass.cast(ois.readObject());
                dictionary.map.put(element, i);
                dictionary.list.add(element);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Invalid file content", ex);
        }
        return dictionary;
    }

    public static <T> Dictionary<T> readFrom(Class<T> elementClass, Reader reader) throws IOException {
        String line;
        Dictionary<T> dictionary = Dictionary.create();
        BufferedReader in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        Function<String, String> valueOfFunction = Dictionary.valueOfFunction(elementClass);
        while ((line = in.readLine()) != null) {
            T element = valueOfFunction.apply(line.trim());
            dictionary.map.put(element, dictionary.list.size());
            dictionary.list.add(element);
        }
        return dictionary;
    }

    public void writeTo(Path path) throws IOException {
        try (OutputStream stream = IO.buffer(Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));){
            if (Dictionary.isTextFormat(path.toString())) {
                this.writeTo(IO.utf8Writer(stream));
            } else {
                this.writeTo(stream);
            }
        }
    }

    public void writeTo(OutputStream stream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeInt(this.list.size());
        for (T element : this.list) {
            oos.writeObject(element);
        }
        oos.flush();
    }

    public void writeTo(Writer writer) throws IOException {
        for (int i = 0; i < this.list.size(); ++i) {
            writer.append(this.list.get(i).toString()).append('\n');
        }
        writer.flush();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.list.iterator());
    }

    @Nullable
    public Integer indexFor(T element) {
        Integer index = this.map.get(element);
        if (index == null && !(this.list instanceof ImmutableList)) {
            index = this.list.size();
            this.list.add(element);
            this.map.put(element, index);
        }
        return index;
    }

    @Nullable
    public T elementFor(int index) {
        try {
            return this.list.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("No element for index " + index + " (size is " + this.size() + ")");
        }
    }

    public Dictionary<T> freeze() {
        if (this.list instanceof ImmutableList) {
            return this;
        }
        return new Dictionary<T>(ImmutableMap.copyOf(this.map), ImmutableList.copyOf(this.list));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Dictionary)) {
            return false;
        }
        Dictionary other = (Dictionary)object;
        return this.map.equals(other.map) && this.list.equals(other.list);
    }

    public int hashCode() {
        return Objects.hash(this.map, this.list);
    }

    public String toString() {
        return this.map.toString();
    }
}

