/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.kd.lib;

import eu.fbk.dh.kd.lib.KD_core;
import eu.fbk.dh.kd.lib.KD_utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class KD_loader {
    Map<String, Double> base;

    public static synchronized void run_the_updater(KD_core.Language lang, String languagePackPath) {
        try {
            BufferedWriter out;
            String filePath;
            Properties prop;
            String pathPrefix = languagePackPath + File.separator + (Object)((Object)lang) + File.separator;
            if (!new File(pathPrefix + "config.properties").exists()) {
                prop = new Properties();
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(pathPrefix + "config.properties");
                    prop.setProperty("keyconcept_yes_md5", "");
                    prop.setProperty("keyconcept_no_md5", "");
                    prop.setProperty("lemma_list_md5", "");
                    prop.setProperty("lemma_blacklist_md5", "");
                    prop.setProperty("stop_list_md5", "");
                    prop.setProperty("synonyms_md5", "");
                    prop.setProperty("pos_blacklist_md5", "");
                    prop.setProperty("invFreq_md5", "");
                    prop.setProperty("properNounPosList_md5", "");
                    prop.store(output, null);
                    ((OutputStream)output).close();
                }
                catch (Exception e) {
                    System.err.println("Error during the  \"config.properties\" file creation");
                }
            }
            prop = new Properties();
            FileInputStream input = null;
            try {
                input = new FileInputStream(pathPrefix + "config.properties");
                prop.load(input);
                ((InputStream)input).close();
            }
            catch (Exception e) {
                System.err.println("Error while loading \"config.properties\" file ");
            }
            if (prop.getProperty("keyconcept_yes_md5") == null) {
                prop.setProperty("keyconcept_yes_md5", "");
            }
            if (prop.getProperty("keyconcept_no_md5") == null) {
                prop.setProperty("keyconcept_no_md5", "");
            }
            if (prop.getProperty("lemma_list_md5") == null) {
                prop.setProperty("lemma_list_md5", "");
            }
            if (prop.getProperty("lemma_blacklist_md5") == null) {
                prop.setProperty("lemma_blacklist_md5", "");
            }
            if (prop.getProperty("stop_list_md5") == null) {
                prop.setProperty("stop_list_md5", "");
            }
            if (prop.getProperty("pos_blacklist_md5") == null) {
                prop.setProperty("pos_blacklist_md5", "");
            }
            if (prop.getProperty("synonyms_md5") == null) {
                prop.setProperty("synonyms_md5", "");
            }
            if (prop.getProperty("invFreq_md5") == null) {
                prop.setProperty("invFreq_md5", "");
            }
            if (prop.getProperty("properNounPosList_md5") == null) {
                prop.setProperty("properNounPosList_md5", "");
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "keyconcept-yes.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "keyconcept-yes.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "keyconcept-no.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "keyconcept-no.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "lemmalist.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "lemmalist.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "lemma-no.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "lemma-no.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "pos-no.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "pos-no.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "stoplist.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "stoplist.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "synonyms.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "synonyms.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "idf_lang.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "idf_lang.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (!new File(pathPrefix + "configuration_files" + File.separator + "properNounPosList.txt").exists()) {
                filePath = pathPrefix + "configuration_files" + File.separator + "properNounPosList.txt";
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));
                out.write("");
                out.close();
            }
            if (prop.getProperty("keyconcept_yes_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "keyconcept-yes.txt")) != 0) {
                prop.setProperty("keyconcept_yes_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "keyconcept-yes.txt"));
                System.out.println("Something is changed in the keyconcept white list... I'm working on that!");
                KD_loader.make_whitelist(pathPrefix + "configuration_files" + File.separator + "keyconcept-yes.txt", lang);
            }
            if (prop.getProperty("keyconcept_no_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "keyconcept-no.txt")) != 0) {
                prop.setProperty("keyconcept_no_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "keyconcept-no.txt"));
                System.out.println("Something is changed in the keyconcept black list... I'm working on that!");
                KD_loader.make_blacklist(pathPrefix + "configuration_files" + File.separator + "keyconcept-no.txt", lang);
            }
            if (prop.getProperty("lemma_list_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "lemmalist.txt")) != 0) {
                prop.setProperty("lemma_list_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "lemmalist.txt"));
                System.out.println("Something is changed in the lemma list... I'm working on that!");
                KD_loader.make_lemma_list(pathPrefix + "configuration_files" + File.separator + "lemmalist.txt", lang);
            }
            if (prop.getProperty("lemma_blacklist_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "lemma-no.txt")) != 0) {
                prop.setProperty("lemma_blacklist_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "lemma-no.txt"));
                System.out.println("Something is changed in the lemma black list... I'm working on that!");
                KD_loader.make_lemma_blacklist(pathPrefix + "configuration_files" + File.separator + "lemma-no.txt", lang);
            }
            if (prop.getProperty("pos_blacklist_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "pos-no.txt")) != 0) {
                prop.setProperty("pos_blacklist_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "pos-no.txt"));
                System.out.println("Something is changed in the pos black list... I'm working on that!");
                KD_loader.make_pos_blacklist(pathPrefix + "configuration_files" + File.separator + "pos-no.txt", lang);
            }
            if (prop.getProperty("stop_list_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "stoplist.txt")) != 0) {
                prop.setProperty("stop_list_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "stoplist.txt"));
                System.out.println("Something is changed in the stopword list... I'm working on that!");
                KD_loader.make_stoplist(pathPrefix + "configuration_files" + File.separator + "stoplist.txt", lang);
            }
            if (prop.getProperty("synonyms_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "synonyms.txt")) != 0) {
                prop.setProperty("synonyms_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "synonyms.txt"));
                System.out.println("Something is changed in the synonyms list... I'm working on that!");
                KD_loader.make_synonyms(pathPrefix + "configuration_files" + File.separator + "synonyms.txt", lang);
            }
            if (prop.getProperty("invFreq_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "idf_lang.txt")) != 0) {
                prop.setProperty("invFreq_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "idf_lang.txt"));
                System.out.println("Something is changed in the idf file... I'm working on that!");
                KD_loader.make_invFreqFile(pathPrefix + "configuration_files" + File.separator + "idf_lang.txt", lang);
            }
            if (prop.getProperty("properNounPosList_md5").compareTo(KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "properNounPosList.txt")) != 0) {
                prop.setProperty("properNounPosList_md5", KD_utils.md5(pathPrefix + "configuration_files" + File.separator + "properNounPosList.txt"));
                System.out.println("Something is changed in the proper noun pos file... I'm working on that!");
                KD_loader.make_properNounPosList(pathPrefix + "configuration_files" + File.separator + "properNounPosList.txt", lang);
            }
            try {
                FileOutputStream output = new FileOutputStream(pathPrefix + "config.properties");
                prop.store(output, null);
            }
            catch (Exception e) {
                System.err.println("Error while storing \"config.properties\" file ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("mmm... somthing goes wrong in update cofiguration process... try to re-launch");
        }
    }

    private static void make_invFreqFile(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("invdocfreq").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)lineItems[0], (Object)Double.parseDouble(lineItems[1]));
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_lemma_list(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("lemmata").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        invfreq.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)lineItems[0].trim().toLowerCase(), (Object)0.0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_blacklist(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("blacklist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        invfreq.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)("\u00f7\u2022\u00f7" + lineItems[0].trim().replace(" ", "\u00f7\u2022\u00f7").replace("_", "\u00f7\u2022\u00f7").toLowerCase()), (Object)0.0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_whitelist(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("whitelist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        invfreq.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)lineItems[0].trim().toLowerCase(), (Object)0.0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_properNounPosList(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("properNounPos_blacklist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        invfreq.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)lineItems[0].toLowerCase(), (Object)0.0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_stoplist(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("stoplist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        invfreq.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)("\u00f7\u2022\u00f7" + lineItems[0].trim().replace(" ", "\u00f7\u2022\u00f7").replace("_", "\u00f7\u2022\u00f7").toLowerCase()), (Object)0.0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_lemma_blacklist(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("lemma_blacklist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        invfreq.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)lineItems[0].toLowerCase(), (Object)0.0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_pos_blacklist(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap invfreq = db.hashMap("pos_blacklist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).createOrOpen();
        invfreq.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            while ((line = in.readLine()) != null) {
                String[] lineItems = line.split("\t");
                invfreq.put((Object)lineItems[0].toLowerCase(), (Object)0.0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        invfreq.close();
        db.close();
    }

    private static void make_synonyms(String filePath, KD_core.Language lang) {
        File f = new File(filePath);
        File dbFile = new File(f.getParentFile().getParent().toString() + File.separator + lang.toString() + ".map");
        DB db = DBMaker.fileDB((File)dbFile).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().make();
        HTreeMap synonyms = db.hashMap("synonyms").keySerializer((Serializer)Serializer.JAVA).valueSerializer((Serializer)Serializer.INTEGER).createOrOpen();
        synonyms.clear();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = "";
            String lineModded = "";
            while ((line = in.readLine()) != null) {
                lineModded = line;
                lineModded = "\u00f7\u2022\u00f7" + lineModded;
                lineModded = lineModded.replace(" ", "|\u00f7\u2022\u00f7").replace("_", "\u00f7\u2022\u00f7");
                String[] lineItems = lineModded.split("\\|");
                ArrayList<String> synonymsEntries = new ArrayList<String>();
                for (String s : lineItems) {
                    synonymsEntries.add(s);
                }
                synonyms.put(synonymsEntries, (Object)0);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        synonyms.close();
        db.close();
    }
}

