/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.kd.lib;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KD_keyconcept {
    String value;
    public int frequency = 0;
    public double score = 0.0;
    public double normalized_score = 0.0;
    int chainlenght = 0;
    Double scoreBoost = 1.0;
    Double patternScoreBoost = 0.0;
    Double idf = 1.0;
    Map<String, Integer> collected_variation = new HashMap<String, Integer>();
    ArrayList<Integer> position_in_text = new ArrayList();
    ArrayList<Integer> sentences_in_text = new ArrayList();
    ArrayList<String> elements = new ArrayList();
    ArrayList<String> elementsLemma = new ArrayList();
    ArrayList<String> elementsToken = new ArrayList();
    ArrayList<String> elementsStem = new ArrayList();
    List<String> elementsPos = new ArrayList<String>();
    boolean frequencyrecounted = false;
    ArrayList<String> synonyms = new ArrayList();
    boolean isAcronym = false;
    boolean isAbstract = false;

    void appendToValue(String s) {
        this.value = this.value + " " + s;
    }

    void incrementFrequency() {
        ++this.frequency;
    }

    void setPosChain(String[] chain) {
        this.elementsPos = Arrays.asList(chain);
    }

    void cleanup(String s) {
        String[] tokens;
        for (String tkn : tokens = s.split("\u00f7\u2022\u00f7")) {
            if (tkn.trim().length() <= 0) continue;
            this.elements.add(tkn.trim());
        }
        this.chainlenght = this.elements.size();
    }

    void cleanupLemma(String s) {
        String[] lemmas;
        for (String lemma : lemmas = s.split("\u00f7\u2022\u00f7")) {
            if (lemma.trim().length() <= 0) continue;
            this.elementsLemma.add(lemma.trim());
        }
    }

    void cleanupStem(String s) {
        String[] stems;
        for (String stem : stems = s.split("\u00f7\u2022\u00f7")) {
            if (stem.trim().length() <= 0) continue;
            this.elementsStem.add(stem.trim());
        }
    }

    void cleanupToken(String s) {
        String[] tokenss;
        for (String tok : tokenss = s.split("\u00f7\u2022\u00f7")) {
            if (tok.trim().length() <= 0) continue;
            this.elementsToken.add(tok.trim());
        }
    }

    void add_variation(String s) {
        if (!this.collected_variation.containsKey(s.toLowerCase())) {
            this.collected_variation.put(s.toLowerCase(), 1);
        } else {
            this.collected_variation.put(s.toLowerCase(), this.collected_variation.get(s.toLowerCase()) + 1);
        }
    }

    KD_keyconcept mergeValue(KD_keyconcept o) {
        this.frequency += o.frequency;
        this.position_in_text.addAll(o.position_in_text);
        this.sentences_in_text.addAll(o.sentences_in_text);
        this.collected_variation = Stream.of(this.collected_variation, o.collected_variation).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
        return this;
    }

    void calculateNormFreqByToken(Integer tot_tokens) {
        this.score = (double)this.frequency / (double)tot_tokens.intValue() * 1000.0;
    }

    void calculateNormFreqBySentence(Integer tot_sentences) {
        this.score = (double)this.frequency / (double)tot_sentences.intValue() * 1000.0;
    }

    void addCurrentPosition(Integer i) {
        this.position_in_text.add(i);
    }

    void addCurrentSentence(Integer i) {
        this.sentences_in_text.add(i);
    }

    public String getString() {
        return Joiner.on((String)" ").join(this.elements);
    }

    public String getSysnonyms() {
        return Joiner.on((String)", ").join(this.synonyms);
    }

    public ArrayList<String> getSysnonymsArray() {
        return this.synonyms;
    }

    public ArrayList<Integer> getHeadOfRetrievedKey() {
        return this.position_in_text;
    }

    public String getStemString() {
        return Joiner.on((String)" ").join(this.elementsStem);
    }

    public String getTokenString() {
        return Joiner.on((String)" ").join(this.elementsToken);
    }

    public String getLemmaString() {
        return Joiner.on((String)" ").join(this.elementsLemma);
    }

    public ArrayList<String> getLemmaArray() {
        return this.elementsLemma;
    }

    public ArrayList<String> getStemArray() {
        return this.elementsStem;
    }

    public ArrayList<String> getTokenArray() {
        return this.elementsToken;
    }

    public List<String> getPosList() {
        return Lists.reverse(this.elementsPos);
    }

    public Double getIdf() {
        return this.idf;
    }

    public Double getScoreBoost() {
        return this.scoreBoost;
    }

    public Double getPatternBoost() {
        return this.patternScoreBoost;
    }

    public Integer getTokenChainLength() {
        return this.chainlenght;
    }

    public static String getArrayString(ArrayList<String> array) {
        return Joiner.on((String)" ").join(array);
    }

    public ArrayList<String> getMostUsedVariation() {
        ArrayList<String> variation = new ArrayList<String>();
        String out = "";
        Optional first = this.collected_variation.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(1L).findFirst();
        if (first.isPresent()) {
            String[] tokenss;
            out = (String)first.get().getKey();
            for (String tok : tokenss = out.split("\u00f7\u2022\u00f7")) {
                if (tok.trim().length() <= 0) continue;
                variation.add(tok.trim());
            }
        }
        return variation;
    }

    public ArrayList<ArrayList<String>> getAllTheVariationsArray() {
        ArrayList<ArrayList<String>> variations = new ArrayList<ArrayList<String>>();
        for (String var : this.collected_variation.keySet()) {
            String[] tokenss;
            ArrayList<String> variation = new ArrayList<String>();
            for (String tok : tokenss = var.split("\u00f7\u2022\u00f7")) {
                if (tok.trim().length() <= 0) continue;
                variation.add(tok.trim());
            }
            variations.add(variation);
        }
        return variations;
    }

    public String toString() {
        Collections.sort(this.position_in_text);
        return this.getTokenString() + "\t" + this.getLemmaString() + "\t" + this.getStemString() + "\t(" + Joiner.on((String)", ").join(this.synonyms) + ")\tfrequency: " + this.frequency + " ,score: " + this.score + " idf: " + this.idf + " boost " + this.scoreBoost + " pattern_boost " + this.patternScoreBoost + " chain_l " + this.chainlenght;
    }
}

