/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.kd.lib;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import eu.fbk.dh.kd.lib.KD_concept_sorter;
import eu.fbk.dh.kd.lib.KD_configuration;
import eu.fbk.dh.kd.lib.KD_extractor;
import eu.fbk.dh.kd.lib.KD_keyconcept;
import eu.fbk.dh.kd.lib.KD_loader;
import eu.fbk.dh.kd.lib.KD_rerank_methods;
import eu.fbk.dh.kd.lib.Recounter;
import eu.fbk.dh.kd.lib.RelatedExpressionExtractorThread;
import eu.fbk.dh.kd.lib.Resultset_Record;
import eu.fbk.dh.kd.models.KD_Model;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math.util.MathUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KD_core {
    private static final Logger LOGGER = LoggerFactory.getLogger(KD_core.class);
    private KD_Model model = new KD_Model(FileSystems.getDefault().getPath(KD_configuration.getDefault_laguage_pack_localtion(), new String[0]));
    private Logger logger = LoggerFactory.getLogger(KD_core.class);
    Integer threadsNumber = 2;
    private DB languageDB = null;
    private HTreeMap<String, Double> hashLemmaBlackKey = null;
    private HTreeMap<String, Double> hashFileLemmata = null;
    private HTreeMap<String, Double> hashPosBlackKey = null;
    private HTreeMap<String, Double> hashProperNounPosBlackKey = null;
    private HTreeMap<String, Double> hashFileKey = null;
    private HTreeMap<ArrayList<String>, Integer> hashFileStoplistDB = null;
    private HTreeMap<ArrayList<String>, Integer> hashFileSynonyms = null;

    public static String getVersion() {
        return KD_core.class.getPackage().getImplementationTitle() + " - " + KD_core.class.getPackage().getImplementationVendor() + " (" + KD_core.class.getPackage().getImplementationVersion() + ") developed by Giovanni Moretti";
    }

    public KD_core(Threads t) {
        switch (t) {
            case ONE: {
                this.threadsNumber = 1;
                break;
            }
            case TWO: {
                this.threadsNumber = 2;
                break;
            }
            case FOUR: {
                this.threadsNumber = 4;
                break;
            }
            case SIX: {
                this.threadsNumber = 6;
                break;
            }
            case EIGHT: {
                this.threadsNumber = 8;
                break;
            }
            case TEN: {
                this.threadsNumber = 10;
                break;
            }
            case TWELVE: {
                this.threadsNumber = 12;
                break;
            }
            default: {
                this.threadsNumber = 2;
            }
        }
    }

    public KD_core(Threads t, Language lang, KD_configuration configuration) {
        switch (t) {
            case ONE: {
                this.threadsNumber = 1;
                break;
            }
            case TWO: {
                this.threadsNumber = 2;
                break;
            }
            case FOUR: {
                this.threadsNumber = 4;
                break;
            }
            case SIX: {
                this.threadsNumber = 6;
                break;
            }
            case EIGHT: {
                this.threadsNumber = 8;
                break;
            }
            case TEN: {
                this.threadsNumber = 10;
                break;
            }
            case TWELVE: {
                this.threadsNumber = 12;
                break;
            }
            default: {
                this.threadsNumber = 2;
            }
        }
        String pathPrefix = configuration.languagePackPath + File.separator + (Object)((Object)lang) + File.separator;
        this.languageDB = DBMaker.fileDB((File)new File(pathPrefix + (Object)((Object)lang) + ".map")).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().readOnly().make();
        this.hashLemmaBlackKey = this.languageDB.hashMap("lemma_blacklist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).open();
        this.hashFileLemmata = this.languageDB.hashMap("lemmata").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).open();
        this.hashPosBlackKey = this.languageDB.hashMap("pos_blacklist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).open();
        this.hashProperNounPosBlackKey = this.languageDB.hashMap("properNounPos_blacklist").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).open();
        this.hashFileKey = this.languageDB.hashMap("invdocfreq").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).open();
        this.hashFileStoplistDB = this.languageDB.hashMap("stoplist").keySerializer((Serializer)Serializer.JAVA).valueSerializer((Serializer)Serializer.INTEGER).open();
        this.hashFileSynonyms = this.languageDB.hashMap("synonyms").keySerializer((Serializer)Serializer.JAVA).valueSerializer((Serializer)Serializer.INTEGER).open();
    }

    public void createNewEmptyLanguage(String name, KD_configuration configuration) {
        String languageMainFolder;
        File laguageFolder;
        if (this.model.getCurrent_language_path().compareTo(configuration.languagePackPath) != 0) {
            this.model = new KD_Model(Paths.get(configuration.languagePackPath, new String[0]));
        }
        if ((laguageFolder = new File(languageMainFolder = configuration.languagePackPath + File.separator + name + File.separator)).exists()) {
            this.logger.error("A folder with this name already exists in the \"languages\" folder! Please change name or delete the previously created directory");
            return;
        }
        laguageFolder.mkdirs();
        laguageFolder = new File(languageMainFolder);
        String example_of_patterns_file = "# The # char is the comment.See the other languages for a complete example \n#Example of a Bigram: \"Tag_adj\",\"Tag_noun\",weight(1 is neutral)\n#Unigrams\n\"Tag_For_adjective\", 1\n\"Tag_For_noun\", 1\n\n#Bigrams\n\"Tag_for_adjective\",\"Tag_for_noun\",1";
        try {
            String tagset = configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "tagset" + File.separator + "TEXTPRO";
            File tset = new File(tagset);
            tset.mkdirs();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tagset + File.separator + "patterns.txt"), "UTF-8"));
            out.write(example_of_patterns_file);
            out.close();
            tagset = configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "tagset" + File.separator + "TREETAGGER";
            tset = new File(tagset);
            tset.mkdirs();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tagset + File.separator + "patterns.txt"), "UTF-8"));
            out.write(example_of_patterns_file);
            out.close();
            tagset = configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "tagset" + File.separator + "STANFORD";
            tset = new File(tagset);
            tset.mkdirs();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tagset + File.separator + "patterns.txt"), "UTF-8"));
            out.write(example_of_patterns_file);
            out.close();
            tagset = configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "tagset" + File.separator + "CUSTOM";
            tset = new File(tagset);
            tset.mkdirs();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tagset + File.separator + "patterns.txt"), "UTF-8"));
            out.write(example_of_patterns_file);
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "synonyms.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "stoplist.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "properNounPosList.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "pos-no.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "lemmalist.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "lemma-no.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "keyconcept-no.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "keyconcept-yes.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "idf_lang.txt"), "UTF-8"));
            out.write("");
            out.close();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.languagePackPath + File.separator + name + File.separator + "configuration_files" + File.separator + "capitalization_pos.txt"), "UTF-8"));
            out.write("");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties prop = new Properties();
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(languageMainFolder + File.separator + "config.properties");
            prop.setProperty("keyconcept_yes_md5", "");
            prop.setProperty("keyconcept_no_md5", "");
            prop.setProperty("lemma_list_md5", "");
            prop.setProperty("lemma_blacklist_md5", "");
            prop.setProperty("stop_list_md5", "");
            prop.setProperty("synonyms_md5", "");
            prop.setProperty("pos_blacklist_md5", "");
            prop.setProperty("invFreq_md5", "");
            prop.setProperty("properNounPosList_md5", "");
            prop.store(output, null);
            ((OutputStream)output).close();
        }
        catch (Exception e) {
            this.logger.error("Error during the  \"config.properties\" file creation");
        }
        Language lang = Language.CUSTOM;
        lang.set_Custom_Language(name.toUpperCase());
        KD_loader.run_the_updater(lang, configuration.languagePackPath);
    }

    /*
     * WARNING - void declaration
     */
    public LinkedList<KD_keyconcept> extractExpressions(Language lang, KD_configuration configuration, String filePath, StringBuffer fileContent) {
        if (this.model.getCurrent_language_path().compareTo(Paths.get(configuration.languagePackPath, new String[0]).toString()) != 0) {
            this.model = new KD_Model(Paths.get(configuration.languagePackPath, new String[0]));
        }
        LinkedList<KD_keyconcept> outputList = new LinkedList<KD_keyconcept>();
        String pathPrefix = configuration.languagePackPath + File.separator + (Object)((Object)lang) + File.separator;
        if (filePath == null) {
            filePath = "";
        }
        if (fileContent == null) {
            fileContent = new StringBuffer();
        }
        if (filePath.length() == 0 && fileContent.length() == 0) {
            LOGGER.warn("No valid data submitted to KD");
            return outputList;
        }
        Integer numberOfConcepts = configuration.numberOfConcepts;
        Integer local_frequency_threshold = configuration.local_frequency_threshold;
        KD_configuration.Prefer_Specific_Concept prefer_speficic_concept = configuration.prefer_specific_concept;
        boolean rerank_by_position = configuration.rerank_by_position;
        KD_configuration.ColumExtraction column_configuration = configuration.column_configuration;
        boolean only_multiword = configuration.only_multiword;
        boolean no_syn = configuration.no_syn;
        boolean no_rerank = configuration.no_rerank;
        Integer averaging_cycles = 1;
        Integer absorbtion_cycles = 1;
        boolean rerank_by_token_lenght = false;
        boolean rerank_shorter_first_by_average = false;
        boolean rerank_shorter_first_by_boosting = false;
        boolean rerank_longer_first_by_absorbtion = false;
        ExecutorService executor = null;
        ForkJoinPool p = new ForkJoinPool(this.threadsNumber);
        if (this.languageDB == null) {
            this.languageDB = DBMaker.fileDB((File)new File(pathPrefix + (Object)((Object)lang) + ".map")).fileMmapEnable().fileMmapEnableIfSupported().fileMmapPreclearDisable().closeOnJvmShutdown().readOnly().make();
        }
        switch (prefer_speficic_concept) {
            case WEAK: {
                rerank_by_token_lenght = true;
                break;
            }
            case MEDIUM: {
                rerank_by_token_lenght = true;
                rerank_shorter_first_by_average = true;
                averaging_cycles = 1;
                break;
            }
            case STRONG: {
                rerank_by_token_lenght = true;
                rerank_shorter_first_by_average = true;
                rerank_shorter_first_by_boosting = true;
                rerank_longer_first_by_absorbtion = true;
                averaging_cycles = 1;
                absorbtion_cycles = 1;
                break;
            }
            case MAX: {
                rerank_by_token_lenght = true;
                rerank_shorter_first_by_average = true;
                rerank_longer_first_by_absorbtion = true;
                rerank_shorter_first_by_boosting = true;
                averaging_cycles = 2;
                absorbtion_cycles = 2;
                break;
            }
            case NO: {
                rerank_by_token_lenght = false;
                rerank_shorter_first_by_average = false;
                rerank_longer_first_by_absorbtion = false;
                rerank_shorter_first_by_boosting = false;
                averaging_cycles = 0;
                absorbtion_cycles = 0;
                break;
            }
            default: {
                rerank_by_token_lenght = false;
                rerank_shorter_first_by_average = false;
                rerank_longer_first_by_absorbtion = false;
                rerank_shorter_first_by_boosting = false;
                averaging_cycles = 0;
                absorbtion_cycles = 0;
            }
        }
        List futures = null;
        int record_id = 1;
        int tot_sentences = 1;
        int totalNumberOfToken = 0;
        StringBuffer recomposedTextFile = new StringBuffer();
        ArrayList<Resultset_Record> records = new ArrayList<Resultset_Record>();
        try {
            void var40_55;
            if (this.hashFileKey == null) {
                this.hashFileKey = this.languageDB.hashMap("invdocfreq").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.DOUBLE).open();
            }
            Double max_idf_value = 0.0;
            for (Object d : this.hashFileKey.values()) {
                if (!((Double)d > max_idf_value)) continue;
                max_idf_value = (Double)d;
            }
            ArrayList collections = new ArrayList();
            TreeMap initial_collection = new TreeMap();
            collections.add(initial_collection);
            File f = new File(filePath);
            double d = f.length() / 1024L;
            if (d <= 11.0) {
                this.threadsNumber = 1;
                if (configuration.verbose) {
                    this.logger.info("File too short, thread number forced to 1");
                }
            }
            BufferedReader in = null;
            if (fileContent != null && fileContent.length() > 0) {
                ByteArrayInputStream is = new ByteArrayInputStream(fileContent.toString().getBytes());
                in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            } else {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            }
            String line = "";
            Integer token_position = 0;
            Integer n = 0;
            Integer pos_position = 0;
            switch (column_configuration) {
                case TOKEN_LEMMA_POS: {
                    token_position = 0;
                    Integer n2 = 1;
                    pos_position = 2;
                    break;
                }
                case TOKEN_POS_LEMMA: {
                    token_position = 0;
                    Integer n3 = 2;
                    pos_position = 1;
                    break;
                }
                case CUSTOM: {
                    token_position = configuration.token_position;
                    Integer n4 = configuration.lemma_position;
                    pos_position = configuration.pos_position;
                }
            }
            if (configuration.verbose) {
                this.logger.info("Columns Selected: Token: " + token_position + ", lemma: " + var40_55 + ", pos:" + pos_position);
            }
            boolean topOfFile = true;
            while ((line = in.readLine()) != null) {
                if (line.length() > 0 && line.toLowerCase().compareTo("<eos>") != 0) {
                    if (topOfFile && line.startsWith("#")) continue;
                    topOfFile = false;
                    String[] lineItems = line.split("\t");
                    recomposedTextFile.append(lineItems[token_position] + " ");
                    try {
                        Resultset_Record rsr = new Resultset_Record(f.getName(), tot_sentences, "", lineItems[token_position].toLowerCase(), lineItems[var40_55.intValue()].toLowerCase(), lineItems[pos_position].toUpperCase(), record_id);
                        records.add(rsr);
                        ++record_id;
                    }
                    catch (Exception e) {
                        this.logger.error("Wrong format line: " + line + " missing separation.....");
                    }
                    continue;
                }
                ++tot_sentences;
            }
            in.close();
            if (recomposedTextFile.toString().trim().length() == 0) {
                return new LinkedList<KD_keyconcept>();
            }
            totalNumberOfToken = record_id;
            collections.clear();
            collections = null;
            if (configuration.verbose) {
                this.logger.info("Loaded! Now I prepare the threads...");
            }
            List parts = Lists.partition(records, (int)(records.size() / this.threadsNumber + 1));
            try {
                executor = Executors.newFixedThreadPool(parts.size());
            }
            catch (Exception e) {
                this.threadsNumber = 1;
                parts = Lists.partition(records, (int)(records.size() / this.threadsNumber + 1));
                executor = Executors.newFixedThreadPool(parts.size());
            }
            HashSet<KD_extractor> callables = new HashSet<KD_extractor>();
            for (int pts = 0; pts < parts.size(); ++pts) {
                callables.add(new KD_extractor("Worker" + (pts + 1), (List)parts.get(pts), lang, max_idf_value, configuration, this.languageDB));
            }
            futures = executor.invokeAll(callables);
            executor.shutdown();
            executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            executor.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<Object, Object> expressions_collected = new LinkedHashMap();
        try {
            for (int i = 0; i < futures.size(); ++i) {
                if (i == 0) {
                    expressions_collected = (Map)((Future)futures.get(i)).get();
                    continue;
                }
                Map ec = (Map)((Future)futures.get(i)).get();
                for (Map.Entry entry : ec.entrySet()) {
                    if (expressions_collected.containsKey(entry.getKey())) {
                        expressions_collected.put(entry.getKey(), ((KD_keyconcept)expressions_collected.get(entry.getKey())).mergeValue((KD_keyconcept)entry.getValue()));
                        continue;
                    }
                    expressions_collected.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        records.clear();
        records = new ArrayList();
        new KD_concept_sorter();
        expressions_collected = KD_concept_sorter.sort(expressions_collected, KD_concept_sorter.Sort.FREQ, KD_concept_sorter.SortDirection.DESC);
        ArrayList stems = new ArrayList();
        Iterator<Map.Entry<Object, Object>> it = expressions_collected.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            ((KD_keyconcept)entry.getValue()).calculateNormFreqByToken(totalNumberOfToken);
            if (((KD_keyconcept)entry.getValue()).frequency < local_frequency_threshold && !((KD_keyconcept)entry.getValue()).isAbstract) {
                it.remove();
            }
            if (((KD_keyconcept)entry.getValue()).frequency >= local_frequency_threshold || !((KD_keyconcept)entry.getValue()).isAbstract) continue;
            if (!configuration.no_abstract && ((KD_keyconcept)entry.getValue()).elements.size() > 1) {
                KD_keyconcept kD_keyconcept = (KD_keyconcept)entry.getValue();
                Double.valueOf(kD_keyconcept.scoreBoost - 0.0);
                kD_keyconcept.scoreBoost = kD_keyconcept.scoreBoost;
            }
            if (configuration.force_abstract) continue;
            it.remove();
        }
        if (this.hashFileStoplistDB == null) {
            this.hashFileStoplistDB = this.languageDB.hashMap("stoplist").keySerializer((Serializer)Serializer.JAVA).valueSerializer((Serializer)Serializer.DOUBLE).open();
        }
        it = expressions_collected.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            if (((KD_keyconcept)entry.getValue()).frequency > 0 && !this.hashFileStoplistDB.containsKey(entry.getKey())) continue;
            it.remove();
        }
        if (!configuration.skipFrequencyAbsorption) {
            if (expressions_collected.size() <= 0) {
                return new LinkedList<KD_keyconcept>();
            }
            LinkedList<Object> linkedList = new LinkedList<Object>(expressions_collected.keySet());
            List partsOfKeySet = Lists.partition(linkedList, (int)(linkedList.size() / this.threadsNumber + 1));
            executor = Executors.newFixedThreadPool(partsOfKeySet.size());
            ConcurrentHashMap<String, Map<String, KD_keyconcept>> all_related_expressions = new ConcurrentHashMap<String, Map<String, KD_keyconcept>>();
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
            for (int pts = 0; pts < partsOfKeySet.size(); ++pts) {
                tasks.add(Executors.callable(new RelatedExpressionExtractorThread((List)partsOfKeySet.get(pts), expressions_collected, all_related_expressions)));
            }
            try {
                executor.invokeAll(tasks);
                executor.shutdown();
                executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            AtomicInteger ttoken = new AtomicInteger(totalNumberOfToken);
            p = new ForkJoinPool(this.threadsNumber);
            p.invoke(new Recounter(expressions_collected, ttoken, all_related_expressions, 0));
            totalNumberOfToken = ttoken.get();
        }
        if (!no_syn) {
            if (this.hashFileSynonyms == null) {
                this.hashFileSynonyms = this.languageDB.hashMap("synonyms").keySerializer((Serializer)Serializer.JAVA).valueSerializer((Serializer)Serializer.DOUBLE).open();
            }
            for (Object objIterator : this.hashFileSynonyms.keySet()) {
                ArrayList synonyms_line = (ArrayList)objIterator;
                KD_keyconcept sinonimo = new KD_keyconcept();
                String keyToBeAdded = "";
                Object maxChainLenght = 0;
                for (String synonyms_exp : synonyms_line) {
                    if (expressions_collected.containsKey(synonyms_exp)) {
                        for (String synonyms_exp_max : synonyms_line) {
                            if ((Integer)maxChainLenght >= this.getStringFromKey(synonyms_exp_max).split(" ").length) continue;
                            maxChainLenght = this.getStringFromKey(synonyms_exp_max).split(" ").length;
                        }
                        if (sinonimo.elements.size() == 0) {
                            keyToBeAdded = synonyms_exp;
                            sinonimo.elements.addAll(((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).elements);
                            sinonimo.elementsLemma.addAll(((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).elementsLemma);
                            sinonimo.elementsToken.addAll(((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).elementsToken);
                            sinonimo.elementsStem.addAll(((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).elementsStem);
                            sinonimo.frequency = ((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).frequency;
                            sinonimo.position_in_text.addAll(((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).position_in_text);
                            sinonimo.idf = ((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).idf;
                            sinonimo.chainlenght = (Integer)maxChainLenght;
                            sinonimo.scoreBoost = ((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).scoreBoost;
                            sinonimo.synonyms.add(((KD_keyconcept)expressions_collected.get(synonyms_exp)).getString());
                        } else {
                            sinonimo.synonyms.add(((KD_keyconcept)expressions_collected.get(synonyms_exp)).getString());
                            sinonimo.frequency += ((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).frequency;
                            sinonimo.position_in_text.addAll(((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).position_in_text);
                            if (sinonimo.scoreBoost < ((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).scoreBoost) {
                                sinonimo.scoreBoost = ((KD_keyconcept)expressions_collected.get((Object)synonyms_exp)).scoreBoost;
                            }
                        }
                    }
                    expressions_collected.remove(synonyms_exp);
                }
                if (keyToBeAdded.length() <= 0) continue;
                expressions_collected.put(keyToBeAdded, sinonimo);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (configuration.boost_acronyms) {
            for (Map.Entry<Object, Object> entry : expressions_collected.entrySet()) {
                if (!((KD_keyconcept)entry.getValue()).isAcronym) continue;
                arrayList.add(((KD_keyconcept)entry.getValue()).getString());
            }
        }
        for (Map.Entry<Object, Object> entry : expressions_collected.entrySet()) {
            ((KD_keyconcept)entry.getValue()).score = (double)((KD_keyconcept)entry.getValue()).frequency / (double)totalNumberOfToken * 1000.0;
            if (rerank_by_token_lenght) {
                ((KD_keyconcept)entry.getValue()).score *= (double)((KD_keyconcept)entry.getValue()).chainlenght;
            }
            ((KD_keyconcept)entry.getValue()).score *= ((KD_keyconcept)entry.getValue()).scoreBoost.doubleValue();
            ((KD_keyconcept)entry.getValue()).score *= ((KD_keyconcept)entry.getValue()).idf.doubleValue();
            if (rerank_by_position) {
                Collections.sort(((KD_keyconcept)entry.getValue()).sentences_in_text);
                Collections.sort(((KD_keyconcept)entry.getValue()).position_in_text);
                double positionFactor = 1.0;
                if (((KD_keyconcept)entry.getValue()).position_in_text.get(0) < totalNumberOfToken / 2) {
                    double pow_arg = (double)(totalNumberOfToken - ((KD_keyconcept)entry.getValue()).position_in_text.get(0)) / (double)totalNumberOfToken;
                    positionFactor = 1.0 + Math.pow(pow_arg, 3.0);
                }
                ((KD_keyconcept)entry.getValue()).score *= positionFactor;
            }
            if (configuration.boost_acronyms) {
                if (((KD_keyconcept)entry.getValue()).isAcronym && ((KD_keyconcept)entry.getValue()).frequency > 4) {
                    ((KD_keyconcept)entry.getValue()).score *= 8.0;
                }
                if (((KD_keyconcept)entry.getValue()).chainlenght > 1) {
                    ArrayList common = new ArrayList(arrayList);
                    common.retainAll(((KD_keyconcept)entry.getValue()).elements);
                    if (common.size() > 0) {
                        ((KD_keyconcept)entry.getValue()).score *= 0.4;
                    }
                }
            }
            if (!configuration.use_pattern_weight) continue;
            ((KD_keyconcept)entry.getValue()).score *= ((KD_keyconcept)entry.getValue()).patternScoreBoost.doubleValue();
        }
        expressions_collected = KD_concept_sorter.sort(expressions_collected, KD_concept_sorter.Sort.SCORE, KD_concept_sorter.SortDirection.ASC);
        if (!no_rerank) {
            KD_rerank_methods reRanker;
            if (rerank_shorter_first_by_average) {
                reRanker = new KD_rerank_methods(expressions_collected, KD_rerank_methods.Method.SHORTER_FIRST_BY_AVERAGE, averaging_cycles, rerank_shorter_first_by_boosting);
                reRanker.rerank();
                expressions_collected = KD_concept_sorter.sort(reRanker.base, KD_concept_sorter.Sort.SCORE, KD_concept_sorter.SortDirection.DESC);
            }
            if (rerank_longer_first_by_absorbtion) {
                reRanker = new KD_rerank_methods(expressions_collected, KD_rerank_methods.Method.LONGER_FIRST_BY_ABSORBTION, absorbtion_cycles);
                reRanker.rerank();
                expressions_collected = reRanker.base;
            }
        }
        expressions_collected = KD_concept_sorter.sort(expressions_collected, KD_concept_sorter.Sort.SCORE, KD_concept_sorter.SortDirection.DESC);
        double maxScore = 1.0;
        double minScore = 0.0;
        if (expressions_collected.size() > 0) {
            maxScore = ((KD_keyconcept)expressions_collected.values().toArray()[0]).score;
            minScore = ((KD_keyconcept)expressions_collected.values().toArray()[expressions_collected.size() - 1]).score;
        }
        for (Map.Entry entry : expressions_collected.entrySet()) {
            Integer n;
            Integer n5;
            ((KD_keyconcept)entry.getValue()).normalized_score = (((KD_keyconcept)entry.getValue()).score - minScore) / (maxScore - minScore);
            ((KD_keyconcept)entry.getValue()).normalized_score = MathUtils.round((double)((KD_keyconcept)entry.getValue()).normalized_score, (int)5);
            ((KD_keyconcept)entry.getValue()).score = MathUtils.round((double)((KD_keyconcept)entry.getValue()).score, (int)3);
            if (only_multiword) {
                if (((KD_keyconcept)entry.getValue()).chainlenght <= 1 || ((KD_keyconcept)entry.getValue()).frequency <= 0) continue;
                outputList.add((KD_keyconcept)entry.getValue());
                if (numberOfConcepts < 0) continue;
                n5 = numberOfConcepts;
                n = numberOfConcepts = Integer.valueOf(numberOfConcepts - 1);
                if (numberOfConcepts != 0) continue;
                break;
            }
            if (((KD_keyconcept)entry.getValue()).frequency <= 0) continue;
            outputList.add((KD_keyconcept)entry.getValue());
            if (numberOfConcepts < 0) continue;
            n5 = numberOfConcepts;
            n = numberOfConcepts = Integer.valueOf(numberOfConcepts - 1);
            if (numberOfConcepts != 0) continue;
            break;
        }
        if (configuration.verbose) {
            this.logger.info(" -- Done!");
        }
        try {
            executor.shutdown();
            executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            executor.shutdownNow();
            p.shutdown();
            p.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            p.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputList;
    }

    private String getStringFromKey(String s) {
        String[] tokens;
        ArrayList<String> elements = new ArrayList<String>();
        for (String tkn : tokens = s.split("\u00f7\u2022\u00f7")) {
            if (tkn.trim().length() <= 0) continue;
            elements.add(tkn.trim());
        }
        return Joiner.on((String)" ").join(elements);
    }

    protected void finalize() throws Throwable {
        try {
            this.languageDB.close();
        }
        finally {
            super.finalize();
        }
    }

    public static enum Threads {
        ONE,
        TWO,
        FOUR,
        SIX,
        EIGHT,
        TEN,
        TWELVE;

    }

    public static enum Language {
        ITALIAN,
        ENGLISH,
        CUSTOM;

        private String custom_lang = "CUSTOM";

        public void set_Custom_Language(String name) {
            this.custom_lang = name;
        }

        public String toString() {
            if (this != CUSTOM) {
                return this.name();
            }
            return this.custom_lang;
        }
    }
}

