/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.utils.corpus;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eu.fbk.fcw.utils.corpus.Role;
import eu.fbk.fcw.utils.corpus.Sentence;
import eu.fbk.fcw.utils.corpus.Srl;
import eu.fbk.fcw.utils.corpus.Word;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Corpus
implements Iterable<Sentence>,
Serializable {
    private List<Sentence> sentences = new ArrayList<Sentence>();

    public List<Sentence> getSentences() {
        return this.sentences;
    }

    public Corpus(List<Sentence> sentences) {
        this.sentences = sentences;
    }

    public Corpus() {
    }

    public void addSentence(Sentence sentence) {
        this.sentences.add(sentence);
    }

    public static Corpus readDocumentFromFile(String fileName, String sourceName) {
        return Corpus.readDocumentFromFile(new File(fileName), sourceName);
    }

    public static Corpus readDocumentFromFile(File file, String sourceName) {
        Corpus corpus = new Corpus();
        try {
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            lines.add("");
            ArrayList<String[]> additionalList = new ArrayList<String[]>();
            Sentence sentence = new Sentence();
            for (String line : lines) {
                if ((line = line.trim()).trim().length() > 0) {
                    String[] parts = line.split("\\s+");
                    Word word = Word.readFromArray(parts);
                    sentence.addWord(word);
                    if (parts.length <= 13) continue;
                    additionalList.add(Arrays.copyOfRange(parts, 13, parts.length));
                    continue;
                }
                if (sentence.getWords().size() <= 0) continue;
                int srlCount = 0;
                for (int i = 0; i < additionalList.size(); ++i) {
                    String[] row = (String[])additionalList.get(i);
                    if (row[0].length() <= 1) continue;
                    Srl srl = new Srl(sentence.getWords().get(i), row[0], sourceName);
                    int roleIndex = ++srlCount;
                    for (int i1 = 0; i1 < additionalList.size(); ++i1) {
                        String[] row_role = (String[])additionalList.get(i1);
                        if (row_role[roleIndex].length() <= 1) continue;
                        Role role = new Role(sentence.getWords().get(i1), row_role[roleIndex]);
                        srl.addRole(role);
                    }
                    sentence.addSrl(srl);
                }
                corpus.addSentence(sentence);
                sentence = new Sentence();
                additionalList = new ArrayList();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return corpus;
    }

    public static void main(String[] args) {
        String fileName = args[0];
        Corpus.readDocumentFromFile(fileName, "mate");
    }

    @Override
    public Iterator<Sentence> iterator() {
        return this.sentences.iterator();
    }
}

