/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.fcw.utils;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class ResourcePool<T> {
    public static int MAX_RESOURCES = 10;
    private Semaphore sem;
    private final Queue<T> resources = new ConcurrentLinkedQueue<T>();

    protected abstract T createResource();

    public ResourcePool() {
        this(MAX_RESOURCES);
    }

    public ResourcePool(@Nullable Integer numResources) {
        if (numResources == null) {
            numResources = MAX_RESOURCES;
        }
        this.sem = new Semaphore(numResources, true);
    }

    public T getResource(long maxWaitMillis) throws Exception {
        this.sem.tryAcquire(maxWaitMillis, TimeUnit.MILLISECONDS);
        T res = this.resources.poll();
        if (res != null) {
            return res;
        }
        try {
            return this.createResource();
        }
        catch (Exception e) {
            this.sem.release();
            throw new Exception(e);
        }
    }

    public void returnResource(T res) {
        this.resources.add(res);
        this.sem.release();
    }
}

