/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import eu.fbk.dh.tint.digimorph.DigiMorph_Analizer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.mapdb.Serializer;
import org.mapdb.SortedTableMap;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.volume.MappedFileVol;
import org.mapdb.volume.Volume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigiMorph {
    String model_path = "";
    ExecutorService executor = null;
    List<Future<List<String>>> futures = null;
    Set<Callable<List<String>>> callables = new HashSet<Callable<List<String>>>();
    Volume volume = null;
    SortedTableMap<String, String> map = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(DigiMorph.class);

    public static String getVersion() {
        return DigiMorph.class.getPackage().getImplementationTitle() + "\n" + DigiMorph.class.getPackage().getSpecificationVendor() + " - " + DigiMorph.class.getPackage().getImplementationVendor() + "\nVersion: " + DigiMorph.class.getPackage().getSpecificationVersion();
    }

    public DigiMorph() {
        this(null);
    }

    public DigiMorph(String model_path) {
        if (model_path == null) {
            try {
                File file = File.createTempFile("mapdb", "mapdb");
                file.deleteOnExit();
                byte[] bytes = Resources.toByteArray((URL)Resources.getResource((String)"italian.db"));
                Files.write(file.toPath(), bytes, new OpenOption[0]);
                model_path = file.getAbsolutePath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.model_path = model_path;
        this.volume = MappedFileVol.FACTORY.makeVolume(model_path, true);
        this.map = SortedTableMap.open((Volume)this.volume, (GroupSerializer)Serializer.STRING, (GroupSerializer)Serializer.STRING);
    }

    public SortedTableMap<String, String> getMap() {
        return this.map;
    }

    public synchronized List<String> getMorphology(String token) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(token);
        return this.getMorphology(list);
    }

    public synchronized List<String> getMorphology(List<String> token_list) {
        LinkedList<String> results = new LinkedList<String>();
        int threadsNumber = Runtime.getRuntime().availableProcessors();
        List parts = Lists.partition(token_list, (int)(token_list.size() / threadsNumber + 1));
        if (token_list.size() <= 0) {
            LOGGER.warn("No tokens to the morphological analyzer");
            return results;
        }
        this.executor = Executors.newFixedThreadPool(parts.size());
        this.callables = new LinkedHashSet<Callable<List<String>>>();
        for (int pts = 0; pts < parts.size(); ++pts) {
            this.callables.add(new DigiMorph_Analizer((List)parts.get(pts), this.map));
        }
        try {
            this.futures = this.executor.invokeAll(this.callables);
            this.executor.shutdown();
            this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (Future<List<String>> future : this.futures) {
                List<String> stringList = future.get();
                results.addAll(stringList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static void re_train(File csv_path, File output, boolean include_lemma) {
        if (output.exists()) {
            output.delete();
        }
        Volume volume = MappedFileVol.FACTORY.makeVolume(output.getAbsolutePath(), false);
        SortedTableMap.Sink sink = SortedTableMap.create((Volume)volume, (GroupSerializer)Serializer.STRING, (GroupSerializer)Serializer.STRING).pageSize(65536L).nodeSize(8).createFromSink();
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            Reader in;
            if (csv_path == null) {
                URL resource = Resources.getResource((String)"morph-it_dh_extended.txt");
                CharSource charSource = Resources.asCharSource((URL)resource, (Charset)Charsets.UTF_8);
                in = charSource.openStream();
            } else {
                in = new FileReader(csv_path);
            }
            CSVParser records = CSVFormat.TDF.withIgnoreEmptyLines().withQuote('\u2265').parse(in);
            for (CSVRecord cSVRecord : records) {
                String feature = cSVRecord.get(2);
                String lemma = cSVRecord.get(1);
                String forma = cSVRecord.get(0).toLowerCase();
                if (!map.containsKey(forma)) {
                    map.put(forma, "");
                }
                if (lemma == null) {
                    lemma = "";
                }
                if (include_lemma) {
                    map.put(forma, (String)map.get(forma) + " " + lemma + "+" + feature);
                    continue;
                }
                map.put(forma, (String)map.get(forma) + " " + feature);
            }
            for (Map.Entry entry : map.entrySet()) {
                if (!((String)entry.getValue()).contains("+imp+")) continue;
                String newMorph = "";
                String[] morphItems = ((String)entry.getValue()).split(" ");
                String imp = "";
                for (String m : morphItems) {
                    if (m.contains("+imp+")) {
                        imp = m;
                        continue;
                    }
                    newMorph = newMorph + m + " ";
                }
                newMorph = newMorph + imp;
                entry.setValue(newMorph);
            }
            for (Map.Entry entry : map.entrySet()) {
                sink.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SortedTableMap stmap = (SortedTableMap)sink.create();
        System.out.println("done");
    }
}

