/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.derived;

import eu.fbk.dh.tint.derived.Derivation;
import eu.fbk.dh.tint.derived.DerivedAffixation;
import eu.fbk.dh.tint.derived.DerivedConversion;
import eu.fbk.dh.tint.derived.DerivedPhase;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivedModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerivedModel.class);
    private static DerivedModel ourInstance = null;
    private Map<String, Derivation> derivations;

    public static DerivedModel getInstance() {
        if (ourInstance == null) {
            ourInstance = new DerivedModel();
        }
        return ourInstance;
    }

    private DerivedModel() {
        LOGGER.info("Loading derivatario");
        InputStream derivatarioStream = this.getClass().getResourceAsStream("/derivatario.csv");
        InputStreamReader in = new InputStreamReader(derivatarioStream);
        CSVParser records = null;
        this.derivations = new HashMap<String, Derivation>();
        try {
            records = CSVFormat.DEFAULT.parse((Reader)in);
        }
        catch (IOException e) {
            return;
        }
        for (CSVRecord record : records) {
            String value;
            String lemma = record.get(1).trim().toLowerCase();
            String[] baseParts = record.get(2).trim().split(":");
            String baseLemma = null;
            String baseType = null;
            if (!baseParts[0].toLowerCase().equals("baseless")) {
                baseLemma = baseParts[0].toLowerCase();
                baseType = baseParts[1].toLowerCase();
            }
            Derivation derivation = new Derivation(baseLemma, baseType);
            for (int i = 3; i < record.size() && (value = record.get(i).trim()).length() != 0; ++i) {
                DerivedPhase phase;
                String[] parts = value.split(":");
                if (parts[0].toLowerCase().equals("conversion")) {
                    phase = new DerivedConversion(parts[1].toLowerCase());
                } else {
                    try {
                        phase = new DerivedAffixation(parts[0].toLowerCase(), parts[1].toLowerCase(), parts[2].toLowerCase(), parts[3].toLowerCase());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in {}", (Object)value);
                        continue;
                    }
                }
                derivation.addPhase(phase);
            }
            this.derivations.put(lemma, derivation);
        }
    }

    public Map<String, Derivation> getDerivations() {
        return this.derivations;
    }

    public static void main(String[] args) {
        DerivedModel instance = DerivedModel.getInstance();
    }
}

