/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.derived;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import eu.fbk.dh.tint.derived.DerivationAnnotations;
import eu.fbk.dh.tint.derived.DerivedModel;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivationAnnotator
implements Annotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerivationAnnotator.class);
    private DerivedModel model = DerivedModel.getInstance();

    public DerivationAnnotator(String annotatorName, Properties props) {
    }

    public void annotate(Annotation annotation) {
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            String lemma = token.lemma();
            if (!this.model.getDerivations().containsKey(lemma.toLowerCase())) continue;
            token.set(DerivationAnnotations.DerivationAnnotation.class, (Object)this.model.getDerivations().get(lemma.toLowerCase()));
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(DerivationAnnotations.DerivationAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.singleton(CoreAnnotations.LemmaAnnotation.class);
    }
}

