/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph.annotator;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.RadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import eu.fbk.dh.tint.digimorph.DigiMorph;
import eu.fbk.utils.core.FrequencyHashSet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.mapdb.SortedTableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuessModel {
    private static Set<String> absAdvs = new HashSet<String>();
    private static final Logger LOGGER;
    private HashSet<String> allowedTags = new HashSet();
    private Map<String, RadixTree<LinkedList<String>>> trees = new HashMap<String, RadixTree<LinkedList<String>>>();
    private Map<String, String> featMappings = new HashMap<String, String>();

    public String getMorphoFeatsForContentWords(String featString) {
        String subToken = featString.replaceAll("^[^~]*~", "");
        subToken = subToken.replaceAll("^[^+]*\\+", "");
        return this.featMappings.get(subToken);
    }

    public void addSexMorpho(Set<String> set, String sex) {
        if (sex.equals("m")) {
            set.add("Gender=Masc");
        } else if (sex.equals("f")) {
            set.add("Gender=Fem");
        }
    }

    public void addNumMorpho(Set<String> set, String num) {
        if (num.equals("sing")) {
            set.add("Number=Sing");
        } else if (num.equals("plur")) {
            set.add("Number=Plur");
        }
    }

    public void addPersMorpho(Set<String> set, String pers) {
        if (pers.equals("1") || pers.equals("2") || pers.equals("3")) {
            set.add("Person=" + pers);
        }
    }

    public void addTypeMorpho(Set<String> set, String type) {
        if (type.equals("sup")) {
            set.add("Degree=Abs");
        }
        if (type.equals("cmp")) {
            set.add("Degree=Cmp");
        }
    }

    public String getMorphoFeats(String featString, String pos) {
        TreeSet<String> featureSet = new TreeSet<String>();
        String[] parts = featString.split("\\+");
        if (parts.length > 1) {
            switch (parts[1]) {
                case "adj": {
                    this.addSexMorpho(featureSet, parts[2]);
                    this.addNumMorpho(featureSet, parts[3]);
                    if (parts.length <= 4) break;
                    this.addTypeMorpho(featureSet, parts[4]);
                    break;
                }
                case "art": {
                    this.addSexMorpho(featureSet, parts[2]);
                    this.addNumMorpho(featureSet, parts[3]);
                    break;
                }
                case "adv": {
                    if (parts[0].endsWith("issimo")) {
                        featureSet.add("Degree=Abs");
                    }
                    if (!absAdvs.contains(parts[0].toLowerCase())) break;
                    featureSet.add("Degree=Abs");
                    break;
                }
                case "pron": {
                    this.addSexMorpho(featureSet, parts[3]);
                    this.addPersMorpho(featureSet, parts[4]);
                    this.addNumMorpho(featureSet, parts[5]);
                }
            }
        }
        switch (pos) {
            case "A": 
            case "V": 
            case "VA": 
            case "VM": 
            case "S": {
                return this.getMorphoFeatsForContentWords(featString);
            }
            case "AP": {
                featureSet.add("Poss=Yes");
                featureSet.add("PronType=Prs");
                break;
            }
            case "BN": {
                featureSet.add("PronType=Neg");
                break;
            }
            case "DD": {
                featureSet.add("PronType=Dem");
                break;
            }
            case "DE": {
                featureSet.add("PronType=Exc");
                break;
            }
            case "DI": {
                featureSet.add("PronType=Ind");
                break;
            }
            case "DQ": {
                featureSet.add("PronType=Int");
                break;
            }
            case "DR": {
                featureSet.add("PronType=Rel");
                break;
            }
            case "I": {
                switch (parts[0].toLowerCase()) {
                    case "si": 
                    case "s\u00ec": 
                    case "si'": {
                        featureSet.add("Polarity=Pos");
                        break;
                    }
                    case "no": {
                        featureSet.add("Polarity=Neg");
                    }
                }
                break;
            }
            case "N": {
                featureSet.add("NumType=Card");
                break;
            }
            case "NO": {
                featureSet.add("NumType=Ord");
                break;
            }
            case "PC": {
                featureSet.add("Clitic=Yes");
                featureSet.add("PronType=Prs");
                break;
            }
            case "PD": {
                featureSet.add("PronType=Dem");
                break;
            }
            case "PE": 
            case "PP": {
                featureSet.add("PronType=Prs");
                break;
            }
            case "PI": {
                featureSet.add("PronType=Ind");
                break;
            }
            case "PQ": {
                featureSet.add("PronType=Int");
                break;
            }
            case "PR": {
                featureSet.add("PronType=Rel");
                break;
            }
            case "RD": {
                featureSet.add("Definite=Def");
                featureSet.add("PronType=Art");
                break;
            }
            case "RI": {
                featureSet.add("Definite=Ind");
                featureSet.add("PronType=Art");
                break;
            }
            case "SW": {
                featureSet.add("Foreign=Yes");
                break;
            }
            case "T": {
                featureSet.add("PronType=Tot");
            }
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (String s : featureSet) {
            buffer.append(s);
            if (++i >= featureSet.size()) continue;
            buffer.append("|");
        }
        if (buffer.length() == 0) {
            buffer.append("_");
        }
        return buffer.toString();
    }

    public GuessModel() {
        this(null);
    }

    public GuessModel(String guessModelPath) {
        HashMap<String, String> uMap = new HashMap<String, String>();
        uMap.put("v", "VERB");
        uMap.put("adv", "ADV");
        uMap.put("adj", "ADJ");
        uMap.put("n", "NOUN");
        this.allowedTags.add("VERB");
        this.allowedTags.add("NOUN");
        this.allowedTags.add("ADJ");
        this.allowedTags.add("ADV");
        try {
            List lines;
            if (guessModelPath == null) {
                URL adjResource = Resources.getResource((String)"feat-mappings.txt");
                lines = Resources.readLines((URL)adjResource, (Charset)Charsets.UTF_8);
            } else {
                lines = Files.readLines((File)new File(guessModelPath), (Charset)Charsets.UTF_8);
            }
            for (String line : lines) {
                String[] parts;
                if ((line = line.trim()).length() == 0 || (parts = line.split("\\s+")).length != 2) continue;
                this.featMappings.put(parts[0], parts[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String allowedTag : this.allowedTags) {
            this.trees.put(allowedTag, (RadixTree<LinkedList<String>>)new ConcurrentRadixTree((NodeFactory)new DefaultCharArrayNodeFactory()));
        }
        DigiMorph digiMorph = new DigiMorph();
        SortedTableMap map = digiMorph.getMap();
        Iterator gmIterator = map.keyIterator();
        while (gmIterator.hasNext()) {
            String[] words;
            String key = (String)gmIterator.next();
            String value = ((String)map.get((Object)key)).trim();
            for (String word : words = value.split("[\\s/]+")) {
                String feats;
                String ePos;
                String[] parts = word.split("\\+");
                if (parts.length < 2 || (ePos = parts[1]).length() == 0 || !uMap.keySet().contains(ePos) || (feats = this.getMorphoFeatsForContentWords(word)) == null) continue;
                String token = key.toLowerCase();
                String lemma = parts[0].toLowerCase();
                String reverse_token = new StringBuilder(token).reverse().toString();
                LinkedList<String> features = new LinkedList<String>();
                features.add(token);
                features.add(lemma);
                features.add(feats);
                this.trees.get(uMap.get(ePos)).put((CharSequence)reverse_token, features);
            }
        }
    }

    public Token guess(String token, String pos) {
        String reverse_sample_query = new StringBuilder(token).reverse().toString();
        FrequencyHashSet values = new FrequencyHashSet();
        Iterable closestForms = this.trees.get(pos).getValuesForClosestKeys((CharSequence)reverse_sample_query);
        for (LinkedList s : closestForms) {
            values.add(s.get(2));
        }
        String guess = (String)values.mostFrequent();
        String guessed_lemma = token;
        block1: for (LinkedList closestForm : closestForms) {
            String feat = (String)closestForm.get(2);
            if (!feat.equals(guess)) continue;
            String lemma = ((String)closestForm.get(1)).toLowerCase();
            String form = ((String)closestForm.get(0)).toLowerCase();
            int min = Math.min(form.length(), lemma.length());
            for (int i = 0; i < min; ++i) {
                char charLemma;
                char charForm = form.charAt(i);
                if (charForm == (charLemma = lemma.charAt(i)) && i != min - 1) continue;
                String postfix = lemma.substring(i);
                int length = token.length() - form.length();
                if (length < 0) break block1;
                String prefix = token.substring(0, i + length);
                guessed_lemma = prefix + postfix;
                break block1;
            }
        }
        return new Token(token, guessed_lemma, guess);
    }

    public static void main(String[] args) {
        GuessModel model = new GuessModel();
        System.out.println(model.guess("sparacchio", "VERB"));
    }

    static {
        absAdvs.add("ottimamente");
        absAdvs.add("pessimamente");
        absAdvs.add("massimamente");
        LOGGER = LoggerFactory.getLogger(GuessModel.class);
    }

    class Token {
        String form;
        String lemma;
        String feats;

        public String toString() {
            return "Token{form='" + this.form + '\'' + ", lemma='" + this.lemma + '\'' + ", feats='" + this.feats + '\'' + '}';
        }

        public Token(String form, String lemma, String feats) {
            this.form = form;
            this.lemma = lemma;
            this.feats = feats;
        }
    }
}

