/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph.annotator;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.digimorph.DigiMorph;
import eu.fbk.dh.tint.digimorph.annotator.DigiMorphAnnotations;
import eu.fbk.dh.tint.digimorph.annotator.DigiMorphModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DigiMorphAnnotator
implements Annotator {
    DigiMorph dm;

    public DigiMorphAnnotator(String annotatorName, Properties prop) {
        String model_path = prop.getProperty(annotatorName + ".model");
        this.dm = DigiMorphModel.getInstance(model_path);
    }

    public void annotate(Annotation annotation) {
        List<String> token_word = new LinkedList();
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            List tokens;
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel c : tokens) {
                    token_word.add(c.word());
                }
            }
            token_word = this.dm.getMorphology(token_word);
            try {
                if (token_word.size() > 0) {
                    for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                        tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                        for (CoreLabel c : tokens) {
                            c.set(DigiMorphAnnotations.MorphoAnnotation.class, token_word.get(0));
                            token_word.remove(0);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println(token_word);
                e.printStackTrace();
            }
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(DigiMorphAnnotations.MorphoAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }
}

