/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.digimorph.annotator;

import com.google.common.collect.TreeMultimap;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import eu.fbk.dh.tint.digimorph.annotator.DigiMorphAnnotations;
import eu.fbk.dh.tint.digimorph.annotator.GuessModel;
import eu.fbk.dh.tint.digimorph.annotator.GuessModelInstance;
import eu.fbk.fcw.utils.ConllToken;
import eu.fbk.utils.core.PropertiesUtils;
import eu.fbk.utils.corenlp.CustomAnnotations;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DigiLemmaAnnotator
implements Annotator {
    private static Map<String, String> pos_morpho_mapping = new HashMap<String, String>();
    private static Map<String, String> guessMap = new HashMap<String, String>();
    private static boolean DEFAULT_USE_GUESSER = true;
    private static boolean DEFAULT_FEATURES = true;
    private boolean useGuesser;
    private boolean extractFeatures;
    private GuessModel guesser;
    private String guessModel;
    private static final String auxiliary = "VA";
    private static final String verb = "V";
    private static final String pNoun = "SP";
    private static final Set<String> betweenAuxAndVerb = new HashSet<String>(Arrays.asList("B", "BN"));

    public DigiLemmaAnnotator(String annotatorName, Properties prop) {
        this.useGuesser = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".use_guesser"), (boolean)DEFAULT_USE_GUESSER);
        this.extractFeatures = PropertiesUtils.getBoolean((String)prop.getProperty(annotatorName + ".extract_features"), (boolean)DEFAULT_FEATURES);
        this.guessModel = prop.getProperty(annotatorName + ".guess_model");
        if (this.useGuesser || this.extractFeatures) {
            this.guesser = GuessModelInstance.getInstance(this.guessModel).getModel();
        }
    }

    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                String last_valuable_genre = "";
                Boolean valid_aux = false;
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (CoreLabel token : tokens) {
                    String[] morph_fatures = ((String)token.get(DigiMorphAnnotations.MorphoAnnotation.class)).split("\\s+");
                    String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    boolean isGuessable = guessMap.containsKey(pos);
                    boolean chosenGuess = true;
                    String chosenLemma = morph_fatures.length > 0 ? morph_fatures[0] : token.originalText();
                    String chosenMorpho = "";
                    String chosenFeaturesString = "";
                    TreeMultimap chosenFeatures = TreeMultimap.create();
                    if (!pos.equals(verb)) {
                        valid_aux = pos.equals(auxiliary) || valid_aux != false && betweenAuxAndVerb.contains(pos) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (!pos.equals(pNoun) && morph_fatures.length > 1) {
                        if (morph_fatures.length == 2) {
                            String featMapped;
                            boolean shouldBeGuessed;
                            String finalMorpho = morph_fatures[1];
                            if (finalMorpho.contains("+art") || finalMorpho.equals("+adj")) {
                                last_valuable_genre = finalMorpho.contains("+m+") ? "m" : "f";
                            }
                            boolean bl = shouldBeGuessed = (featMapped = pos_morpho_mapping.get(pos)) == null || !finalMorpho.contains(featMapped);
                            if (isGuessable && this.useGuesser && shouldBeGuessed) {
                                GuessModel.Token guess = this.guesser.guess(token.word(), guessMap.get(pos));
                                chosenLemma = guess.lemma;
                            } else {
                                chosenLemma = finalMorpho.split("\\+")[0].split("~")[0];
                                chosenMorpho = finalMorpho;
                                if (!shouldBeGuessed) {
                                    chosenGuess = false;
                                }
                            }
                        } else {
                            String featMapped = pos_morpho_mapping.get(pos);
                            String possibleCandidate = "";
                            String firstCandidate = "";
                            if (featMapped != null) {
                                for (String feature : morph_fatures) {
                                    if (!feature.contains(featMapped)) continue;
                                    if (firstCandidate.length() == 0) {
                                        firstCandidate = feature;
                                    }
                                    if (featMapped.equals("+art") || featMapped.equals("+adj")) {
                                        if (feature.contains("+m+")) {
                                            last_valuable_genre = "m";
                                        } else if (feature.contains("+f+")) {
                                            last_valuable_genre = "f";
                                        }
                                    }
                                    if (last_valuable_genre.equals("m") && feature.contains("+m+")) {
                                        possibleCandidate = feature;
                                    } else if (last_valuable_genre.equals("f") && feature.contains("+f+")) {
                                        possibleCandidate = feature;
                                    }
                                    if (!valid_aux.booleanValue() || !feature.contains("+part+")) continue;
                                    possibleCandidate = feature;
                                    valid_aux = false;
                                }
                                chosenGuess = false;
                                if (possibleCandidate.length() > 0) {
                                    chosenMorpho = possibleCandidate;
                                    chosenLemma = possibleCandidate.split("\\+")[0].split("~")[0];
                                } else if (firstCandidate.length() > 0) {
                                    chosenMorpho = firstCandidate;
                                    chosenLemma = firstCandidate.split("\\+")[0].split("~")[0];
                                } else {
                                    chosenGuess = true;
                                    chosenLemma = token.word();
                                    chosenMorpho = "";
                                }
                            }
                        }
                    }
                    if (isGuessable && chosenGuess && this.useGuesser) {
                        GuessModel.Token guess = this.guesser.guess(token.word(), guessMap.get(pos));
                        chosenFeaturesString = guess.feats;
                        chosenFeatures = ConllToken.featureStringToAnnotation((String)guess.feats);
                        chosenLemma = guess.lemma;
                    }
                    if (!chosenGuess) {
                        String useMorpho = chosenMorpho;
                        String usePos = pos;
                        if (pos.startsWith("V+")) {
                            usePos = verb;
                            try {
                                useMorpho = chosenMorpho.split("/")[0];
                                useMorpho = useMorpho.split("~")[1];
                            }
                            catch (Exception firstCandidate) {
                                // empty catch block
                            }
                        }
                        if ((chosenFeaturesString = this.guesser.getMorphoFeats(useMorpho, usePos)) != null) {
                            chosenFeatures = ConllToken.featureStringToAnnotation((String)chosenFeaturesString);
                        }
                    }
                    if (chosenLemma.equals("[PUNCT]")) {
                        chosenLemma = token.originalText();
                    }
                    token.set(CoreAnnotations.LemmaAnnotation.class, (Object)chosenLemma);
                    token.set(DigiMorphAnnotations.SelectedMorphoAnnotation.class, (Object)chosenMorpho);
                    token.set(DigiMorphAnnotations.GuessedLemmaAnnotation.class, (Object)chosenGuess);
                    if (!this.extractFeatures) continue;
                    token.set(CoreAnnotations.FeaturesAnnotation.class, (Object)chosenFeaturesString);
                    token.set(CustomAnnotations.FeaturesAnnotation.class, (Object)chosenFeatures.asMap());
                    HashMap<String, String> conlluFeats = new HashMap<String, String>();
                    for (String key : chosenFeatures.keySet()) {
                        conlluFeats.put(key, String.join((CharSequence)",", chosenFeatures.get((Object)key)));
                    }
                    token.set(CoreAnnotations.CoNLLUFeats.class, conlluFeats);
                }
            }
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.LemmaAnnotation.class);
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, DigiMorphAnnotations.MorphoAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    static {
        pos_morpho_mapping.put("A", "+adj");
        pos_morpho_mapping.put("AP", "+adj");
        pos_morpho_mapping.put("B", "+adv");
        pos_morpho_mapping.put("BN", "+adv");
        pos_morpho_mapping.put("C", "+conj");
        pos_morpho_mapping.put("CC", "+conj");
        pos_morpho_mapping.put("CS", "+conj");
        pos_morpho_mapping.put("DD", "+adj");
        pos_morpho_mapping.put("DE", "+adj");
        pos_morpho_mapping.put("DI", "+adj");
        pos_morpho_mapping.put("DQ", "+adj");
        pos_morpho_mapping.put("DR", "+adj");
        pos_morpho_mapping.put("DT", "+adj");
        pos_morpho_mapping.put("E", "+prep");
        pos_morpho_mapping.put("E+RD", "+prep");
        pos_morpho_mapping.put("I", "+inter");
        pos_morpho_mapping.put("N", "+adj");
        pos_morpho_mapping.put("NO", "+adj");
        pos_morpho_mapping.put("PC", "+pron");
        pos_morpho_mapping.put("PD", "+pron");
        pos_morpho_mapping.put("PE", "+pron");
        pos_morpho_mapping.put("PI", "+pron");
        pos_morpho_mapping.put("PP", "+pron");
        pos_morpho_mapping.put("PQ", "+pron");
        pos_morpho_mapping.put("PR", "+pron");
        pos_morpho_mapping.put("RD", "+art");
        pos_morpho_mapping.put("RI", "+art");
        pos_morpho_mapping.put("S", "+n+");
        pos_morpho_mapping.put(pNoun, "+n+");
        pos_morpho_mapping.put("T", "+adj");
        pos_morpho_mapping.put(verb, "+v+");
        pos_morpho_mapping.put(auxiliary, "+v+");
        pos_morpho_mapping.put(auxiliary, "+v+");
        pos_morpho_mapping.put("VM", "+v+");
        pos_morpho_mapping.put("VM", "+v+");
        pos_morpho_mapping.put("V+PC", "+v+");
        guessMap.put("A", "ADJ");
        guessMap.put("S", "NOUN");
        guessMap.put(verb, "VERB");
        guessMap.put("B", "ADV");
    }
}

