/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xinclude;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Locale;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.MalformedURIException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import nu.xom.Text;
import nu.xom.xinclude.BadEncodingAttributeException;
import nu.xom.xinclude.BadHTTPHeaderException;
import nu.xom.xinclude.BadHrefAttributeException;
import nu.xom.xinclude.BadParseAttributeException;
import nu.xom.xinclude.EncodingHeuristics;
import nu.xom.xinclude.InclusionLoopException;
import nu.xom.xinclude.MisplacedFallbackException;
import nu.xom.xinclude.NoIncludeLocationException;
import nu.xom.xinclude.XIncludeException;
import nu.xom.xinclude.XPointer;
import nu.xom.xinclude.XPointerResourceException;
import nu.xom.xinclude.XPointerSyntaxException;

public class XIncluder {
    private static String version = System.getProperty("java.version");
    public static final String XINCLUDE_NS = "http://www.w3.org/2001/XInclude";

    private XIncluder() {
    }

    public static Document resolve(Document document) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Builder builder = new Builder();
        return XIncluder.resolve(document, builder);
    }

    public static Document resolve(Document document, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        Document document2 = new Document(document);
        XIncluder.resolveInPlace(document2, builder);
        return document2;
    }

    public static void resolveInPlace(Document document) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        XIncluder.resolveInPlace(document, new Builder());
    }

    public static void resolveInPlace(Document document, Builder builder) throws BadParseAttributeException, InclusionLoopException, IOException, NoIncludeLocationException, ParsingException, UnsupportedEncodingException, XIncludeException {
        ArrayList<String> arrayList = new ArrayList<String>();
        XIncluder.resolveInPlace(document, builder, arrayList);
    }

    private static void resolveInPlace(Document document, Builder builder, ArrayList<String> arrayList) throws IOException, ParsingException, XIncludeException {
        String string = document.getBaseURI();
        if (string != null && string.startsWith("file:///")) {
            string = "file:/" + string.substring(8);
        }
        arrayList.add(string);
        Element element = document.getRootElement();
        XIncluder.resolve(element, builder, arrayList);
        arrayList.remove(arrayList.size() - 1);
    }

    private static void resolve(Element element, Builder builder, ArrayList<String> arrayList) throws IOException, ParsingException, XIncludeException {
        XIncluder.resolve(element, builder, arrayList, null);
    }

    private static void resolve(Element element, Builder builder, ArrayList<String> arrayList, Document document) throws IOException, ParsingException, XIncludeException {
        block37: {
            if (XIncluder.isIncludeElement(element)) {
                XIncluder.verifyIncludeElement(element);
                String string = element.getAttributeValue("parse");
                if (string == null) {
                    string = "xml";
                }
                String string2 = element.getAttributeValue("xpointer");
                String string3 = element.getAttributeValue("encoding");
                String string4 = element.getAttributeValue("href");
                if ("".equals(string4)) {
                    string4 = null;
                }
                ParentNode parentNode = element.getParent();
                String string5 = element.getBaseURI();
                URL uRL = null;
                try {
                    uRL = new URL(string5);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                URL uRL2 = null;
                try {
                    if (uRL != null && string4 != null) {
                        uRL2 = XIncluder.absolutize(uRL, string4);
                    } else if (string4 != null) {
                        try {
                            XIncluder.testURISyntax(string4);
                            uRL2 = new URL(string4);
                        }
                        catch (MalformedURIException malformedURIException) {
                            if (uRL == null) {
                                throw new BadHrefAttributeException("Could not resolve relative URI " + string4 + " because the xi:include element does not have a base URI.", string4);
                            }
                            throw new BadHrefAttributeException("Illegal IRI in href attribute", string4);
                        }
                    }
                    String string6 = element.getAttributeValue("accept");
                    XIncluder.checkHeader(string6);
                    String string7 = element.getAttributeValue("accept-language");
                    XIncluder.checkHeader(string7);
                    if (string.equals("xml")) {
                        Object object;
                        Node node;
                        Object object2;
                        int n;
                        Nodes nodes;
                        String string8 = "";
                        if (parentNode instanceof Element) {
                            string8 = XIncluder.getXMLLangValue((Element)parentNode);
                        }
                        if (uRL2 != null) {
                            nodes = XIncluder.downloadXMLDocument(uRL2, string2, builder, arrayList, string6, string7, string8);
                            for (n = 0; n < nodes.size(); ++n) {
                                object2 = nodes.get(n);
                                if (!(object2 instanceof Element)) continue;
                                String string9 = ((Node)object2).getBaseURI();
                                if (string9.indexOf(35) >= 0) {
                                    string9 = string9.substring(0, string9.indexOf(35));
                                }
                                node = (Element)object2;
                                object = parentNode.getBaseURI();
                                if (object != null && !"".equals(object)) {
                                    object = XIncluder.getDirectoryBase((String)object);
                                }
                                if (string9.startsWith((String)object)) {
                                    string9 = string9.substring(((String)object).length());
                                }
                                Attribute attribute = new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string9);
                                ((Element)node).addAttribute(attribute);
                            }
                        } else {
                            Document document2 = element.getDocument();
                            if (document2 == null) {
                                document2 = document;
                            }
                            object2 = XPointer.query(document2, string2);
                            nodes = new Nodes();
                            for (int i = 0; i < ((Nodes)object2).size(); ++i) {
                                node = ((Nodes)object2).get(i);
                                if (XIncluder.contains((Element)node, element)) {
                                    throw new InclusionLoopException("Element tried to include itself");
                                }
                                object = node.copy();
                                nodes.append((Node)object);
                            }
                            nodes = XIncluder.resolveXPointerSelection(nodes, builder, arrayList, document2);
                        }
                        if (parentNode instanceof Element) {
                            n = parentNode.indexOf(element);
                            for (int i = 0; i < nodes.size(); ++i) {
                                Node node2 = nodes.get(i);
                                parentNode.insertChild(node2, n + i);
                            }
                            element.detach();
                        } else {
                            Node node3;
                            Document document3 = (Document)parentNode;
                            int n2 = 0;
                            while (true) {
                                node3 = nodes.get(n2);
                                ++n2;
                                if (node3 instanceof Element) break;
                                document3.insertChild(node3, document3.indexOf(element));
                            }
                            document3.setRootElement((Element)node3);
                            node3 = document3.getRootElement();
                            int n3 = document3.indexOf(node3);
                            for (int i = n2; i < nodes.size(); ++i) {
                                document3.insertChild(nodes.get(i), n3 + 1 + i - n2);
                            }
                        }
                        break block37;
                    }
                    if (string.equals("text")) {
                        Nodes nodes = XIncluder.downloadTextDocument(uRL2, string3, builder, string6, string7);
                        for (int i = 0; i < nodes.size(); ++i) {
                            Node node = nodes.get(i);
                            if (node instanceof Attribute) {
                                ((Element)parentNode).addAttribute((Attribute)node);
                                continue;
                            }
                            parentNode.insertChild(node, parentNode.indexOf(element));
                        }
                        parentNode.removeChild(element);
                        break block37;
                    }
                    throw new BadParseAttributeException("Bad value for parse attribute: " + string, element.getDocument().getBaseURI());
                }
                catch (IOException iOException) {
                    XIncluder.processFallback(element, builder, arrayList, parentNode, iOException);
                }
                catch (XPointerSyntaxException xPointerSyntaxException) {
                    XIncluder.processFallback(element, builder, arrayList, parentNode, xPointerSyntaxException);
                }
                catch (XPointerResourceException xPointerResourceException) {
                    XIncluder.processFallback(element, builder, arrayList, parentNode, xPointerResourceException);
                }
            } else {
                if (XIncluder.isFallbackElement(element)) {
                    throw new MisplacedFallbackException("Fallback element outside include element", element.getDocument().getBaseURI());
                }
                Elements elements = element.getChildElements();
                for (int i = 0; i < elements.size(); ++i) {
                    XIncluder.resolve(elements.get(i), builder, arrayList);
                }
            }
        }
    }

    private static String getDirectoryBase(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        int n = string.lastIndexOf(47);
        return string.substring(0, n + 1);
    }

    private static void verifyIncludeElement(Element element) throws XIncludeException {
        XIncluder.testHref(element);
        XIncluder.testForFragmentIdentifier(element);
        XIncluder.verifyEncoding(element);
        XIncluder.testForForbiddenChildElements(element);
    }

    private static void testHref(Element element) throws NoIncludeLocationException {
        String string = element.getAttributeValue("href");
        String string2 = element.getAttributeValue("xpointer");
        if (string == null && string2 == null) {
            throw new NoIncludeLocationException("Missing href attribute", element.getDocument().getBaseURI());
        }
    }

    private static void testForFragmentIdentifier(Element element) throws BadHrefAttributeException {
        String string = element.getAttributeValue("href");
        if (string != null && string.indexOf(35) > -1) {
            throw new BadHrefAttributeException("fragment identifier in URI " + string, element.getBaseURI());
        }
    }

    private static void verifyEncoding(Element element) throws BadEncodingAttributeException {
        String string = element.getAttributeValue("encoding");
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            throw new BadEncodingAttributeException("Empty encoding attribute", element.getBaseURI());
        }
        char c = cArray[0];
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            throw new BadEncodingAttributeException("Illegal value for encoding attribute: " + string, element.getBaseURI());
        }
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            throw new BadEncodingAttributeException("Illegal value for encoding attribute: " + string, element.getBaseURI());
        }
    }

    private static URL absolutize(URL uRL, String string) throws MalformedURLException, BadHrefAttributeException {
        Element element = new Element("c");
        String string2 = uRL.toExternalForm();
        element.setBaseURI(string2);
        Element element2 = new Element("c");
        element.appendChild(element2);
        element2.addAttribute(new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", string));
        URL uRL2 = new URL(element2.getBaseURI());
        if (!"".equals(string) && uRL2.toExternalForm().equals(string2) && !uRL.toExternalForm().endsWith(string)) {
            throw new BadHrefAttributeException(string + " is not a syntactically correct IRI");
        }
        return uRL2;
    }

    private static void testURISyntax(String string) {
        Element element = new Element("e");
        element.setNamespaceURI(string);
    }

    private static String getXMLLangValue(Element element) {
        Attribute attribute;
        while ((attribute = element.getAttribute("lang", "http://www.w3.org/XML/1998/namespace")) == null) {
            ParentNode parentNode = element.getParent();
            if (parentNode == null) {
                return "";
            }
            if (parentNode instanceof Document) {
                return "";
            }
            element = (Element)parentNode;
        }
        return attribute.getValue();
    }

    private static Nodes resolveXPointerSelection(Nodes nodes, Builder builder, ArrayList<String> arrayList, Document document) throws IOException, ParsingException, XIncludeException {
        Element element = (Element)nodes.get(0);
        return XIncluder.resolveSilently(element, builder, arrayList, document);
    }

    private static boolean contains(ParentNode parentNode, Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
            if (node2 != parentNode) continue;
            return true;
        }
        return false;
    }

    private static Nodes resolveSilently(Element element, Builder builder, ArrayList<String> arrayList, Document document) throws IOException, ParsingException, XIncludeException {
        if (XIncluder.isIncludeElement(element) || XIncluder.isFallbackElement(element)) {
            throw new RuntimeException("XOM BUG: include or fallback element passed to resolveSilently; please report with a test case");
        }
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            XIncluder.resolve(elements.get(i), builder, arrayList, document);
        }
        return new Nodes(element);
    }

    private static void testForForbiddenChildElements(Element element) throws XIncludeException {
        int n = 0;
        Elements elements = element.getChildElements();
        int n2 = elements.size();
        for (int i = 0; i < n2; ++i) {
            Element element2 = elements.get(i);
            if (!XINCLUDE_NS.equals(element2.getNamespaceURI())) continue;
            if ("fallback".equals(element2.getLocalName())) {
                if (++n <= 1) continue;
                throw new XIncludeException("Multiple fallback elements", element.getDocument().getBaseURI());
            }
            throw new XIncludeException("Include element contains an include child", element.getDocument().getBaseURI());
        }
    }

    private static void processFallback(Element element, Builder builder, ArrayList<String> arrayList, ParentNode parentNode, Exception exception) throws XIncludeException, IOException, ParsingException {
        Element element2 = element.getFirstChildElement("fallback", XINCLUDE_NS);
        if (element2 == null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            XIncludeException xIncludeException = new XIncludeException(exception.getMessage(), element.getDocument().getBaseURI());
            xIncludeException.initCause(exception);
            throw xIncludeException;
        }
        while (element2.getChildCount() > 0) {
            Node node = element2.getChild(0);
            if (node instanceof Element) {
                XIncluder.resolve((Element)node, builder, arrayList);
            }
            node = element2.getChild(0);
            node.detach();
            parentNode.insertChild(node, parentNode.indexOf(element));
        }
        element.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Nodes downloadXMLDocument(URL uRL, String string, Builder builder, ArrayList<String> arrayList, String string2, String string3, String string4) throws IOException, ParsingException, XIncludeException, XPointerSyntaxException, XPointerResourceException {
        Object object;
        Node node;
        int n;
        Nodes nodes;
        Document document;
        String string5 = uRL.toExternalForm();
        if (string == null && arrayList.indexOf(string5) != -1) {
            throw new InclusionLoopException("Tried to include the already included document " + string5 + " from " + arrayList.get(arrayList.size() - 1), arrayList.get(arrayList.size() - 1));
        }
        URLConnection uRLConnection = uRL.openConnection();
        XIncluder.setHeaders(uRLConnection, string2, string3);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            document = builder.build(bufferedInputStream, uRL.toExternalForm());
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        XIncluder.resolveInPlace(document, builder, arrayList);
        if (string != null && string.length() != 0) {
            nodes = XPointer.query(document, string);
            for (n = 0; n < nodes.size(); ++n) {
                String string6;
                node = nodes.get(n);
                object = (Element)node;
                Attribute attribute = ((Element)object).getAttribute("lang", "http://www.w3.org/XML/1998/namespace");
                if (attribute != null || string4.equals(string6 = XIncluder.getXMLLangValue((Element)object))) continue;
                ((Element)object).addAttribute(new Attribute("xml:lang", "http://www.w3.org/XML/1998/namespace", string6));
            }
        } else {
            nodes = new Nodes();
            for (n = 0; n < document.getChildCount(); ++n) {
                node = document.getChild(n);
                if (node instanceof DocType) continue;
                nodes.append(node);
            }
        }
        document.setRootElement(new Element("f"));
        for (n = 0; n < nodes.size(); ++n) {
            node = nodes.get(n);
            object = node.getBaseURI();
            if (((String)object).indexOf(35) >= 0) {
                object = ((String)object).substring(0, ((String)object).indexOf(35));
            }
            node.detach();
            if (!(node instanceof Element)) continue;
            ((Element)node).setBaseURI((String)object);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Nodes downloadTextDocument(URL uRL, String string, Builder builder, String string2, String string3) throws IOException, XIncludeException {
        if (string == null || string.length() == 0) {
            string = "UTF-8";
        }
        URLConnection uRLConnection = uRL.openConnection();
        XIncluder.setHeaders(uRLConnection, string2, string3);
        String string4 = uRLConnection.getContentEncoding();
        String string5 = uRLConnection.getContentType();
        int n = uRLConnection.getContentLength();
        if (n < 0) {
            n = 1024;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            if (string4 != null) {
                string = string4;
            } else if (string5 != null && ((string5 = string5.toLowerCase(Locale.ENGLISH)).equals("text/xml") || string5.equals("application/xml") || string5.startsWith("text/") && string5.endsWith("+xml") || string5.startsWith("application/") && string5.endsWith("+xml"))) {
                string = EncodingHeuristics.readEncodingFromStream(bufferedInputStream);
            }
            if (version.startsWith("1.2") || version.startsWith("1.1")) {
                if (string.equalsIgnoreCase("UTF-16")) {
                    ((InputStream)bufferedInputStream).mark(2);
                    int n2 = ((InputStream)bufferedInputStream).read();
                    string = n2 == 255 ? "UnicodeLittle" : "UnicodeBig";
                    ((InputStream)bufferedInputStream).reset();
                } else if (string.equalsIgnoreCase("UnicodeBigUnmarked")) {
                    string = "UnicodeBig";
                } else if (string.equalsIgnoreCase("UnicodeLittleUnmarked")) {
                    string = "UnicodeLittle";
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string));
            StringBuffer stringBuffer = new StringBuffer(n);
            int n3 = ((Reader)bufferedReader).read();
            while (n3 != -1) {
                stringBuffer.append((char)n3);
                n3 = ((Reader)bufferedReader).read();
            }
            NodeFactory nodeFactory = builder.getNodeFactory();
            if (nodeFactory != null) {
                Nodes nodes = nodeFactory.makeText(stringBuffer.toString());
                return nodes;
            }
            Nodes nodes = new Nodes(new Text(stringBuffer.toString()));
            return nodes;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    private static void setHeaders(URLConnection uRLConnection, String string, String string2) throws BadHTTPHeaderException {
        if (string != null) {
            XIncluder.checkHeader(string);
            uRLConnection.setRequestProperty("accept", string);
        }
        if (string2 != null) {
            XIncluder.checkHeader(string2);
            uRLConnection.setRequestProperty("accept-language", string2);
        }
    }

    private static void checkHeader(String string) throws BadHTTPHeaderException {
        if (string == null) {
            return;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            throw new BadHTTPHeaderException("Header contains illegal character 0x" + Integer.toHexString(c).toUpperCase());
        }
    }

    private static boolean isIncludeElement(Element element) {
        return element.getLocalName().equals("include") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }

    private static boolean isFallbackElement(Element element) {
        return element.getLocalName().equals("fallback") && element.getNamespaceURI().equals(XINCLUDE_NS);
    }
}

