/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.twm;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eu.fbk.dkm.pikes.twm.Linking;
import eu.fbk.dkm.pikes.twm.LinkingTag;
import eu.fbk.utils.core.PropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.jackson.map.ObjectMapper;

public class MachineLinking
extends Linking {
    public static final double ML_CONFIDENCE = 0.5;
    private static String LABEL = "ml-annotate";
    private Double minWeight;
    private String lang;

    public MachineLinking(Properties properties) {
        super(properties, properties.getProperty("address"));
        this.minWeight = PropertiesUtils.getDouble((String)properties.getProperty("min_confidence"), (double)0.5);
        this.lang = properties.getProperty("lang", null);
    }

    public String lang(String text) throws IOException {
        String address = this.urlAddress.replace("annotate", "lang");
        HashMap<String, String> pars = new HashMap<String, String>();
        pars.put("include_text", "0");
        pars.put("app_id", "0");
        pars.put("app_key", "0");
        pars.put("text", text);
        LOGGER.debug("Text length: {}", (Object)text.length());
        LOGGER.debug("Pars: {}", pars);
        String output = this.request(pars, address);
        ObjectMapper mapper = new ObjectMapper();
        Map userData = (Map)mapper.readValue(output, Map.class);
        LinkedHashMap annotation = (LinkedHashMap)userData.get(new String("annotation"));
        if (annotation != null) {
            String lang = annotation.get("lang").toString();
            return lang;
        }
        return null;
    }

    @Override
    public List<LinkingTag> tag(String text) throws Exception {
        ArrayList<LinkingTag> ret = new ArrayList<LinkingTag>();
        HashMap<String, String> pars = new HashMap<String, String>();
        pars.put("min_weight", this.minWeight.toString());
        pars.put("disambiguation", "1");
        pars.put("topic", "1");
        pars.put("include_text", "0");
        pars.put("image", "1");
        pars.put("class", "1");
        pars.put("app_id", "0");
        pars.put("app_key", "0");
        pars.put("text", text);
        if (this.lang != null) {
            pars.put("lang", this.lang);
        }
        LOGGER.debug("Text length: {}", (Object)text.length());
        LOGGER.debug("Pars: {}", pars);
        String output = this.request(pars);
        ObjectMapper mapper = new ObjectMapper();
        Map userData = (Map)mapper.readValue(output, Map.class);
        LinkedHashMap annotation = (LinkedHashMap)userData.get(new String("annotation"));
        if (annotation != null) {
            String lang = annotation.get("lang").toString();
            String language = lang == null || lang.equals("en") ? "" : lang + ".";
            ArrayList keywords = (ArrayList)annotation.get(new String("keyword"));
            if (keywords != null) {
                for (LinkedHashMap keyword : keywords) {
                    LinkedHashMap sense = (LinkedHashMap)keyword.get("sense");
                    ArrayList dbpClass = (ArrayList)keyword.get("class");
                    ArrayList images = (ArrayList)keyword.get("image");
                    ArrayList ngrams = (ArrayList)keyword.get("ngram");
                    for (LinkedHashMap ngram : ngrams) {
                        String originalText = (String)ngram.get("form");
                        LinkedHashMap span = (LinkedHashMap)ngram.get("span");
                        Integer start = (Integer)span.get("start");
                        Integer end = (Integer)span.get("end");
                        Double rel = Double.parseDouble(keyword.get("rel").toString());
                        if (rel.isNaN()) {
                            rel = 0.0;
                        }
                        LinkingTag tag = new LinkingTag(start, String.format("http://" + language + "dbpedia.org/resource/%s", (String)sense.get("page")), rel, originalText, end - start, LABEL);
                        if (images != null && images.size() > 0) {
                            try {
                                tag.setImage(((LinkedHashMap)images.get(0)).get("image").toString());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.extractTypes.booleanValue()) {
                            tag.addTypesFromML(dbpClass);
                        }
                        ret.add(tag);
                    }
                }
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        properties.setProperty("address", "http://ml.apnetwork.it/annotate");
        properties.setProperty("min_confidence", "0.5");
        properties.setProperty("timeout", "2000");
        String fileName = args[0];
        MachineLinking s = new MachineLinking(properties);
        try {
            String text = Files.toString((File)new File(fileName), (Charset)Charsets.UTF_8);
            List<LinkingTag> tags = s.tag(text);
            for (LinkingTag tag : tags) {
                System.out.println(tag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
    }
}

