/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dkm.pikes.twm;

import eu.fbk.dkm.pikes.twm.LinkingTag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Linking {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Linking.class);
    private static final Integer DEFAULT_TIMEOUT = 2000;
    protected String urlAddress;
    private Properties config = new Properties();
    protected Boolean extractTypes = true;

    public Linking(Properties properties, String address) {
        this.config = properties;
        this.urlAddress = address;
        if (properties.getProperty("extract_types", "1").equals("0")) {
            this.extractTypes = false;
        }
    }

    protected String request(Map<String, String> pars) throws IOException {
        return this.request(pars, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String request(Map<String, String> pars, String customAddress) throws IOException {
        HttpURLConnection connection;
        String thisRequest = "";
        String fromServer = null;
        for (String key : pars.keySet()) {
            String value = pars.get(key);
            try {
                thisRequest = thisRequest + "&" + key + "=" + URLEncoder.encode(value, "utf-8");
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        URL serverAddress = customAddress != null ? new URL(customAddress) : new URL(this.urlAddress);
        LOGGER.debug("URL: " + serverAddress);
        LOGGER.trace("Request: " + thisRequest);
        boolean useProxy = this.config.getProperty("use_proxy", "0").equals("1");
        LOGGER.debug("Send POST request");
        StringBuilder sb = new StringBuilder();
        if (useProxy) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.config.getProperty("proxy_url", ""), Integer.parseInt(this.config.getProperty("proxy_port", "0"))));
            connection = (HttpURLConnection)serverAddress.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)serverAddress.openConnection();
        }
        try {
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(Integer.parseInt(this.config.getProperty("timeout", DEFAULT_TIMEOUT.toString())));
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.getOutputStream().write(thisRequest.getBytes("UTF-8"));
            connection.connect();
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                while ((fromServer = rd.readLine()) != null) {
                    sb.append(fromServer + '\n');
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Linking error: {}", (Object)e.getMessage());
        }
        finally {
            connection.disconnect();
        }
        LOGGER.debug("Request ended");
        return sb.toString();
    }

    public abstract List<LinkingTag> tag(String var1) throws Exception;
}

