/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.heideltime.annotator;

import de.unihd.dbs.heideltime.standalone.DocumentType;
import de.unihd.dbs.heideltime.standalone.HeidelTimeStandalone;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import eu.fbk.dh.tint.heideltime.annotator.HeidelTimeAnnotations;
import eu.fbk.dh.tint.heideltime.annotator.HeidelTimeModel;
import eu.fbk.utils.core.PropertiesUtils;
import java.io.ByteArrayInputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HeidelTimeAnnotator
implements Annotator {
    HeidelTimeStandalone tagger;
    static DateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);

    public HeidelTimeAnnotator(String annotatorName, Properties props) {
        DocumentType documentType;
        String configFile = props.getProperty(annotatorName + ".config", null);
        String dtString = props.getProperty(annotatorName + ".type", "news");
        try {
            documentType = DocumentType.valueOf((String)dtString.toUpperCase());
        }
        catch (Exception e) {
            documentType = DocumentType.NEWS;
        }
        if (configFile == null) {
            Properties convertedProperties = PropertiesUtils.dotConvertedProperties((Properties)props, (String)annotatorName);
            this.tagger = HeidelTimeModel.getInstance(convertedProperties, documentType).getTagger();
        } else {
            this.tagger = HeidelTimeModel.getInstance(configFile, documentType).getTagger();
        }
    }

    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        if (text != null) {
            try {
                Date documentDate = new Date();
                try {
                    String creationDate = (String)annotation.get(CoreAnnotations.DocDateAnnotation.class);
                    documentDate = format.parse(creationDate);
                }
                catch (Exception creationDate) {
                    // empty catch block
                }
                String process = this.tagger.process(text, documentDate);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                ByteArrayInputStream textStream = new ByteArrayInputStream(process.getBytes());
                Document doc = dBuilder.parse(textStream);
                doc.getDocumentElement().normalize();
                HashMap<Integer, TimexObject> timexes = new HashMap<Integer, TimexObject>();
                ArrayList<TimexObject> finalTimexes = new ArrayList<TimexObject>();
                NodeList entries = doc.getElementsByTagName("*");
                for (int i = 1; i < entries.getLength(); ++i) {
                    Element element = (Element)entries.item(i);
                    if (!element.getNodeName().equals("heideltime:Timex3")) continue;
                    int begin = Integer.parseInt(element.getAttribute("begin"));
                    int end = Integer.parseInt(element.getAttribute("end"));
                    String timexType = element.getAttribute("timexType");
                    String timexValue = element.getAttribute("timexValue");
                    TimexObject timexObject = new TimexObject(begin, end, timexType, timexValue);
                    finalTimexes.add(timexObject);
                    timexes.put(begin, timexObject);
                }
                List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
                TimexObject timexObject = null;
                for (CoreLabel token : tokens) {
                    int begin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                    int end = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    if (timexObject != null && end > timexObject.getEnd()) {
                        timexObject = null;
                    }
                    if (timexes.containsKey(begin)) {
                        timexObject = (TimexObject)timexes.get(begin);
                    }
                    if (timexObject == null) continue;
                    token.set(CoreAnnotations.NamedEntityTagAnnotation.class, (Object)timexObject.getTimexType());
                    token.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, (Object)timexObject.getTimexValue());
                    token.set(CoreAnnotations.ValueAnnotation.class, (Object)text.substring(timexObject.getStart(), timexObject.getEnd()));
                }
                annotation.set(HeidelTimeAnnotations.TimexesAnnotation.class, finalTimexes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.singleton(CoreAnnotations.TokensAnnotation.class);
    }

    class TimexObject {
        private int start;
        private int end;
        private String timexType;
        private String timexValue;

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String getTimexType() {
            return this.timexType;
        }

        public void setTimexType(String timexType) {
            this.timexType = timexType;
        }

        public String getTimexValue() {
            return this.timexValue;
        }

        public void setTimexValue(String timexValue) {
            this.timexValue = timexValue;
        }

        public TimexObject(int start, int end, String timexType, String timexValue) {
            this.start = start;
            this.end = end;
            this.timexType = timexType;
            this.timexValue = timexValue;
        }
    }
}

