/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.dh.tint.splitter;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.StringUtils;
import eu.fbk.utils.core.PropertiesUtils;
import eu.fbk.utils.corenlp.CustomAnnotations;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SplitterAnnotator
implements Annotator {
    public Map<String, String[]> preps = new HashMap<String, String[]>();
    public static Set<String> clitics = new HashSet<String>();
    private Boolean preserveCasing;

    public SplitterAnnotator(String annotatorName, Properties props) {
        this.preserveCasing = PropertiesUtils.getBoolean((String)props.getProperty(annotatorName + ".preserveCasing"), (boolean)true);
        try {
            String line;
            InputStream stream = this.getClass().getResourceAsStream("/preps.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length < 3) continue;
                this.preps.put(parts[0], new String[]{parts[1], parts[2]});
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void annotate(Annotation annotation) {
        ArrayList<CoreLabel> finalDocumentTokens = new ArrayList<CoreLabel>();
        int sentNum = 0;
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            ArrayList<CoreLabel> newSentenceTokens = new ArrayList<CoreLabel>();
            int sentenceIndex = 1;
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String[] parts = pos.split("\\+");
                if (parts.length > 1) {
                    int i;
                    boolean isCoarse = false;
                    String[] uparts = new String[]{};
                    if (token.containsKey(CoreAnnotations.CoarseTagAnnotation.class)) {
                        uparts = ((String)token.get(CoreAnnotations.CoarseTagAnnotation.class)).split("\\+");
                        isCoarse = true;
                    }
                    if (pos.equals("E+RD")) {
                        String[] textparts = (String[])Arrays.copyOf((Object[])this.preps.get(token.originalText().toLowerCase()), this.preps.get(token.originalText().toLowerCase()).length);
                        this.applyCase(textparts, token.originalText());
                        for (int i2 = 0; i2 < textparts.length; ++i2) {
                            String word = textparts[i2];
                            String upart = null;
                            if (isCoarse) {
                                upart = uparts[i2];
                            }
                            this.addToken(word, token, sentenceIndex, sentNum, parts[i2], upart, isCoarse, i2 == 0, parts.length, newSentenceTokens, finalDocumentTokens);
                            ++sentenceIndex;
                        }
                        continue;
                    }
                    String text = token.originalText().toLowerCase();
                    String[] textparts = new String[parts.length];
                    block3: for (i = parts.length - 1; i > 0; --i) {
                        for (String clitic : clitics) {
                            if (!text.endsWith(clitic)) continue;
                            textparts[i] = clitic;
                            text = text.substring(0, text.length() - clitic.length());
                            continue block3;
                        }
                    }
                    textparts[0] = text;
                    this.applyCase(textparts, token.originalText());
                    textparts = (String[])Arrays.stream(textparts).filter(s -> s != null && s.length() > 0).toArray(String[]::new);
                    int textpartsLength = textparts.length;
                    for (i = 0; i < textpartsLength; ++i) {
                        String word = textparts[i];
                        String upart = null;
                        if (isCoarse) {
                            upart = uparts[i];
                        }
                        this.addToken(word, token, sentenceIndex, sentNum, parts[i], upart, isCoarse, i == 0, parts.length, newSentenceTokens, finalDocumentTokens);
                        ++sentenceIndex;
                    }
                    continue;
                }
                token.setIndex(sentenceIndex);
                token.setIsMWT(false);
                token.setIsMWTFirst(false);
                newSentenceTokens.add(token);
                finalDocumentTokens.add(token);
                ++sentenceIndex;
            }
            sentence.set(CoreAnnotations.TokenEndAnnotation.class, (Object)finalDocumentTokens.size());
            sentence.set(CoreAnnotations.TokensAnnotation.class, newSentenceTokens);
            ++sentNum;
        }
        annotation.set(CoreAnnotations.TokensAnnotation.class, finalDocumentTokens);
    }

    private void applyCase(String[] textparts, String text) {
        if (this.preserveCasing.booleanValue()) {
            if (StringUtils.isAllUpperCase((String)text)) {
                String[] newTextparts = (String[])Arrays.stream(textparts).map(String::toUpperCase).toArray(String[]::new);
                for (int i = 0; i < newTextparts.length; ++i) {
                    String part;
                    textparts[i] = part = newTextparts[i];
                }
            } else if (StringUtils.isTitleCase((String)text)) {
                textparts[0] = StringUtils.toTitleCase((String)textparts[0]);
            }
        }
    }

    private void addToken(String word, CoreLabel token, int sentenceIndex, int sentNum, String part, String upart, boolean isCoarse, boolean isFirst, int length, List<CoreLabel> newSentenceTokens, List<CoreLabel> finalDocumentTokens) {
        CoreLabel newToken = new CoreLabel(token);
        newToken.setWord(word);
        newToken.setValue(word);
        newToken.setIndex(sentenceIndex);
        newToken.setSentIndex(sentNum);
        newToken.set(CoreAnnotations.PartOfSpeechAnnotation.class, (Object)part);
        if (isCoarse) {
            newToken.set(CoreAnnotations.CoarseTagAnnotation.class, (Object)upart);
            newToken.set(CustomAnnotations.UPosAnnotation.class, (Object)upart);
        }
        newToken.set(CoreAnnotations.MWTTokenTextAnnotation.class, (Object)token.word());
        newToken.setIsMWT(true);
        if (isFirst) {
            newToken.setIsMWTFirst(true);
            newToken.set(CoreAnnotations.CoNLLUTokenSpanAnnotation.class, (Object)new IntPair(newToken.index(), newToken.index() + length - 1));
        } else {
            newToken.setIsMWTFirst(false);
        }
        newSentenceTokens.add(newToken);
        finalDocumentTokens.add(newToken);
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    static {
        clitics.add("li");
        clitics.add("lo");
        clitics.add("la");
        clitics.add("le");
        clitics.add("ci");
        clitics.add("vi");
        clitics.add("ti");
        clitics.add("mi");
        clitics.add("si");
        clitics.add("ne");
        clitics.add("gli");
        clitics.add("ce");
        clitics.add("me");
        clitics.add("te");
        clitics.add("ve");
        clitics.add("se");
        clitics.add("glie");
    }
}

