/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class TreebankTagUpdater {
    public MaxentTagger maxentTagger;

    public TreebankTagUpdater(String taggerPath) {
        this.maxentTagger = new MaxentTagger(taggerPath);
    }

    public void tagTree(Tree tree) {
        List<Tree> tagsAndWords = this.getTaggedLeaves(tree);
        assert (tagsAndWords.size() == tree.getLeaves().size());
        List<CoreLabel> sentence = tagsAndWords.stream().map(w -> ((Tree)w.getLeaves().get(0)).value()).map(w -> CoreLabel.wordFromString(w)).collect(Collectors.toList());
        this.maxentTagger.tagCoreLabels(sentence);
        assert (tree.getLeaves().size() == sentence.size());
        for (int i = 0; i < sentence.size(); ++i) {
            tagsAndWords.get(i).setValue(sentence.get(i).tag());
        }
    }

    public List<Tree> getTaggedLeaves(Tree tree) {
        if (tree.isPreTerminal()) {
            return Arrays.asList(tree);
        }
        ArrayList<Tree> returnList = new ArrayList<Tree>();
        for (Tree c : tree.getChildrenAsList()) {
            returnList.addAll(this.getTaggedLeaves(c));
        }
        return returnList;
    }

    public static void main(String[] args) throws IOException {
        Properties props = StringUtils.argsToProperties(args);
        String taggerPath = props.getProperty("tagger");
        String treeFilePath = props.getProperty("treeFile");
        TreebankTagUpdater updater = new TreebankTagUpdater(taggerPath);
        LabeledScoredTreeFactory tf = new LabeledScoredTreeFactory();
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(treeFilePath), "UTF-8"));
        PennTreeReader tr = new PennTreeReader(r, tf);
        Tree t = tr.readTree();
        while (t != null) {
            updater.tagTree(t);
            System.out.println(t);
            t = tr.readTree();
        }
    }
}

