/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.QuoteAttributionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Sieve {
    private static final Redwood.RedwoodChannels log = Redwood.channels(Sieve.class);
    protected final Annotation doc;
    protected final Map<String, List<Person>> characterMap;
    protected final Map<Integer, String> pronounCorefMap;
    protected final Set<String> animacySet;
    public static final String PRONOUN = "pronoun";
    public static final String NAME = "name";
    public static final String ANIMATE_NOUN = "animate noun";
    protected TokenNode rootNameNode;

    public Sieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        this.doc = doc;
        this.characterMap = characterMap;
        this.pronounCorefMap = pronounCorefMap;
        this.animacySet = animacySet;
        this.rootNameNode = this.createNameMatcher();
    }

    protected Person resolveAmbiguities(String name) {
        if (this.characterMap.get(name) == null) {
            return null;
        }
        if (this.characterMap.get(name).size() == 1) {
            return this.characterMap.get(name).get(0);
        }
        return null;
    }

    protected Set<Person> getNamesInParagraph(CoreMap quote) {
        int quoteIndex;
        CoreMap currQuote;
        int currQuoteParagraph;
        int i;
        List quotes = (List)this.doc.get(CoreAnnotations.QuotationsAnnotation.class);
        ArrayList quoteNames = new ArrayList();
        int quoteParagraph = QuoteAttributionUtils.getQuoteParagraphIndex(this.doc, quote);
        for (i = quoteIndex = ((Integer)quote.get(CoreAnnotations.QuotationIndexAnnotation.class)).intValue(); i >= 0 && (currQuoteParagraph = QuoteAttributionUtils.getQuoteParagraphIndex(this.doc, currQuote = (CoreMap)quotes.get(i))) == quoteParagraph; --i) {
            quoteNames.addAll((Collection)this.scanForNames(new Pair<Integer, Integer>(currQuote.get(CoreAnnotations.TokenBeginAnnotation.class), currQuote.get(CoreAnnotations.TokenEndAnnotation.class))).first);
        }
        for (i = quoteIndex + 1; i < quotes.size() && (currQuoteParagraph = QuoteAttributionUtils.getQuoteParagraphIndex(this.doc, currQuote = (CoreMap)quotes.get(i))) == quoteParagraph; ++i) {
            quoteNames.addAll((Collection)this.scanForNames(new Pair<Integer, Integer>(currQuote.get(CoreAnnotations.TokenBeginAnnotation.class), currQuote.get(CoreAnnotations.TokenEndAnnotation.class))).first);
        }
        HashSet<Person> namesInParagraph = new HashSet<Person>();
        for (String name : quoteNames) {
            namesInParagraph.addAll((Collection<Person>)this.characterMap.get(name));
        }
        return namesInParagraph;
    }

    public Person doCoreference(int corefMapKey, CoreMap quote) {
        String referent;
        Person candidate;
        if (this.pronounCorefMap == null) {
            log.warn("QuoteAttribution doCoreference: Null pronounCorefMap");
            return null;
        }
        Set<Object> quoteNames = new HashSet();
        if (quote != null) {
            quoteNames = this.getNamesInParagraph(quote);
        }
        if ((candidate = this.resolveAmbiguities(referent = this.pronounCorefMap.get(corefMapKey))) != null && !quoteNames.contains(candidate)) {
            return candidate;
        }
        return null;
    }

    protected TokenNode createNameMatcher() {
        TokenNode rootNode = new TokenNode("$ROOT", -1);
        for (String key : this.characterMap.keySet()) {
            String[] tokens = key.split(" ");
            TokenNode currNode = rootNode;
            for (int i = 0; i < tokens.length; ++i) {
                String tok = tokens[i];
                if (currNode.childNodes.containsKey(tok)) {
                    currNode = currNode.childNodes.get(tok);
                } else {
                    TokenNode newNode = new TokenNode(tok, i);
                    currNode.childNodes.put(tok, newNode);
                    currNode = newNode;
                }
                if (i != tokens.length - 1) continue;
                currNode.personList = this.characterMap.get(key);
                currNode.fullName = key;
            }
        }
        return rootNode;
    }

    public Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> scanForNamesNew(Pair<Integer, Integer> textRun) {
        int index;
        ArrayList<String> potentialNames = new ArrayList<String>();
        ArrayList<Pair<Integer, Integer>> nameIndices = new ArrayList<Pair<Integer, Integer>>();
        List tokens = (List)this.doc.get(CoreAnnotations.TokensAnnotation.class);
        TokenNode pointer = this.rootNameNode;
        for (index = ((Integer)textRun.first).intValue(); index <= (Integer)textRun.second && index < tokens.size(); ++index) {
            CoreLabel token = (CoreLabel)tokens.get(index);
            String tokenText = token.word();
            if (pointer.childNodes.containsKey(tokenText)) {
                pointer = pointer.childNodes.get(tokenText);
                continue;
            }
            if (pointer.token.equals("$ROOT")) continue;
            if (pointer.fullName != null) {
                potentialNames.add(pointer.fullName);
                nameIndices.add(new Pair<Integer, Integer>(index - 1 - pointer.level, index - 1));
            }
            pointer = this.rootNameNode;
        }
        index = (Integer)textRun.second + 1;
        if (!pointer.token.equals("$ROOT") && pointer.fullName != null) {
            potentialNames.add(pointer.fullName);
            nameIndices.add(new Pair<Integer, Integer>(index - 1 - pointer.level, index - 1));
        }
        return new Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>>(potentialNames, nameIndices);
    }

    public Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>> scanForNames(Pair<Integer, Integer> textRun) {
        ArrayList<String> potentialNames = new ArrayList<String>();
        ArrayList<Pair<Integer, Integer>> nameIndices = new ArrayList<Pair<Integer, Integer>>();
        List tokens = (List)this.doc.get(CoreAnnotations.TokensAnnotation.class);
        Set<String> aliases = this.characterMap.keySet();
        String potentialName = "";
        Pair<Integer, Integer> potentialIndex = null;
        for (int index = ((Integer)textRun.first).intValue(); index <= (Integer)textRun.second; ++index) {
            CoreLabel token = (CoreLabel)tokens.get(index);
            String tokenText = token.word();
            String ner = token.ner();
            if (ner.equals("PERSON")) {
                potentialName = potentialName.isEmpty() ? tokenText : potentialName + " " + tokenText;
                if (potentialIndex == null) {
                    potentialIndex = new Pair<Integer, Integer>(index, index);
                    continue;
                }
                potentialIndex.second = index;
                continue;
            }
            if (potentialName.isEmpty()) continue;
            if (aliases.contains(potentialName)) {
                potentialNames.add(potentialName);
                nameIndices.add(potentialIndex);
            } else {
                String removeFirstWord = potentialName.substring(potentialName.indexOf(" ") + 1);
                if (aliases.contains(removeFirstWord)) {
                    potentialNames.add(removeFirstWord);
                    nameIndices.add(new Pair((Integer)potentialIndex.first + 1, potentialIndex.second));
                }
            }
            potentialName = "";
            potentialIndex = null;
        }
        if (!potentialName.isEmpty() && aliases.contains(potentialName)) {
            potentialNames.add(potentialName);
            nameIndices.add(potentialIndex);
        }
        return new Pair<ArrayList<String>, ArrayList<Pair<Integer, Integer>>>(potentialNames, nameIndices);
    }

    protected ArrayList<Integer> scanForPronouns(Pair<Integer, Integer> nonQuoteRun) {
        List tokens = (List)this.doc.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<Integer> pronounList = new ArrayList<Integer>();
        for (int i = ((Integer)nonQuoteRun.first).intValue(); i <= (Integer)nonQuoteRun.second && i < tokens.size(); ++i) {
            if (!((CoreLabel)tokens.get(i)).word().equalsIgnoreCase("he") && !((CoreLabel)tokens.get(i)).word().equalsIgnoreCase("she")) continue;
            pronounList.add(i);
        }
        return pronounList;
    }

    protected ArrayList<Integer> scanForPronouns(ArrayList<Pair<Integer, Integer>> nonQuoteRuns) {
        ArrayList<Integer> pronounList = new ArrayList<Integer>();
        for (Pair<Integer, Integer> nonQuoteRun : nonQuoteRuns) {
            pronounList.addAll(this.scanForPronouns(nonQuoteRun));
        }
        return pronounList;
    }

    public String tokenRangeToString(Pair<Integer, Integer> tokenRange) {
        List tokens = (List)this.doc.get(CoreAnnotations.TokensAnnotation.class);
        List entityMentionsInDoc = (List)this.doc.get(CoreAnnotations.MentionsAnnotation.class);
        Integer potentialMatchingEntityMentionIndex = (Integer)((CoreLabel)tokens.get((Integer)tokenRange.first)).get(CoreAnnotations.EntityMentionIndexAnnotation.class);
        TypesafeMap potentialMatchingEntityMention = null;
        if (entityMentionsInDoc != null && potentialMatchingEntityMentionIndex != null) {
            potentialMatchingEntityMention = (CoreMap)entityMentionsInDoc.get(potentialMatchingEntityMentionIndex);
        }
        if (potentialMatchingEntityMention != null && ((Integer)potentialMatchingEntityMention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)).intValue() == ((CoreLabel)tokens.get((Integer)tokenRange.first)).beginPosition() && ((Integer)potentialMatchingEntityMention.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)).intValue() == ((CoreLabel)tokens.get((Integer)tokenRange.second)).endPosition()) {
            return (String)potentialMatchingEntityMention.get(CoreAnnotations.TextAnnotation.class);
        }
        return ((String)this.doc.get(CoreAnnotations.TextAnnotation.class)).substring(((CoreLabel)tokens.get((Integer)tokenRange.first)).beginPosition(), ((CoreLabel)tokens.get((Integer)tokenRange.second)).endPosition());
    }

    public String tokenRangeToString(int token_idx) {
        return ((CoreLabel)((List)this.doc.get(CoreAnnotations.TokensAnnotation.class)).get(token_idx)).word();
    }

    public MentionData findClosestMentionInSpanForward(Pair<Integer, Integer> span) {
        ArrayList<Integer> pronounIndices = this.scanForPronouns(span);
        List nameIndices = (List)this.scanForNamesNew(span).second;
        List<Integer> animacyIndices = this.scanForAnimates(span);
        int closestPronounIndex = Integer.MAX_VALUE;
        int closestAnimate = Integer.MAX_VALUE;
        Pair closestNameIndex = new Pair(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (pronounIndices.size() > 0) {
            closestPronounIndex = (Integer)pronounIndices.get(0);
        }
        if (nameIndices.size() > 0) {
            closestNameIndex = (Pair)nameIndices.get(0);
        }
        if (animacyIndices.size() > 0) {
            closestAnimate = animacyIndices.get(0);
        }
        MentionData md = null;
        if (closestPronounIndex < (Integer)closestNameIndex.first) {
            md = closestAnimate < closestPronounIndex ? new MentionData(closestAnimate, closestAnimate, this.tokenRangeToString(closestAnimate), ANIMATE_NOUN) : new MentionData(closestPronounIndex, closestPronounIndex, this.tokenRangeToString(closestPronounIndex), PRONOUN);
        } else if (closestPronounIndex > (Integer)closestNameIndex.first) {
            md = closestAnimate < (Integer)closestNameIndex.first ? new MentionData(closestAnimate, closestAnimate, this.tokenRangeToString(closestAnimate), ANIMATE_NOUN) : new MentionData((Integer)closestNameIndex.first, (Integer)closestNameIndex.second, this.tokenRangeToString(closestNameIndex), NAME);
        }
        return md;
    }

    public MentionData findClosestMentionInSpanBackward(Pair<Integer, Integer> span) {
        ArrayList<Integer> pronounIndices = this.scanForPronouns(span);
        List nameIndices = (List)this.scanForNamesNew(span).second;
        List<Integer> animateIndices = this.scanForAnimates(span);
        int closestPronounIndex = Integer.MIN_VALUE;
        int closestAnimate = Integer.MIN_VALUE;
        Pair closestNameIndex = new Pair(Integer.MIN_VALUE, Integer.MIN_VALUE);
        if (pronounIndices.size() > 0) {
            closestPronounIndex = (Integer)pronounIndices.get(pronounIndices.size() - 1);
        }
        if (nameIndices.size() > 0) {
            closestNameIndex = (Pair)nameIndices.get(nameIndices.size() - 1);
        }
        if (animateIndices.size() > 0) {
            closestAnimate = animateIndices.get(animateIndices.size() - 1);
        }
        MentionData md = null;
        if (closestPronounIndex > (Integer)closestNameIndex.second) {
            md = closestAnimate > closestPronounIndex ? new MentionData(closestAnimate, closestAnimate, this.tokenRangeToString(closestAnimate), ANIMATE_NOUN) : new MentionData(closestPronounIndex, closestPronounIndex, this.tokenRangeToString(closestPronounIndex), PRONOUN);
        } else if (closestPronounIndex < (Integer)closestNameIndex.second) {
            md = closestAnimate > (Integer)closestNameIndex.second ? new MentionData(closestAnimate, closestAnimate, this.tokenRangeToString(closestAnimate), ANIMATE_NOUN) : new MentionData((Integer)closestNameIndex.first, (Integer)closestNameIndex.second, this.tokenRangeToString(closestNameIndex), NAME);
        }
        return md;
    }

    public List<MentionData> findClosestMentionsInSpanForward(Pair<Integer, Integer> span) {
        MentionData mention;
        ArrayList<MentionData> mentions = new ArrayList<MentionData>();
        Pair<Integer, Integer> currSpan = span;
        while ((mention = this.findClosestMentionInSpanForward(currSpan)) != null) {
            mentions.add(mention);
            currSpan.first = mention.end + 1;
        }
        return mentions;
    }

    public List<MentionData> findClosestMentionsInSpanBackward(Pair<Integer, Integer> span) {
        MentionData mentionData;
        ArrayList<MentionData> mentions = new ArrayList<MentionData>();
        Pair<Integer, Integer> currSpan = span;
        while ((mentionData = this.findClosestMentionInSpanBackward(currSpan)) != null) {
            mentions.add(mentionData);
            currSpan.second = mentionData.begin - 1;
        }
        return mentions;
    }

    public List<Integer> scanForAnimates(Pair<Integer, Integer> span) {
        ArrayList<Integer> animateIndices = new ArrayList<Integer>();
        List tokens = (List)this.doc.get(CoreAnnotations.TokensAnnotation.class);
        for (int i = ((Integer)span.first).intValue(); i <= (Integer)span.second && i < tokens.size(); ++i) {
            CoreLabel token = (CoreLabel)tokens.get(i);
            if (!this.animacySet.contains(token.word())) continue;
            animateIndices.add(i);
        }
        return animateIndices;
    }

    public void oneSpeakerSentence(Annotation doc) {
        List toks = (List)doc.get(CoreAnnotations.TokensAnnotation.class);
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        HashMap quotesBySentence = new HashMap();
        for (CoreMap quote : quotes) {
            int quoteBeginTok = (Integer)quote.get(CoreAnnotations.TokenBeginAnnotation.class);
            int sentenceBeginId = ((CoreLabel)toks.get(quoteBeginTok)).sentIndex();
            int quoteEndTok = (Integer)quote.get(CoreAnnotations.TokenEndAnnotation.class);
            int sentenceEndId = ((CoreLabel)toks.get(quoteEndTok)).sentIndex();
            quotesBySentence.putIfAbsent(sentenceBeginId, new ArrayList());
            quotesBySentence.putIfAbsent(sentenceEndId, new ArrayList());
            ((List)quotesBySentence.get(sentenceBeginId)).add(quote);
            ((List)quotesBySentence.get(sentenceEndId)).add(quote);
        }
        Iterator<Object> iterator = quotesBySentence.keySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            List quotesInSent = (List)quotesBySentence.get(k);
            ArrayList<Mention> existantMentions = new ArrayList<Mention>();
            for (CoreMap quote : quotesInSent) {
                if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) == null) continue;
                Mention m = new Mention((Integer)quote.get(QuoteAttributionAnnotator.MentionBeginAnnotation.class), (Integer)quote.get(QuoteAttributionAnnotator.MentionEndAnnotation.class), (String)quote.get(QuoteAttributionAnnotator.MentionAnnotation.class), (String)quote.get(QuoteAttributionAnnotator.MentionTypeAnnotation.class));
                existantMentions.add(m);
            }
            boolean same = true;
            String text = null;
            for (Mention m : existantMentions) {
                if (text == null) {
                    text = m.text;
                }
                if (m.text.equalsIgnoreCase(text)) continue;
                same = false;
            }
            if (!same || text == null || existantMentions.size() <= 0) continue;
            for (CoreMap quote : quotesInSent) {
                if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) continue;
                Mention firstM = (Mention)existantMentions.get(0);
                quote.set(QuoteAttributionAnnotator.MentionAnnotation.class, firstM.text);
                quote.set(QuoteAttributionAnnotator.MentionBeginAnnotation.class, firstM.begin);
                quote.set(QuoteAttributionAnnotator.MentionEndAnnotation.class, firstM.end);
                quote.set(QuoteAttributionAnnotator.MentionSieveAnnotation.class, "Deterministic one speaker sentence");
                quote.set(QuoteAttributionAnnotator.MentionTypeAnnotation.class, firstM.type);
            }
        }
    }

    public boolean rangeContainsCharIndex(Pair<Integer, Integer> tokenRange, int charIndex) {
        List tokens = (List)this.doc.get(CoreAnnotations.TokensAnnotation.class);
        CoreLabel startToken = (CoreLabel)tokens.get(tokenRange.first());
        CoreLabel endToken = (CoreLabel)tokens.get(tokenRange.second());
        int startTokenCharBegin = startToken.beginPosition();
        int endTokenCharEnd = endToken.endPosition();
        return startTokenCharBegin <= charIndex && charIndex <= endTokenCharEnd;
    }

    public int tokenToLocation(CoreLabel token) {
        CoreMap sentence = (CoreMap)((List)this.doc.get(CoreAnnotations.SentencesAnnotation.class)).get((Integer)token.get(CoreAnnotations.SentenceIndexAnnotation.class));
        return (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class) + (Integer)token.get(CoreAnnotations.IndexAnnotation.class) - 1;
    }

    protected int getQuoteParagraph(CoreMap quote) {
        List sentences = (List)this.doc.get(CoreAnnotations.SentencesAnnotation.class);
        return (Integer)((CoreMap)sentences.get((Integer)quote.get(CoreAnnotations.SentenceBeginAnnotation.class))).get(CoreAnnotations.ParagraphIndexAnnotation.class);
    }

    private static class Mention {
        public int begin;
        public int end;
        public String text;
        public String type;

        public Mention(int begin, int end, String text, String type) {
            this.begin = begin;
            this.end = end;
            this.text = text;
            this.type = type;
        }
    }

    public static class MentionData {
        public int begin;
        public int end;
        public String text;
        public String type;

        public MentionData(int begin, int end, String text, String type) {
            this.begin = begin;
            this.end = end;
            this.text = text;
            this.type = type;
        }

        public String toString() {
            return "MentionData{begin=" + this.begin + ", end=" + this.end + ", text='" + this.text + '\'' + ", type='" + this.type + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MentionData that = (MentionData)o;
            return this.begin == that.begin && this.end == that.end && Objects.equals(this.text, that.text) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.begin, this.end, this.text, this.type);
        }
    }

    private static class TokenNode {
        public List<Person> personList;
        public HashMap<String, TokenNode> childNodes;
        public String token;
        public String fullName;
        int level;

        public TokenNode(String token, int level) {
            this.token = token;
            this.level = level;
            this.childNodes = new HashMap();
        }
    }
}

