/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution.Sieves.MSSieves;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Person;
import edu.stanford.nlp.quoteattribution.Sieves.MSSieves.MSSieve;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LooseConversationalSpeakerSieve
extends MSSieve {
    public LooseConversationalSpeakerSieve(Annotation doc, Map<String, List<Person>> characterMap, Map<Integer, String> pronounCorefMap, Set<String> animacySet) {
        super(doc, characterMap, pronounCorefMap, animacySet);
    }

    @Override
    public void doMentionToSpeaker(Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        ArrayList skipChains = new ArrayList();
        ArrayList<Pair<Integer, Integer>> currChain = new ArrayList<Pair<Integer, Integer>>();
        for (int quote_idx = 0; quote_idx < quotes.size(); ++quote_idx) {
            CoreMap coreMap = (CoreMap)quotes.get(quote_idx);
            if (coreMap.get(QuoteAttributionAnnotator.SpeakerAnnotation.class) == null) continue;
            int para_idx = this.getQuoteParagraph(coreMap);
            if (currChain.size() != 0 && (Integer)((Pair)currChain.get((int)(currChain.size() - 1))).second != para_idx - 2) {
                skipChains.add(currChain);
                currChain = new ArrayList();
            }
            currChain.add(new Pair<Integer, Integer>(quote_idx, para_idx));
        }
        if (currChain.size() != 0) {
            skipChains.add(currChain);
        }
        for (List list : skipChains) {
            Pair firstPair = (Pair)list.get(0);
            int firstParagraph = (Integer)firstPair.second;
            for (int prev_idx = (Integer)firstPair.first - 1; prev_idx >= 0; --prev_idx) {
                CoreMap quote = (CoreMap)quotes.get(prev_idx + 1);
                CoreMap prevQuote = (CoreMap)quotes.get(prev_idx);
                if (this.getQuoteParagraph(prevQuote) != firstParagraph - 2) continue;
                quote.set(QuoteAttributionAnnotator.SpeakerAnnotation.class, prevQuote.get(QuoteAttributionAnnotator.SpeakerAnnotation.class));
                quote.set(QuoteAttributionAnnotator.SpeakerSieveAnnotation.class, "Loose Conversational Speaker");
            }
        }
    }
}

